/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.interfaces;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.interfaces.BaseDialog;
import com.kongzue.dialogx.util.views.ExtendChildLayoutParamsFrameLayout;
import java.security.SecureRandom;

public abstract class OnBindView<D> {
    int layoutResId;
    View customView;
    private final int PARENT_FLAG = -109;
    private androidx.fragment.app.Fragment fragment;
    private Fragment supportFragment;
    private int fragmentParentId = -1;
    private int dialogHash;
    private int parentViewHash;
    private Runnable waitBindRunnable;

    public OnBindView(int layoutResId) {
        if (BaseDialog.getTopActivity() == null) {
            DialogX.error("DialogX.init: \u521d\u59cb\u5316\u5f02\u5e38\uff0ccontext \u4e3a null \u6216\u672a\u521d\u59cb\u5316\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b https://github.com/kongzue/DialogX/wiki");
            return;
        }
        this.layoutResId = layoutResId;
        this.customView = LayoutInflater.from((Context)BaseDialog.getTopActivity()).inflate(layoutResId, (ViewGroup)new RelativeLayout((Context)BaseDialog.getTopActivity()), false);
    }

    public OnBindView(final int layoutResId, boolean async) {
        if (BaseDialog.getTopActivity() == null) {
            DialogX.error("DialogX.init: \u521d\u59cb\u5316\u5f02\u5e38\uff0ccontext \u4e3a null \u6216\u672a\u521d\u59cb\u5316\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b https://github.com/kongzue/DialogX/wiki");
            return;
        }
        this.layoutResId = layoutResId;
        if (async) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    super.run();
                    OnBindView onBindView = OnBindView.this;
                    synchronized (onBindView) {
                        OnBindView.this.customView = LayoutInflater.from((Context)BaseDialog.getTopActivity()).inflate(layoutResId, (ViewGroup)new RelativeLayout((Context)BaseDialog.getTopActivity()), false);
                        if (OnBindView.this.waitBindRunnable != null) {
                            OnBindView.this.waitBindRunnable.run();
                            OnBindView.this.waitBindRunnable = null;
                        }
                    }
                }
            }.start();
        } else {
            this.customView = LayoutInflater.from((Context)BaseDialog.getTopActivity()).inflate(layoutResId, (ViewGroup)new RelativeLayout((Context)BaseDialog.getTopActivity()), false);
        }
    }

    public OnBindView(View customView) {
        this.customView = customView;
    }

    private int getFragmentParentId() {
        if (this.fragmentParentId == -1) {
            this.fragmentParentId = this.createFragmentParentId();
        }
        return this.fragmentParentId;
    }

    private int createFragmentParentId() {
        this.fragmentParentId = new SecureRandom().nextInt();
        View somebodyView = BaseDialog.getTopActivity().findViewById(this.fragmentParentId);
        if (somebodyView != null) {
            return this.createFragmentParentId();
        }
        return this.fragmentParentId;
    }

    public OnBindView(androidx.fragment.app.Fragment fragment) {
        if (BaseDialog.getTopActivity() == null) {
            return;
        }
        this.customView = new ExtendChildLayoutParamsFrameLayout((Context)BaseDialog.getTopActivity());
        this.customView.setId(this.getFragmentParentId());
        this.fragment = fragment;
        this.supportFragment = null;
    }

    public OnBindView(Fragment supportFragment) {
        if (BaseDialog.getTopActivity() == null) {
            return;
        }
        this.customView = new ExtendChildLayoutParamsFrameLayout((Context)BaseDialog.getTopActivity());
        this.customView.setId(this.getFragmentParentId());
        this.supportFragment = supportFragment;
        this.fragment = null;
    }

    public abstract void onBind(D var1, View var2);

    public void setEvent(D dialog, View v) {
    }

    public void onFragmentBind(D dialog, View frameLayout, androidx.fragment.app.Fragment fragment, FragmentManager fragmentManager) {
    }

    public void onFragmentBind(D dialog, View frameLayout, Fragment fragment, android.app.FragmentManager fragmentManager) {
    }

    public int getLayoutResId() {
        return this.layoutResId;
    }

    public OnBindView<D> setLayoutResId(int layoutResId) {
        this.layoutResId = layoutResId;
        return this;
    }

    public View getCustomView() {
        if (this.customView == null) {
            this.customView = LayoutInflater.from((Context)BaseDialog.getTopActivity()).inflate(this.layoutResId, (ViewGroup)new RelativeLayout((Context)BaseDialog.getTopActivity()), false);
        }
        return this.customView;
    }

    public OnBindView<D> setCustomView(View customView) {
        this.customView = customView;
        return this;
    }

    public void clean() {
        this.layoutResId = 0;
        this.customView = null;
    }

    @Deprecated
    public void bindParent(ViewGroup parentView) {
        ViewGroup.LayoutParams lp;
        if (this.getCustomView() == null) {
            this.waitBind(parentView, null);
            return;
        }
        if (this.getCustomView().getParent() != null) {
            if (this.getCustomView().getParent() == parentView) {
                return;
            }
            ((ViewGroup)this.getCustomView().getParent()).removeView(this.getCustomView());
        }
        if ((lp = parentView.getLayoutParams()) == null) {
            lp = new RelativeLayout.LayoutParams(-1, -2);
        }
        parentView.addView(this.getCustomView(), lp);
    }

    public void bindParent(ViewGroup parentView, final BaseDialog dialog) {
        ViewGroup.LayoutParams lp;
        if (this.getCustomView() == null) {
            this.waitBind(parentView, null);
            return;
        }
        if (this.getCustomView().getParent() == parentView || parentView.getTag(-109) == this.getCustomView().toString()) {
            return;
        }
        if (this.getCustomView().getParent() != null) {
            ((ViewGroup)this.getCustomView().getParent()).removeView(this.getCustomView());
        }
        if ((lp = this.getCustomView().getLayoutParams()) == null) {
            lp = new RelativeLayout.LayoutParams(-1, -2);
        }
        parentView.addView(this.getCustomView(), lp);
        this.onBind(dialog, this.getCustomView());
        this.callSetEvent(dialog, this.getCustomView());
        if (this.fragment != null || this.supportFragment != null) {
            if (dialog.getDialogImplMode() != DialogX.IMPL_MODE.VIEW) {
                BaseDialog.error(dialog.dialogKey() + "\u975e VIEW \u5b9e\u73b0\u6a21\u5f0f\u4e0d\u652f\u6301 fragment \u4f5c\u4e3a\u5b50\u5e03\u5c40\u663e\u793a\u3002\n\u5176\u539f\u56e0\u4e3a Window \u4e2d\u4e0d\u5b58\u5728 FragmentManager\uff0c\u65e0\u6cd5\u5bf9\u5b50\u5e03\u5c40\u4e2d\u7684 fragment \u8fdb\u884c\u7ba1\u7406\u3002");
                return;
            }
            this.getCustomView().post(new Runnable(){

                @Override
                public void run() {
                    FragmentTransaction transaction;
                    if (OnBindView.this.fragment != null && OnBindView.this.getCustomView() instanceof FrameLayout && dialog.getOwnActivity() instanceof AppCompatActivity) {
                        AppCompatActivity appCompatActivity = (AppCompatActivity)dialog.getOwnActivity();
                        transaction = appCompatActivity.getSupportFragmentManager().beginTransaction();
                        transaction.add(OnBindView.this.getFragmentParentId(), OnBindView.this.fragment);
                        transaction.commit();
                        OnBindView.this.onFragmentBind(dialog, OnBindView.this.getCustomView(), OnBindView.this.fragment, appCompatActivity.getSupportFragmentManager());
                    }
                    if (OnBindView.this.supportFragment != null && OnBindView.this.getCustomView() instanceof FrameLayout && dialog.getOwnActivity() instanceof Activity) {
                        Activity activity = dialog.getOwnActivity();
                        transaction = activity.getFragmentManager().beginTransaction();
                        transaction.add(OnBindView.this.getFragmentParentId(), OnBindView.this.supportFragment);
                        transaction.commit();
                        OnBindView.this.onFragmentBind(dialog, OnBindView.this.getCustomView(), OnBindView.this.supportFragment, activity.getFragmentManager());
                    }
                }
            });
        }
    }

    private void callSetEvent(D dialog, View view) {
        if (dialog.hashCode() != this.dialogHash || view.hashCode() != this.parentViewHash) {
            this.dialogHash = dialog.hashCode();
            this.parentViewHash = view.hashCode();
            this.setEvent(dialog, this.getCustomView());
        }
    }

    private void waitBind(final ViewGroup parentView, final BaseDialog dialog) {
        this.waitBindRunnable = new Runnable(){

            @Override
            public void run() {
                if (OnBindView.this.getCustomView() == null) {
                    if (dialog == null) {
                        OnBindView.this.bindParent(parentView);
                    } else {
                        OnBindView.this.bindParent(parentView, dialog);
                    }
                }
            }
        };
    }
}

