/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.interfaces;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentManager;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.dialogs.WaitDialog;
import com.kongzue.dialogx.impl.ActivityLifecycleImpl;
import com.kongzue.dialogx.impl.DialogFragmentImpl;
import com.kongzue.dialogx.interfaces.BlurViewType;
import com.kongzue.dialogx.interfaces.DialogXStyle;
import com.kongzue.dialogx.interfaces.NoTouchInterface;
import com.kongzue.dialogx.util.ActivityRunnable;
import com.kongzue.dialogx.util.DialogListBuilder;
import com.kongzue.dialogx.util.DialogXFloatingWindowActivity;
import com.kongzue.dialogx.util.TextInfo;
import com.kongzue.dialogx.util.WindowUtil;
import com.kongzue.dialogx.util.views.DialogXBaseRelativeLayout;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class BaseDialog
implements LifecycleOwner {
    private static Thread uiThread;
    private static WeakReference<Activity> activityWeakReference;
    protected WeakReference<Activity> ownActivity;
    private WeakReference<FrameLayout> rootFrameLayout;
    private static List<BaseDialog> runningDialogList;
    private WeakReference<View> dialogView;
    protected WeakReference<DialogFragmentImpl> ownDialogFragmentImpl;
    protected DialogX.IMPL_MODE dialogImplMode = DialogX.implIMPLMode;
    protected WeakReference<DialogXFloatingWindowActivity> floatingWindowActivity;
    private WeakReference<DialogListBuilder> dialogListBuilder;
    protected LifecycleRegistry lifecycle = new LifecycleRegistry((LifecycleOwner)this);
    private static Map<String, ActivityRunnable> waitRunDialogX;
    protected boolean cancelable = true;
    protected boolean isShow;
    protected DialogXStyle style;
    protected DialogX.THEME theme;
    protected boolean autoShowInputKeyboard;
    protected Integer backgroundColor = null;
    protected long enterAnimDuration = -1L;
    protected long exitAnimDuration = -1L;
    protected int maxWidth;
    protected int maxHeight;
    protected int minWidth;
    protected int minHeight;
    protected int[] screenPaddings = new int[4];
    protected boolean dismissAnimFlag;
    protected boolean preShow;
    protected static WindowInsets windowInsets;
    static WeakReference<Handler> mMainHandler;

    public static void init(Context context) {
        if (context == null) {
            context = ActivityLifecycleImpl.getTopActivity();
        }
        if (context instanceof Activity) {
            BaseDialog.initActivityContext((Activity)context);
        }
        ActivityLifecycleImpl.init(context, new ActivityLifecycleImpl.onActivityResumeCallBack(){

            @Override
            public void getActivity(Activity activity) {
                BaseDialog.initActivityContext(activity);
            }
        });
    }

    private static void initActivityContext(Activity activity) {
        if (ActivityLifecycleImpl.isExemptActivities(activity)) {
            return;
        }
        try {
            uiThread = Looper.getMainLooper().getThread();
            activityWeakReference = new WeakReference<Activity>(activity);
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseDialog.error("DialogX.init: \u521d\u59cb\u5316\u5f02\u5e38\uff0c\u627e\u4e0d\u5230Activity\u7684\u6839\u5e03\u5c40");
        }
    }

    protected static void log(Object o) {
        if (DialogX.DEBUGMODE) {
            Log.i((String)">>>", (String)o.toString());
        }
    }

    protected static void error(Object o) {
        if (DialogX.DEBUGMODE) {
            Log.e((String)">>>", (String)o.toString());
        }
    }

    public static void onActivityResume(Activity activity) {
        if (runningDialogList != null) {
            CopyOnWriteArrayList<BaseDialog> copyOnWriteList = new CopyOnWriteArrayList<BaseDialog>(runningDialogList);
            for (int i = copyOnWriteList.size() - 1; i >= 0; --i) {
                View boxRoot;
                BaseDialog baseDialog = copyOnWriteList.get(i);
                if (baseDialog.getOwnActivity() != activity || !baseDialog.isShow || baseDialog.getDialogView() == null || !((boxRoot = baseDialog.getDialogView().findViewById(R.id.box_root)) instanceof DialogXBaseRelativeLayout) || !((DialogXBaseRelativeLayout)boxRoot).isBaseFocusable()) continue;
                ((DialogXBaseRelativeLayout)boxRoot).requestFocusOnResume();
                return;
            }
        }
    }

    private static void requestDialogFocus() {
        if (runningDialogList != null) {
            CopyOnWriteArrayList<BaseDialog> copyOnWriteList = new CopyOnWriteArrayList<BaseDialog>(runningDialogList);
            for (int i = copyOnWriteList.size() - 1; i >= 0; --i) {
                View boxRoot;
                BaseDialog baseDialog = copyOnWriteList.get(i);
                if (baseDialog.getOwnActivity() != BaseDialog.getTopActivity() || !baseDialog.isShow || baseDialog.getDialogView() == null || !((boxRoot = baseDialog.getDialogView().findViewById(R.id.box_root)) instanceof DialogXBaseRelativeLayout) || !((DialogXBaseRelativeLayout)boxRoot).isBaseFocusable()) continue;
                boxRoot.requestFocus();
                return;
            }
        }
    }

    public abstract void restartDialog();

    protected static void show(final View view) {
        if (view == null) {
            return;
        }
        final BaseDialog dialog = (BaseDialog)view.getTag();
        if (dialog != null) {
            if (dialog.isShow) {
                if (dialog.getDialogView() != null) {
                    dialog.getDialogView().setVisibility(0);
                    return;
                }
                BaseDialog.error(((BaseDialog)view.getTag()).dialogKey() + "\u5df2\u5904\u4e8e\u663e\u793a\u72b6\u6001\uff0c\u8bf7\u52ff\u91cd\u590d\u6267\u884c show() \u6307\u4ee4\u3002");
                return;
            }
            dialog.dialogView = new WeakReference<View>(view);
            BaseDialog.log(dialog.dialogKey() + ".show on " + dialog.getOwnActivity());
            BaseDialog.addDialogToRunningList(dialog);
            switch (dialog.dialogImplMode) {
                case WINDOW: {
                    WindowUtil.show(dialog.getOwnActivity(), view, !(dialog instanceof NoTouchInterface));
                    break;
                }
                case DIALOG_FRAGMENT: {
                    DialogFragmentImpl dialogFragment = new DialogFragmentImpl(dialog, view);
                    dialogFragment.show(BaseDialog.getSupportFragmentManager(dialog.getOwnActivity()), "DialogX");
                    dialog.ownDialogFragmentImpl = new WeakReference<DialogFragmentImpl>(dialogFragment);
                    break;
                }
                case FLOATING_ACTIVITY: {
                    if (waitRunDialogX == null) {
                        waitRunDialogX = new HashMap<String, ActivityRunnable>();
                    }
                    waitRunDialogX.put(dialog.dialogKey(), new ActivityRunnable(){

                        @Override
                        public void run(Activity activity) {
                            dialog.floatingWindowActivity = new WeakReference<DialogXFloatingWindowActivity>((DialogXFloatingWindowActivity)activity);
                            ((DialogXFloatingWindowActivity)((Object)dialog.floatingWindowActivity.get())).setFromActivity(dialog.getOwnActivity());
                            final FrameLayout activityRootView = BaseDialog.getDecorView(activity);
                            if (activityRootView == null) {
                                return;
                            }
                            BaseDialog.runOnMain(new Runnable(){

                                @Override
                                public void run() {
                                    if (view.getParent() == dialog.getRootFrameLayout()) {
                                        BaseDialog.error(((BaseDialog)view.getTag()).dialogKey() + "\u5df2\u5904\u4e8e\u663e\u793a\u72b6\u6001\uff0c\u8bf7\u52ff\u91cd\u590d\u6267\u884c show() \u6307\u4ee4\u3002");
                                        return;
                                    }
                                    if (view.getParent() != null) {
                                        ((ViewGroup)view.getParent()).removeView(view);
                                    }
                                    activityRootView.addView(view);
                                }
                            });
                        }
                    });
                    DialogXFloatingWindowActivity dialogXFloatingWindowActivity = DialogXFloatingWindowActivity.getDialogXFloatingWindowActivity();
                    if (dialogXFloatingWindowActivity != null && dialogXFloatingWindowActivity.isSameFrom(dialog.getOwnActivity().hashCode())) {
                        dialogXFloatingWindowActivity.showDialogX(dialog.dialogKey());
                        return;
                    }
                    Intent intent = new Intent(BaseDialog.getPrivateContext(), DialogXFloatingWindowActivity.class);
                    if (dialog.getOwnActivity() == null) {
                        intent.addFlags(0x10000000);
                    }
                    intent.putExtra("dialogXKey", dialog.dialogKey());
                    intent.putExtra("fromActivityUiStatus", dialog.getOwnActivity() == null ? 0 : (BaseDialog.getDecorView(dialog.getOwnActivity()) == null ? 0 : BaseDialog.getDecorView(dialog.getOwnActivity()).getSystemUiVisibility()));
                    intent.putExtra("from", BaseDialog.getPrivateContext().hashCode());
                    BaseDialog.getPrivateContext().startActivity(intent);
                    int version = Build.VERSION.SDK_INT;
                    if (version <= 5 || dialog.getOwnActivity() == null) break;
                    dialog.getOwnActivity().overridePendingTransition(0, 0);
                    break;
                }
                default: {
                    if (dialog.getRootFrameLayout() == null) {
                        return;
                    }
                    BaseDialog.runOnMain(new Runnable(){

                        @Override
                        public void run() {
                            if (view.getParent() == dialog.getRootFrameLayout()) {
                                BaseDialog.error(((BaseDialog)view.getTag()).dialogKey() + "\u5df2\u5904\u4e8e\u663e\u793a\u72b6\u6001\uff0c\u8bf7\u52ff\u91cd\u590d\u6267\u884c show() \u6307\u4ee4\u3002");
                                return;
                            }
                            if (view.getParent() != null) {
                                ((ViewGroup)view.getParent()).removeView(view);
                            }
                            dialog.getRootFrameLayout().addView(view);
                        }
                    });
                }
            }
        }
    }

    private static FragmentManager getSupportFragmentManager(Activity activity) {
        return activity instanceof AppCompatActivity ? ((AppCompatActivity)activity).getSupportFragmentManager() : null;
    }

    public static ActivityRunnable getActivityRunnable(String dialogXKey) {
        if (dialogXKey == null) {
            return null;
        }
        return waitRunDialogX.get(dialogXKey);
    }

    protected static void show(Activity activity, final View view) {
        BaseDialog baseDialog;
        if (activity == null || view == null) {
            return;
        }
        if (activityWeakReference == null || activityWeakReference.get() == null || ActivityLifecycleImpl.getApplicationContext() == null) {
            BaseDialog.init(activity.getApplicationContext());
        }
        if ((baseDialog = (BaseDialog)view.getTag()) != null) {
            baseDialog.setOwnActivity(activity);
            if (baseDialog.getDialogView() != null) {
                baseDialog.getDialogView().setVisibility(0);
            }
            if (baseDialog.isShow) {
                BaseDialog.error(((BaseDialog)view.getTag()).dialogKey() + "\u5df2\u5904\u4e8e\u663e\u793a\u72b6\u6001\uff0c\u8bf7\u52ff\u91cd\u590d\u6267\u884c show() \u6307\u4ee4\u3002");
                return;
            }
            if (activity.isDestroyed()) {
                BaseDialog.error(((BaseDialog)view.getTag()).dialogKey() + ".show ERROR: activity is Destroyed.");
                return;
            }
            baseDialog.dialogView = new WeakReference<View>(view);
            BaseDialog.log(baseDialog + ".show on " + activity);
            BaseDialog.addDialogToRunningList(baseDialog);
            switch (baseDialog.dialogImplMode) {
                case WINDOW: {
                    WindowUtil.show(activity, view, !(baseDialog instanceof NoTouchInterface));
                    break;
                }
                case DIALOG_FRAGMENT: {
                    DialogFragmentImpl dialogFragment = new DialogFragmentImpl(baseDialog, view);
                    dialogFragment.show(BaseDialog.getSupportFragmentManager(activity), "DialogX");
                    baseDialog.ownDialogFragmentImpl = new WeakReference<DialogFragmentImpl>(dialogFragment);
                    break;
                }
                case FLOATING_ACTIVITY: {
                    if (waitRunDialogX == null) {
                        waitRunDialogX = new HashMap<String, ActivityRunnable>();
                    }
                    waitRunDialogX.put(baseDialog.dialogKey(), new ActivityRunnable(){

                        @Override
                        public void run(Activity activity) {
                            baseDialog.floatingWindowActivity = new WeakReference<DialogXFloatingWindowActivity>((DialogXFloatingWindowActivity)activity);
                            ((DialogXFloatingWindowActivity)((Object)baseDialog.floatingWindowActivity.get())).setFromActivity(baseDialog.getOwnActivity());
                            final FrameLayout activityRootView = BaseDialog.getDecorView(activity);
                            if (activityRootView == null) {
                                return;
                            }
                            BaseDialog.runOnMain(new Runnable(){

                                @Override
                                public void run() {
                                    if (view.getParent() == baseDialog.getRootFrameLayout()) {
                                        BaseDialog.error(((BaseDialog)view.getTag()).dialogKey() + "\u5df2\u5904\u4e8e\u663e\u793a\u72b6\u6001\uff0c\u8bf7\u52ff\u91cd\u590d\u6267\u884c show() \u6307\u4ee4\u3002");
                                        return;
                                    }
                                    if (view.getParent() != null) {
                                        ((ViewGroup)view.getParent()).removeView(view);
                                    }
                                    activityRootView.addView(view);
                                }
                            });
                        }
                    });
                    DialogXFloatingWindowActivity dialogXFloatingWindowActivity = DialogXFloatingWindowActivity.getDialogXFloatingWindowActivity();
                    if (dialogXFloatingWindowActivity != null && dialogXFloatingWindowActivity.isSameFrom(activity.hashCode())) {
                        dialogXFloatingWindowActivity.showDialogX(baseDialog.dialogKey());
                        return;
                    }
                    Intent intent = new Intent((Context)activity, DialogXFloatingWindowActivity.class);
                    intent.putExtra("dialogXKey", baseDialog.dialogKey());
                    intent.putExtra("from", activity.hashCode());
                    intent.putExtra("fromActivityUiStatus", BaseDialog.getDecorView(activity) == null ? 0 : BaseDialog.getDecorView(activity).getSystemUiVisibility());
                    activity.startActivity(intent);
                    int version = Build.VERSION.SDK_INT;
                    if (version <= 5) break;
                    activity.overridePendingTransition(0, 0);
                    break;
                }
                default: {
                    final FrameLayout activityRootView = BaseDialog.getDecorView(activity);
                    if (activityRootView == null) {
                        return;
                    }
                    BaseDialog.runOnMain(new Runnable(){

                        @Override
                        public void run() {
                            if (view.getParent() == baseDialog.getRootFrameLayout()) {
                                BaseDialog.error(((BaseDialog)view.getTag()).dialogKey() + "\u5df2\u5904\u4e8e\u663e\u793a\u72b6\u6001\uff0c\u8bf7\u52ff\u91cd\u590d\u6267\u884c show() \u6307\u4ee4\u3002");
                                return;
                            }
                            if (view.getParent() != null) {
                                ((ViewGroup)view.getParent()).removeView(view);
                            }
                            activityRootView.addView(view);
                        }
                    });
                }
            }
        }
    }

    private void setOwnActivity(Activity activity) {
        this.ownActivity = new WeakReference<Activity>(activity);
    }

    protected static void dismiss(final View dialogView) {
        if (dialogView == null) {
            return;
        }
        final BaseDialog baseDialog = (BaseDialog)dialogView.getTag();
        BaseDialog.log(baseDialog.dialogKey() + ".dismiss");
        BaseDialog.removeDialogToRunningList(baseDialog);
        if (baseDialog.dialogView != null) {
            baseDialog.dialogView.clear();
        }
        switch (baseDialog.dialogImplMode) {
            case WINDOW: {
                WindowUtil.dismiss(dialogView);
                break;
            }
            case DIALOG_FRAGMENT: {
                if (baseDialog.ownDialogFragmentImpl == null || baseDialog.ownDialogFragmentImpl.get() == null) break;
                ((DialogFragmentImpl)((Object)baseDialog.ownDialogFragmentImpl.get())).dismiss();
                break;
            }
            case FLOATING_ACTIVITY: {
                if (baseDialog.floatingWindowActivity == null || baseDialog.floatingWindowActivity.get() == null) break;
                FrameLayout rootView = BaseDialog.getDecorView((Activity)baseDialog.floatingWindowActivity.get());
                if (rootView != null) {
                    rootView.removeView(dialogView);
                }
                ((DialogXFloatingWindowActivity)((Object)baseDialog.floatingWindowActivity.get())).finish(baseDialog.dialogKey());
                BaseDialog.requestDialogFocus();
                break;
            }
            default: {
                BaseDialog.runOnMain(new Runnable(){

                    @Override
                    public void run() {
                        if (dialogView.getParent() == null || !(dialogView.getParent() instanceof ViewGroup)) {
                            if (baseDialog.getRootFrameLayout() == null) {
                                return;
                            }
                            baseDialog.getRootFrameLayout().removeView(dialogView);
                        } else {
                            ((ViewGroup)dialogView.getParent()).removeView(dialogView);
                        }
                        BaseDialog.requestDialogFocus();
                    }
                }, true);
            }
        }
        if (baseDialog.getDialogListBuilder() != null && !baseDialog.getDialogListBuilder().isEmpty()) {
            baseDialog.getDialogListBuilder().showNext();
        }
    }

    private static void addDialogToRunningList(BaseDialog baseDialog) {
        if (runningDialogList == null) {
            runningDialogList = new CopyOnWriteArrayList<BaseDialog>();
        }
        runningDialogList.add(baseDialog);
    }

    private static void removeDialogToRunningList(BaseDialog baseDialog) {
        if (runningDialogList != null) {
            runningDialogList.remove(baseDialog);
        }
    }

    public static Activity getTopActivity() {
        if (activityWeakReference == null || activityWeakReference.get() == null) {
            BaseDialog.init(null);
            if (activityWeakReference == null || activityWeakReference.get() == null) {
                Activity topActivity = ActivityLifecycleImpl.getTopActivity();
                BaseDialog.init((Context)topActivity);
                return topActivity;
            }
            return (Activity)activityWeakReference.get();
        }
        return (Activity)activityWeakReference.get();
    }

    @Deprecated
    public static Context getContext() {
        return BaseDialog.getPrivateContext();
    }

    private static Context getPrivateContext() {
        Activity activity = BaseDialog.getTopActivity();
        if (activity == null) {
            Context applicationContext = BaseDialog.getApplicationContext();
            if (applicationContext == null) {
                BaseDialog.error("DialogX \u672a\u521d\u59cb\u5316(E2)\u3002\n\u8bf7\u68c0\u67e5\u662f\u5426\u5728\u542f\u52a8\u5bf9\u8bdd\u6846\u524d\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c\uff0c\u4f7f\u7528\u4ee5\u4e0b\u4ee3\u7801\u8fdb\u884c\u521d\u59cb\u5316\uff1a\nDialogX.init(context);\n\n\u53e6\u5916\u5efa\u8bae\u60a8\u524d\u5f80\u67e5\u770b DialogX \u7684\u6587\u6863\u8fdb\u884c\u4f7f\u7528\uff1ahttps://github.com/kongzue/DialogX");
                return null;
            }
            return applicationContext;
        }
        return activity;
    }

    public static Context getApplicationContext() {
        return ActivityLifecycleImpl.getApplicationContext();
    }

    public static void cleanContext() {
        if (activityWeakReference != null) {
            activityWeakReference.clear();
        }
        activityWeakReference = null;
        System.gc();
    }

    protected abstract void shutdown();

    public BaseDialog() {
        this.cancelable = DialogX.cancelable;
        this.style = DialogX.globalStyle;
        this.theme = DialogX.globalTheme;
        this.enterAnimDuration = DialogX.enterAnimDuration;
        this.exitAnimDuration = DialogX.exitAnimDuration;
        this.autoShowInputKeyboard = DialogX.autoShowInputKeyboard;
    }

    public abstract boolean isCancelable();

    public View createView(int layoutId) {
        if (this.getOwnActivity() == null) {
            BaseDialog.error("DialogX \u672a\u521d\u59cb\u5316(E3)\u3002\n\u8bf7\u68c0\u67e5\u662f\u5426\u5728\u542f\u52a8\u5bf9\u8bdd\u6846\u524d\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c\uff0c\u4f7f\u7528\u4ee5\u4e0b\u4ee3\u7801\u8fdb\u884c\u521d\u59cb\u5316\uff1a\nDialogX.init(context);\n\n\u53e6\u5916\u5efa\u8bae\u60a8\u524d\u5f80\u67e5\u770b DialogX \u7684\u6587\u6863\u8fdb\u884c\u4f7f\u7528\uff1ahttps://github.com/kongzue/DialogX");
            return null;
        }
        return LayoutInflater.from((Context)this.getOwnActivity()).inflate(layoutId, null);
    }

    public boolean isShow() {
        return this.isShow;
    }

    public DialogXStyle getStyle() {
        return this.style;
    }

    public DialogX.THEME getTheme() {
        return this.theme;
    }

    public static void useTextInfo(TextView textView, TextInfo textInfo) {
        if (textInfo == null) {
            return;
        }
        if (textView == null) {
            return;
        }
        if (textInfo.getFontSize() > 0) {
            textView.setTextSize(textInfo.getFontSizeComplexUnit(), (float)textInfo.getFontSize());
        }
        if (textInfo.getFontColor() != 1) {
            textView.setTextColor(textInfo.getFontColor());
        }
        if (textInfo.getGravity() != -1) {
            textView.setGravity(textInfo.getGravity());
        }
        if (textInfo.isShowEllipsis()) {
            textView.setEllipsize(TextUtils.TruncateAt.END);
        } else {
            textView.setEllipsize(null);
        }
        if (textInfo.getMaxLines() != -1) {
            textView.setMaxLines(textInfo.getMaxLines());
        } else {
            textView.setMaxLines(Integer.MAX_VALUE);
        }
        textView.getPaint().setFakeBoldText(textInfo.isBold());
    }

    protected void showText(TextView textView, CharSequence text) {
        if (textView == null) {
            return;
        }
        if (BaseDialog.isNull(text)) {
            textView.setVisibility(8);
            textView.setText((CharSequence)"");
        } else {
            textView.setVisibility(0);
            textView.setText(text);
        }
    }

    public static boolean isNull(String s) {
        return s == null || s.trim().isEmpty() || "null".equals(s) || "(null)".equals(s);
    }

    public static boolean isNull(CharSequence c) {
        String s = String.valueOf(c);
        return c == null || s.trim().isEmpty() || "null".equals(s) || "(null)".equals(s);
    }

    public Resources getResources() {
        if (this.getOwnActivity() != null) {
            return this.getOwnActivity().getResources();
        }
        if (BaseDialog.getApplicationContext() == null) {
            return Resources.getSystem();
        }
        return BaseDialog.getApplicationContext().getResources();
    }

    public int dip2px(float dpValue) {
        float scale = this.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public boolean isLightTheme() {
        if (this.theme == DialogX.THEME.AUTO) {
            if (BaseDialog.getApplicationContext() == null) {
                return this.theme == DialogX.THEME.LIGHT;
            }
            return (this.getResources().getConfiguration().uiMode & 0x30) == 16;
        }
        return this.theme == DialogX.THEME.LIGHT;
    }

    public FrameLayout getRootFrameLayout() {
        FrameLayout decorView;
        Activity activity = this.getOwnActivity();
        if (activity == null) {
            activity = BaseDialog.getTopActivity();
            if (activity == null) {
                BaseDialog.error("DialogX \u9519\u8bef\uff1a\u5728 getRootFrameLayout() \u65f6\u65e0\u6cd5\u83b7\u53d6\u7ed1\u5b9a\u7684 activity\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6b63\u786e\u521d\u59cb\u5316\uff1a\nDialogX.init(context);\n\n\u6216\u8005\u4f7f\u7528 .show(activity) \u542f\u52a8\u5bf9\u8bdd\u6846\n\u53e6\u5916\u5efa\u8bae\u60a8\u524d\u5f80\u67e5\u770b DialogX \u7684\u6587\u6863\u8fdb\u884c\u4f7f\u7528\uff1ahttps://github.com/kongzue/DialogX");
                return null;
            }
            this.setOwnActivity(activity);
        }
        if ((decorView = BaseDialog.getDecorView(activity)) == null) {
            BaseDialog.error("DialogX \u9519\u8bef\uff1a\u5728 getRootFrameLayout() \u65f6\u65e0\u6cd5\u83b7 activity(" + activity + ") \u7684 decorView\uff0c\u8bf7\u68c0\u67e5\u8be5 activity \u662f\u5426\u6b63\u5e38\u663e\u793a\u4e14\u53ef\u4ee5\u4f7f DialogX \u57fa\u4e8e\u5176\u663e\u793a\u3002\n\u82e5\u8be5 activity \u4e0d\u53ef\u7528\uff0c\u53ef\u901a\u8fc7\u4ee5\u4e0b\u4ee3\u7801\u914d\u7f6e\u8c41\u514d DialogX \u5bf9\u8bdd\u6846\u7ed1\u5b9a\u81f3\u8be5 activity\uff0c\u4f8b\u5982\uff1a\nDialogX.unsupportedActivitiesPackageNames = new String[]{\n        \"com.bytedance.sdk.openadsdk.stub.activity\",\n        \"com.mobile.auth.gatewayauth\",\n        \"com.google.android.gms.ads\"\n};\n\n\u53e6\u5916\u5efa\u8bae\u60a8\u524d\u5f80\u67e5\u770b DialogX \u7684\u6587\u6863\u8fdb\u884c\u4f7f\u7528\uff1ahttps://github.com/kongzue/DialogX");
            return null;
        }
        this.rootFrameLayout = new WeakReference<FrameLayout>(decorView);
        return (FrameLayout)this.rootFrameLayout.get();
    }

    public void tintColor(View view, int color2) {
        if (view == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            view.setBackgroundTintList(ColorStateList.valueOf((int)color2));
        }
    }

    protected void beforeShow() {
        View view;
        this.preShow = true;
        this.dismissAnimFlag = false;
        this.setOwnActivity(BaseDialog.getTopActivity());
        if (this.getOwnActivity() == null) {
            BaseDialog.init(null);
            if (this.getOwnActivity() == null) {
                BaseDialog.error("DialogX \u672a\u521d\u59cb\u5316(E5)\u3002\n\u8bf7\u68c0\u67e5\u662f\u5426\u5728\u542f\u52a8\u5bf9\u8bdd\u6846\u524d\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c\uff0c\u4f7f\u7528\u4ee5\u4e0b\u4ee3\u7801\u8fdb\u884c\u521d\u59cb\u5316\uff1a\nDialogX.init(context);\n\n\u53e6\u5916\u5efa\u8bae\u60a8\u524d\u5f80\u67e5\u770b DialogX \u7684\u6587\u6863\u8fdb\u884c\u4f7f\u7528\uff1ahttps://github.com/kongzue/DialogX");
                return;
            }
        }
        if (5 != 5) {
            BaseDialog.error("DialogX \u6240\u5f15\u7528\u7684 Style \u4e0d\u7b26\u5408\u5f53\u524d\u9002\u7528\u7248\u672c\uff1a5 \u5f15\u5165\u7684 Style(" + this.style.getClass().getSimpleName() + ") \u7248\u672c" + 5);
        }
        if (this.dialogImplMode != DialogX.IMPL_MODE.VIEW && this.getOwnActivity() instanceof LifecycleOwner) {
            Lifecycle lifecycle = ((LifecycleOwner)this.getOwnActivity()).getLifecycle();
            lifecycle.addObserver((LifecycleObserver)new LifecycleEventObserver(){

                public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
                    if (event == Lifecycle.Event.ON_DESTROY) {
                        BaseDialog.recycleDialog(BaseDialog.this.getOwnActivity());
                    }
                }
            });
        }
        if (!(this instanceof NoTouchInterface) && (view = this.getOwnActivity().getCurrentFocus()) != null) {
            InputMethodManager imm = (InputMethodManager)this.getOwnActivity().getSystemService("input_method");
            imm.hideSoftInputFromWindow(view.getWindowToken(), 2);
        }
    }

    protected String getString(int titleResId) {
        if (BaseDialog.getApplicationContext() == null) {
            BaseDialog.error("DialogX \u672a\u521d\u59cb\u5316(E6)\u3002\n\u8bf7\u68c0\u67e5\u662f\u5426\u5728\u542f\u52a8\u5bf9\u8bdd\u6846\u524d\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c\uff0c\u4f7f\u7528\u4ee5\u4e0b\u4ee3\u7801\u8fdb\u884c\u521d\u59cb\u5316\uff1a\nDialogX.init(context);\n\n\u53e6\u5916\u5efa\u8bae\u60a8\u524d\u5f80\u67e5\u770b DialogX \u7684\u6587\u6863\u8fdb\u884c\u4f7f\u7528\uff1ahttps://github.com/kongzue/DialogX");
            return null;
        }
        return this.getResources().getString(titleResId);
    }

    protected int getColor(int backgroundRes) {
        if (BaseDialog.getApplicationContext() == null) {
            BaseDialog.error("DialogX \u672a\u521d\u59cb\u5316(E7)\u3002\n\u8bf7\u68c0\u67e5\u662f\u5426\u5728\u542f\u52a8\u5bf9\u8bdd\u6846\u524d\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c\uff0c\u4f7f\u7528\u4ee5\u4e0b\u4ee3\u7801\u8fdb\u884c\u521d\u59cb\u5316\uff1a\nDialogX.init(context);\n\n\u53e6\u5916\u5efa\u8bae\u60a8\u524d\u5f80\u67e5\u770b DialogX \u7684\u6587\u6863\u8fdb\u884c\u4f7f\u7528\uff1ahttps://github.com/kongzue/DialogX");
            return -16777216;
        }
        return this.getResources().getColor(backgroundRes);
    }

    protected Integer getColorNullable(Integer res) {
        return res == null ? null : Integer.valueOf(this.getColor(res));
    }

    protected Integer getColorNullable(Integer res, Integer defaultResId) {
        return res == null ? this.getColor(defaultResId) : this.getColor(res);
    }

    public abstract String dialogKey();

    protected static void runOnMain(Runnable runnable) {
        if (!DialogX.autoRunOnUIThread || BaseDialog.getUiThread() != null && Thread.currentThread() == BaseDialog.getUiThread()) {
            runnable.run();
            return;
        }
        BaseDialog.runOnMain(runnable, true);
    }

    protected static Thread getUiThread() {
        if (uiThread == null) {
            uiThread = Looper.getMainLooper().getThread();
        }
        return uiThread;
    }

    protected static void runOnMain(Runnable runnable, boolean needWaitMainLooper) {
        BaseDialog.getMainHandler().post(runnable);
    }

    protected static void runOnMainDelay(Runnable runnable, long delay) {
        if (delay < 0L) {
            return;
        }
        if (!DialogX.autoRunOnUIThread) {
            runnable.run();
        }
        BaseDialog.getMainHandler().postDelayed(runnable, delay);
    }

    public View getDialogView() {
        if (this.dialogView == null) {
            return null;
        }
        return (View)this.dialogView.get();
    }

    public Activity getOwnActivity() {
        if (this.ownActivity == null || this.ownActivity.get() == null) {
            this.setOwnActivity(BaseDialog.getTopActivity());
        }
        return (Activity)this.ownActivity.get();
    }

    protected void cleanActivityContext() {
        if (this.ownActivity != null) {
            this.ownActivity.clear();
        }
        this.dialogView = null;
        this.ownActivity = null;
    }

    public static void cleanAll() {
        if (runningDialogList != null) {
            CopyOnWriteArrayList<BaseDialog> copyOnWriteList = new CopyOnWriteArrayList<BaseDialog>(runningDialogList);
            for (BaseDialog baseDialog : copyOnWriteList) {
                if (baseDialog.isShow()) {
                    baseDialog.shutdown();
                }
                baseDialog.cleanActivityContext();
                runningDialogList.remove(baseDialog);
            }
        }
    }

    public static void recycleDialog(Activity activity) {
        switch (DialogX.implIMPLMode) {
            case WINDOW: {
                if (runningDialogList == null) break;
                CopyOnWriteArrayList<BaseDialog> copyOnWriteList = new CopyOnWriteArrayList<BaseDialog>(runningDialogList);
                for (BaseDialog baseDialog : copyOnWriteList) {
                    if (baseDialog.getOwnActivity() != activity || baseDialog.dialogView == null) continue;
                    WindowUtil.dismiss((View)baseDialog.dialogView.get());
                    if (baseDialog instanceof WaitDialog) {
                        ((WaitDialog)baseDialog).cleanInstance();
                    }
                    runningDialogList.remove(baseDialog);
                }
                break;
            }
            case DIALOG_FRAGMENT: {
                if (runningDialogList == null) break;
                CopyOnWriteArrayList<BaseDialog> copyOnWriteList = new CopyOnWriteArrayList<BaseDialog>(runningDialogList);
                for (BaseDialog baseDialog : copyOnWriteList) {
                    if (baseDialog.getOwnActivity() != activity || baseDialog.ownDialogFragmentImpl == null || baseDialog.ownDialogFragmentImpl.get() == null) continue;
                    ((DialogFragmentImpl)((Object)baseDialog.ownDialogFragmentImpl.get())).dismiss();
                    if (baseDialog instanceof WaitDialog) {
                        ((WaitDialog)baseDialog).cleanInstance();
                    }
                    runningDialogList.remove(baseDialog);
                }
                break;
            }
            case FLOATING_ACTIVITY: {
                break;
            }
            default: {
                if (runningDialogList == null) break;
                CopyOnWriteArrayList<BaseDialog> copyOnWriteList = new CopyOnWriteArrayList<BaseDialog>(runningDialogList);
                for (BaseDialog baseDialog : copyOnWriteList) {
                    if (baseDialog.getOwnActivity() != activity) continue;
                    baseDialog.cleanActivityContext();
                    runningDialogList.remove(baseDialog);
                    if (!(baseDialog instanceof WaitDialog)) continue;
                    ((WaitDialog)baseDialog).cleanInstance();
                }
            }
        }
        if (activity == BaseDialog.getTopActivity()) {
            BaseDialog.cleanContext();
        }
    }

    public static List<BaseDialog> getRunningDialogList() {
        if (runningDialogList == null) {
            return new ArrayList<BaseDialog>();
        }
        return new CopyOnWriteArrayList<BaseDialog>(runningDialogList);
    }

    protected void imeShow(EditText editText, boolean show) {
        if (this.getOwnActivity() == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)this.getOwnActivity().getSystemService("input_method");
        if (show) {
            imm.showSoftInput((View)editText, 0);
        } else {
            imm.hideSoftInputFromWindow(editText.getWindowToken(), 0);
        }
    }

    public DialogX.IMPL_MODE getDialogImplMode() {
        return this.dialogImplMode;
    }

    public static WindowInsets publicWindowInsets() {
        return windowInsets;
    }

    protected void bindFloatingActivity(DialogXFloatingWindowActivity activity) {
        this.floatingWindowActivity = new WeakReference<DialogXFloatingWindowActivity>(activity);
    }

    private static Handler getMainHandler() {
        if (mMainHandler != null && mMainHandler.get() != null) {
            return (Handler)mMainHandler.get();
        }
        mMainHandler = new WeakReference<Handler>(new Handler(Looper.getMainLooper()));
        return (Handler)mMainHandler.get();
    }

    public DialogListBuilder getDialogListBuilder() {
        if (this.dialogListBuilder == null) {
            return null;
        }
        return (DialogListBuilder)this.dialogListBuilder.get();
    }

    public void setDialogListBuilder(DialogListBuilder dialogListBuilder) {
        this.dialogListBuilder = new WeakReference<DialogListBuilder>(dialogListBuilder);
    }

    public void cleanDialogList() {
        this.dialogListBuilder = null;
    }

    public boolean isPreShow() {
        return this.preShow;
    }

    public abstract <D extends BaseDialog> D show();

    protected void onDialogShow() {
    }

    protected void onDialogInit() {
    }

    protected void onDialogRefreshUI() {
    }

    @NonNull
    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    public int getMaxWidth() {
        if (this.maxWidth == 0) {
            return DialogX.dialogMaxWidth;
        }
        return this.maxWidth;
    }

    public int getMaxHeight() {
        if (this.maxHeight == 0) {
            return DialogX.dialogMaxHeight;
        }
        return this.maxHeight;
    }

    public int getMinWidth() {
        if (this.minWidth == 0) {
            return DialogX.dialogMinWidth;
        }
        return this.minWidth;
    }

    public int getMinHeight() {
        if (this.minHeight == 0) {
            return DialogX.dialogMinHeight;
        }
        return this.minHeight;
    }

    protected void setLifecycleState(Lifecycle.State s) {
        if (this.lifecycle == null || s == null) {
            return;
        }
        try {
            this.lifecycle.setCurrentState(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static FrameLayout getDecorView(Activity activity) {
        if (activity == null || activity.getWindow() == null || !(activity.getWindow().getDecorView() instanceof FrameLayout)) {
            return null;
        }
        return (FrameLayout)activity.getWindow().getDecorView();
    }

    protected List<View> findAllBlurView(View v) {
        ArrayList<View> result = new ArrayList<View>();
        if (v instanceof BlurViewType) {
            result.add(v);
        }
        if (v instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)v;
            for (int i = 0; i < group.getChildCount(); ++i) {
                List<View> child = this.findAllBlurView(group.getChildAt(i));
                if (child == null) continue;
                result.addAll(child);
            }
        }
        if (!result.isEmpty()) {
            return result;
        }
        return null;
    }

    protected Integer getIntStyleAttr(Integer styleValue) {
        return styleValue <= 0 ? null : styleValue;
    }

    protected Integer getIntStyleAttr(Integer styleValue, Integer defaultValue) {
        return styleValue <= 0 ? defaultValue : styleValue;
    }

    protected Float getFloatStyleAttr(Float styleValue) {
        return styleValue.floatValue() <= 0.0f ? null : styleValue;
    }

    protected Float getFloatStyleAttr(Float styleValue, Float defaultValue) {
        if (styleValue.floatValue() <= 0.0f) {
            BaseDialog.log("styleValue=" + styleValue + "<=0 ");
            BaseDialog.log("return defaultValue=" + defaultValue);
            return defaultValue;
        }
        BaseDialog.log("return styleValue=" + styleValue);
        return styleValue;
    }

    protected void setDialogView(View view) {
        this.dialogView = new WeakReference<View>(view);
    }

    public static enum BOOLEAN {
        TRUE,
        FALSE;

    }

    public static enum BUTTON_SELECT_RESULT {
        NONE,
        BUTTON_OK,
        BUTTON_CANCEL,
        BUTTON_OTHER;

    }
}

