/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.dialogs;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.ColorInt;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.dialogs.CustomDialog;
import com.kongzue.dialogx.interfaces.BaseDialog;
import com.kongzue.dialogx.interfaces.DialogLifecycleCallback;
import com.kongzue.dialogx.interfaces.DialogXAnimInterface;
import com.kongzue.dialogx.interfaces.DialogXStyle;
import com.kongzue.dialogx.interfaces.OnBackPressedListener;
import com.kongzue.dialogx.interfaces.OnBackgroundMaskClickListener;
import com.kongzue.dialogx.interfaces.OnBindView;
import com.kongzue.dialogx.interfaces.OnDialogButtonClickListener;
import java.util.Arrays;

public class GuideDialog
extends CustomDialog {
    protected STAGE_LIGHT_TYPE stageLightType = STAGE_LIGHT_TYPE.CIRCLE_OUTSIDE;
    protected Drawable tipImage;
    protected float stageLightFilletRadius;
    protected Integer maskColor = null;
    protected OnDialogButtonClickListener<GuideDialog> onStageLightPathClickListener;
    protected int[] baseViewLocationCoordinateCompensation = new int[4];
    View stageLightPathStub;
    int[] baseViewLocCache;
    Paint stageLightPaint;

    protected GuideDialog() {
        this.enterAnimResId = R.anim.anim_dialogx_alpha_enter;
        this.exitAnimResId = R.anim.anim_dialogx_default_exit;
        this.alignViewGravity = 81;
    }

    public static GuideDialog build() {
        return new GuideDialog();
    }

    public GuideDialog(View baseView, STAGE_LIGHT_TYPE stageLightType) {
        this();
        this.baseView(baseView);
        this.stageLightType = stageLightType;
    }

    public GuideDialog(View baseView, STAGE_LIGHT_TYPE stageLightType, OnBindView<CustomDialog> onBindView, int alignBaseViewGravity) {
        this();
        this.baseView(baseView);
        this.stageLightType = stageLightType;
        this.onBindView = onBindView;
        this.alignViewGravity = alignBaseViewGravity;
    }

    public GuideDialog(View baseView, STAGE_LIGHT_TYPE stageLightType, int tipImageResId, int alignBaseViewGravity) {
        this();
        this.baseView(baseView);
        this.tipImage = this.getResources().getDrawable(tipImageResId);
        this.stageLightType = stageLightType;
        this.alignViewGravity = alignBaseViewGravity;
    }

    public GuideDialog(View baseView, STAGE_LIGHT_TYPE stageLightType, Bitmap tipImage, int alignBaseViewGravity) {
        this();
        this.baseView(baseView);
        this.tipImage = new BitmapDrawable(this.getResources(), tipImage);
        this.stageLightType = stageLightType;
        this.alignViewGravity = alignBaseViewGravity;
    }

    public GuideDialog(View baseView, STAGE_LIGHT_TYPE stageLightType, Drawable tipImage, int alignBaseViewGravity) {
        this();
        this.baseView(baseView);
        this.tipImage = tipImage;
        this.stageLightType = stageLightType;
        this.alignViewGravity = alignBaseViewGravity;
    }

    public GuideDialog(int tipImageResId) {
        this();
        this.tipImage = this.getResources().getDrawable(tipImageResId);
    }

    public GuideDialog(Bitmap tipImage) {
        this();
        this.tipImage = new BitmapDrawable(this.getResources(), tipImage);
    }

    public GuideDialog(Drawable tipImage) {
        this();
        this.tipImage = tipImage;
    }

    public GuideDialog(int tipImageResId, CustomDialog.ALIGN align) {
        this();
        this.tipImage = this.getResources().getDrawable(tipImageResId);
        this.align = align;
    }

    public GuideDialog(Bitmap tipImage, CustomDialog.ALIGN align) {
        this();
        this.tipImage = new BitmapDrawable(this.getResources(), tipImage);
        this.align = align;
    }

    public GuideDialog(Drawable tipImage, CustomDialog.ALIGN align) {
        this();
        this.tipImage = tipImage;
        this.align = align;
    }

    public GuideDialog(OnBindView<CustomDialog> onBindView) {
        this();
        this.onBindView = onBindView;
    }

    public GuideDialog(OnBindView<CustomDialog> onBindView, CustomDialog.ALIGN align) {
        this();
        this.onBindView = onBindView;
        this.align = align;
    }

    public GuideDialog(View baseView, int tipImageResId) {
        this();
        this.baseView(baseView);
        this.tipImage = this.getResources().getDrawable(tipImageResId);
    }

    public GuideDialog(View baseView, Bitmap tipImage) {
        this();
        this.baseView(baseView);
        this.tipImage = new BitmapDrawable(this.getResources(), tipImage);
    }

    public GuideDialog(View baseView, Drawable tipImage) {
        this();
        this.baseView(baseView);
        this.tipImage = tipImage;
    }

    public GuideDialog(View baseView, STAGE_LIGHT_TYPE stageLightType, int tipImageResId) {
        this();
        this.baseView(baseView);
        this.stageLightType = stageLightType;
        this.tipImage = this.getResources().getDrawable(tipImageResId);
    }

    public GuideDialog(View baseView, STAGE_LIGHT_TYPE stageLightType, Bitmap tipImage) {
        this();
        this.baseView(baseView);
        this.stageLightType = stageLightType;
        this.tipImage = new BitmapDrawable(this.getResources(), tipImage);
    }

    public GuideDialog(View baseView, STAGE_LIGHT_TYPE stageLightType, Drawable tipImage) {
        this();
        this.baseView(baseView);
        this.stageLightType = stageLightType;
        this.tipImage = tipImage;
    }

    public GuideDialog(View baseView, int tipImageResId, int alignBaseViewGravity) {
        this();
        this.baseView(baseView);
        this.alignViewGravity = alignBaseViewGravity;
        this.tipImage = this.getResources().getDrawable(tipImageResId);
    }

    public GuideDialog(View baseView, Bitmap tipImage, int alignBaseViewGravity) {
        this();
        this.baseView(baseView);
        this.alignViewGravity = alignBaseViewGravity;
        this.tipImage = new BitmapDrawable(this.getResources(), tipImage);
    }

    public GuideDialog(View baseView, Drawable tipImage, int alignBaseViewGravity) {
        this();
        this.baseView(baseView);
        this.alignViewGravity = alignBaseViewGravity;
        this.tipImage = tipImage;
    }

    public static GuideDialog show(OnBindView<CustomDialog> onBindView) {
        GuideDialog guideDialog = new GuideDialog(onBindView);
        guideDialog.show();
        return guideDialog;
    }

    public static GuideDialog show(OnBindView<CustomDialog> onBindView, CustomDialog.ALIGN align) {
        GuideDialog guideDialog = new GuideDialog(onBindView);
        guideDialog.align = align;
        guideDialog.show();
        return guideDialog;
    }

    public static GuideDialog show(int tipImageResId) {
        return new GuideDialog(tipImageResId).show();
    }

    public static GuideDialog show(Bitmap tipImage) {
        return new GuideDialog(tipImage).show();
    }

    public static GuideDialog show(Drawable tipImage) {
        return new GuideDialog(tipImage).show();
    }

    public static GuideDialog show(int tipImageResId, CustomDialog.ALIGN align) {
        GuideDialog guideDialog = new GuideDialog(tipImageResId, align);
        guideDialog.align = align;
        return guideDialog.show();
    }

    public static GuideDialog show(Bitmap tipImage, CustomDialog.ALIGN align) {
        GuideDialog guideDialog = new GuideDialog(tipImage, align);
        guideDialog.align = align;
        return guideDialog.show();
    }

    public static GuideDialog show(Drawable tipImage, CustomDialog.ALIGN align) {
        return new GuideDialog(tipImage, align).show();
    }

    public static GuideDialog show(View baseView, STAGE_LIGHT_TYPE stageLightType) {
        return new GuideDialog(baseView, stageLightType).show();
    }

    public static GuideDialog show(View baseView, STAGE_LIGHT_TYPE stageLightType, OnBindView<CustomDialog> onBindView, int alignBaseViewGravity) {
        return new GuideDialog(baseView, stageLightType, onBindView, alignBaseViewGravity).show();
    }

    public static GuideDialog show(View baseView, STAGE_LIGHT_TYPE stageLightType, int tipImageResId, int alignBaseViewGravity) {
        return new GuideDialog(baseView, stageLightType, tipImageResId, alignBaseViewGravity).show();
    }

    public static GuideDialog show(View baseView, STAGE_LIGHT_TYPE stageLightType, Bitmap tipImage, int alignBaseViewGravity) {
        return new GuideDialog(baseView, stageLightType, tipImage, alignBaseViewGravity).show();
    }

    public static GuideDialog show(View baseView, STAGE_LIGHT_TYPE stageLightType, Drawable tipImage, int alignBaseViewGravity) {
        return new GuideDialog(baseView, stageLightType, tipImage, alignBaseViewGravity).show();
    }

    public static GuideDialog show(View baseView, int tipImageResId) {
        return new GuideDialog(baseView, tipImageResId).show();
    }

    public static GuideDialog show(View baseView, Bitmap tipImage) {
        return new GuideDialog(baseView, tipImage).show();
    }

    public static GuideDialog show(View baseView, Drawable tipImage) {
        return new GuideDialog(baseView, tipImage).show();
    }

    public static GuideDialog show(View baseView, STAGE_LIGHT_TYPE stageLightType, int tipImageResId) {
        return new GuideDialog(baseView, stageLightType, tipImageResId).show();
    }

    public static GuideDialog show(View baseView, STAGE_LIGHT_TYPE stageLightType, Bitmap tipImage) {
        return new GuideDialog(baseView, stageLightType, tipImage).show();
    }

    public static GuideDialog show(View baseView, STAGE_LIGHT_TYPE stageLightType, Drawable tipImage) {
        return new GuideDialog(baseView, stageLightType, tipImage).show();
    }

    public static GuideDialog show(View baseView, int tipImageResId, int alignBaseViewGravity) {
        return new GuideDialog(baseView, tipImageResId, alignBaseViewGravity).show();
    }

    public static GuideDialog show(View baseView, Bitmap tipImage, int alignBaseViewGravity) {
        return new GuideDialog(baseView, tipImage, alignBaseViewGravity).show();
    }

    public static GuideDialog show(View baseView, Drawable tipImage, int alignBaseViewGravity) {
        return new GuideDialog(baseView, tipImage, alignBaseViewGravity).show();
    }

    @Override
    public GuideDialog show() {
        super.show();
        return this;
    }

    @Override
    public GuideDialog show(Activity activity) {
        super.show(activity);
        return this;
    }

    @Override
    public String dialogKey() {
        return this.getClass().getSimpleName() + "(" + Integer.toHexString(this.hashCode()) + ")";
    }

    @Override
    public GuideDialog setDialogLifecycleCallback(DialogLifecycleCallback<CustomDialog> dialogLifecycleCallback) {
        this.dialogLifecycleCallback = dialogLifecycleCallback;
        if (this.isShow) {
            dialogLifecycleCallback.onShow(this.me);
        }
        return this;
    }

    @Override
    public GuideDialog setOnBackPressedListener(OnBackPressedListener<CustomDialog> onBackPressedListener) {
        this.onBackPressedListener = onBackPressedListener;
        this.refreshUI();
        return this;
    }

    @Override
    public GuideDialog setStyle(DialogXStyle style2) {
        this.style = style2;
        return this;
    }

    @Override
    public GuideDialog setTheme(DialogX.THEME theme) {
        this.theme = theme;
        return this;
    }

    @Override
    public GuideDialog setCancelable(boolean cancelable) {
        this.privateCancelable = cancelable ? BaseDialog.BOOLEAN.TRUE : BaseDialog.BOOLEAN.FALSE;
        this.refreshUI();
        return this;
    }

    @Override
    public CustomDialog.DialogImpl getDialogImpl() {
        return this.dialogImpl;
    }

    @Override
    public GuideDialog setCustomView(OnBindView<CustomDialog> onBindView) {
        this.onBindView = onBindView;
        this.refreshUI();
        return this;
    }

    @Override
    public GuideDialog removeCustomView() {
        this.onBindView.clean();
        this.refreshUI();
        return this;
    }

    @Override
    public GuideDialog setEnterAnimResId(int enterAnimResId) {
        this.enterAnimResId = enterAnimResId;
        return this;
    }

    @Override
    public GuideDialog setExitAnimResId(int exitAnimResId) {
        this.exitAnimResId = exitAnimResId;
        return this;
    }

    @Override
    public GuideDialog setAnimResId(int enterAnimResId, int exitAnimResId) {
        this.enterAnimResId = enterAnimResId;
        this.exitAnimResId = exitAnimResId;
        return this;
    }

    @Override
    public GuideDialog setAlign(CustomDialog.ALIGN align) {
        this.align = align;
        return this;
    }

    @Override
    public GuideDialog setAutoUnsafePlacePadding(boolean autoUnsafePlacePadding) {
        this.autoUnsafePlacePadding = autoUnsafePlacePadding;
        this.refreshUI();
        return this;
    }

    @Override
    public GuideDialog setFullScreen(boolean fullscreen) {
        this.autoUnsafePlacePadding = !this.autoUnsafePlacePadding;
        this.refreshUI();
        return this;
    }

    @Override
    public GuideDialog setMaskColor(@ColorInt int maskColor) {
        this.maskColor = maskColor;
        this.refreshUI();
        return this;
    }

    @Override
    public GuideDialog setEnterAnimDuration(long enterAnimDuration) {
        this.enterAnimDuration = enterAnimDuration;
        return this;
    }

    @Override
    public GuideDialog setExitAnimDuration(long exitAnimDuration) {
        this.exitAnimDuration = exitAnimDuration;
        return this;
    }

    @Override
    public GuideDialog setDialogImplMode(DialogX.IMPL_MODE dialogImplMode) {
        this.dialogImplMode = dialogImplMode;
        return this;
    }

    @Override
    public GuideDialog setBkgInterceptTouch(boolean bkgInterceptTouch) {
        this.bkgInterceptTouch = bkgInterceptTouch;
        return this;
    }

    @Override
    public GuideDialog setAlignBaseViewGravity(View baseView, int alignGravity) {
        this.baseView(baseView);
        this.alignViewGravity = alignGravity;
        this.baseViewLoc = new int[4];
        baseView.getLocationInWindow(this.baseViewLoc);
        this.setFullScreen(true);
        return this;
    }

    public GuideDialog setAlignBaseViewGravity(View baseView) {
        this.baseView(baseView);
        this.baseViewLoc = new int[4];
        baseView.getLocationInWindow(this.baseViewLoc);
        this.setFullScreen(true);
        return this;
    }

    @Override
    public GuideDialog setAlignBaseViewGravity(int alignGravity) {
        this.alignViewGravity = alignGravity;
        if (this.baseView() != null) {
            this.baseViewLoc = new int[4];
            this.baseView().getLocationInWindow(this.baseViewLoc);
        }
        this.setFullScreen(true);
        return this;
    }

    @Override
    public GuideDialog setAlignBaseViewGravity(View baseView, int alignGravity, int marginLeft, int marginTop, int marginRight, int marginBottom) {
        this.marginRelativeBaseView = new int[]{marginLeft, marginTop, marginRight, marginBottom};
        return this.setAlignBaseViewGravity(baseView, alignGravity);
    }

    @Override
    public GuideDialog setBaseViewMargin(int[] marginRelativeBaseView) {
        this.marginRelativeBaseView = marginRelativeBaseView;
        return this;
    }

    @Override
    public GuideDialog setBaseViewMargin(int marginLeft, int marginTop, int marginRight, int marginBottom) {
        this.marginRelativeBaseView = new int[]{marginLeft, marginTop, marginRight, marginBottom};
        return this;
    }

    @Override
    public GuideDialog setBaseViewMarginLeft(int marginLeft) {
        this.marginRelativeBaseView[0] = marginLeft;
        return this;
    }

    @Override
    public GuideDialog setBaseViewMarginTop(int marginTop) {
        this.marginRelativeBaseView[1] = marginTop;
        return this;
    }

    @Override
    public GuideDialog setBaseViewMarginRight(int marginRight) {
        this.marginRelativeBaseView[2] = marginRight;
        return this;
    }

    @Override
    public GuideDialog setBaseViewMarginBottom(int marginBottom) {
        this.marginRelativeBaseView[3] = marginBottom;
        return this;
    }

    @Override
    public GuideDialog setWidth(int width) {
        this.width = width;
        this.refreshUI();
        return this;
    }

    @Override
    public GuideDialog setHeight(int height) {
        this.height = height;
        this.refreshUI();
        return this;
    }

    @Override
    public GuideDialog setOnBackgroundMaskClickListener(OnBackgroundMaskClickListener<CustomDialog> onBackgroundMaskClickListener) {
        this.onBackgroundMaskClickListener = onBackgroundMaskClickListener;
        return this;
    }

    @Override
    protected void onDialogShow() {
        super.onDialogShow();
        if (this.baseView() == null) {
            super.setMaskColor(this.maskColor == null ? this.getColor(R.color.black50) : this.maskColor.intValue());
        }
    }

    @Override
    protected void onDialogRefreshUI() {
        super.onDialogRefreshUI();
        if (this.onBindView == null && this.tipImage != null) {
            this.getDialogImpl().boxCustom.setFocusable(false);
            this.getDialogImpl().boxCustom.setFocusableInTouchMode(false);
            this.getDialogImpl().boxCustom.setOnClickListener(null);
            this.getDialogImpl().boxCustom.setClickable(false);
            ImageView imageView = new ImageView((Context)this.getOwnActivity());
            imageView.setImageDrawable(this.tipImage);
            imageView.setAdjustViewBounds(true);
            imageView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
            this.onBindView = new OnBindView<CustomDialog>((View)imageView){

                @Override
                public void onBind(CustomDialog dialog, View v) {
                }
            };
            this.onBindView.bindParent((ViewGroup)this.getDialogImpl().boxCustom, this.me);
        }
        if (this.getOnStageLightPathClickListener() != null && this.baseView() != null) {
            this.stageLightPathStub = new View((Context)this.getOwnActivity());
            this.stageLightPathStub.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (!GuideDialog.this.getOnStageLightPathClickListener().onClick(GuideDialog.this, v)) {
                        GuideDialog.this.dismiss();
                    }
                }
            });
            this.getDialogImpl().boxRoot.addView(this.stageLightPathStub);
        } else if (this.stageLightPathStub != null && this.stageLightPathStub.getParent() instanceof ViewGroup) {
            ((ViewGroup)this.stageLightPathStub.getParent()).removeView(this.stageLightPathStub);
        }
    }

    @Override
    protected void onGetBaseViewLoc(int[] baseViewLoc) {
        if (Arrays.equals(baseViewLoc, this.baseViewLocCache)) {
            return;
        }
        if (this.getDialogImpl() == null) {
            return;
        }
        Bitmap bkg = Bitmap.createBitmap((int)this.getDialogImpl().boxRoot.getWidth(), (int)this.getDialogImpl().boxRoot.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bkg);
        int x = baseViewLoc[0] + this.baseViewLocationCoordinateCompensation[0];
        int y = baseViewLoc[1] + this.baseViewLocationCoordinateCompensation[1];
        int w = baseViewLoc[2] + this.baseViewLocationCoordinateCompensation[2];
        int h = baseViewLoc[3] + this.baseViewLocationCoordinateCompensation[3];
        int hW = w / 2;
        int hH = h / 2;
        if (this.stageLightPathStub != null && (this.stageLightPathStub.getX() != (float)x || this.stageLightPathStub.getY() != (float)y)) {
            RelativeLayout.LayoutParams rLp = (RelativeLayout.LayoutParams)this.stageLightPathStub.getLayoutParams();
            if (rLp == null) {
                rLp = new RelativeLayout.LayoutParams(w, h);
            } else {
                rLp.width = w;
                rLp.height = h;
            }
            this.stageLightPathStub.setLayoutParams((ViewGroup.LayoutParams)rLp);
            this.stageLightPathStub.setX((float)x);
            this.stageLightPathStub.setY((float)y);
        }
        switch (this.stageLightType) {
            case CIRCLE_OUTSIDE: {
                int r = (int)Math.sqrt(hW * hW + hH * hH);
                canvas.drawCircle((float)(x + hW), (float)(y + hH), (float)r, this.getStageLightPaint());
                break;
            }
            case CIRCLE_INSIDE: {
                int r = Math.min(w, h) / 2;
                canvas.drawCircle((float)(x + hW), (float)(y + hH), (float)r, this.getStageLightPaint());
                break;
            }
            case RECTANGLE: {
                canvas.drawRoundRect(new RectF((float)x, (float)y, (float)(x + w), (float)(y + h)), this.stageLightFilletRadius, this.stageLightFilletRadius, this.getStageLightPaint());
                break;
            }
            case SQUARE_INSIDE: {
                int r = Math.min(w, h);
                canvas.drawRoundRect(new RectF((float)(x + hW - r / 2), (float)(y + hH - r / 2), (float)(x + hW - r / 2 + r), (float)(y + hH - r / 2 + r)), this.stageLightFilletRadius, this.stageLightFilletRadius, this.getStageLightPaint());
                break;
            }
            case SQUARE_OUTSIDE: {
                int r = Math.max(w, h);
                canvas.drawRoundRect(new RectF((float)(x + hW - r / 2), (float)(y + hH - r / 2), (float)(x + hW - r / 2 + r), (float)(y + hH - r / 2 + r)), this.stageLightFilletRadius, this.stageLightFilletRadius, this.getStageLightPaint());
            }
        }
        this.stageLightPaint.setXfermode(null);
        canvas.drawColor(this.maskColor == null ? this.getColor(R.color.black50) : this.maskColor.intValue(), PorterDuff.Mode.SRC_OUT);
        BitmapDrawable bkgDrawable = new BitmapDrawable(this.getResources(), bkg);
        this.getDialogImpl().boxRoot.setBackground((Drawable)bkgDrawable);
        this.baseViewLocCache = Arrays.copyOf(baseViewLoc, 4);
    }

    private Paint getStageLightPaint() {
        if (this.stageLightPaint == null) {
            this.stageLightPaint = new Paint();
            this.stageLightPaint.setColor(-65536);
            this.stageLightPaint.setStyle(Paint.Style.FILL);
            this.stageLightPaint.setAntiAlias(true);
        }
        return this.stageLightPaint;
    }

    public STAGE_LIGHT_TYPE getStageLightType() {
        return this.stageLightType;
    }

    public GuideDialog setStageLightType(STAGE_LIGHT_TYPE stageLightType) {
        this.stageLightType = stageLightType;
        this.refreshUI();
        return this;
    }

    public Drawable getTipImage() {
        return this.tipImage;
    }

    public GuideDialog setTipImage(int tipImageResId) {
        this.tipImage = this.getResources().getDrawable(tipImageResId);
        this.refreshUI();
        return this;
    }

    public GuideDialog setTipImage(Bitmap tipImage) {
        this.tipImage = new BitmapDrawable(this.getResources(), tipImage);
        this.refreshUI();
        return this;
    }

    public GuideDialog setTipImage(Drawable tipImage) {
        this.tipImage = tipImage;
        this.refreshUI();
        return this;
    }

    public float getStageLightFilletRadius() {
        return this.stageLightFilletRadius;
    }

    public GuideDialog setStageLightFilletRadius(float stageLightFilletRadius) {
        this.stageLightFilletRadius = stageLightFilletRadius;
        this.refreshUI();
        return this;
    }

    public OnDialogButtonClickListener<GuideDialog> getOnStageLightPathClickListener() {
        return this.onStageLightPathClickListener;
    }

    public GuideDialog setOnStageLightPathClickListener(OnDialogButtonClickListener<GuideDialog> onStageLightPathClickListener) {
        this.onStageLightPathClickListener = onStageLightPathClickListener;
        this.refreshUI();
        return this;
    }

    @Override
    public DialogXAnimInterface<CustomDialog> getDialogXAnimImpl() {
        return this.dialogXAnimImpl;
    }

    @Override
    public GuideDialog setDialogXAnimImpl(DialogXAnimInterface<CustomDialog> dialogXAnimImpl) {
        this.dialogXAnimImpl = dialogXAnimImpl;
        return this;
    }

    @Override
    public GuideDialog setRootPadding(int padding) {
        this.screenPaddings = new int[]{padding, padding, padding, padding};
        this.refreshUI();
        return this;
    }

    @Override
    public GuideDialog setRootPadding(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        this.screenPaddings = new int[]{paddingLeft, paddingTop, paddingRight, paddingBottom};
        this.refreshUI();
        return this;
    }

    public int[] getBaseViewLocationCoordinateCompensation() {
        return this.baseViewLocationCoordinateCompensation;
    }

    public GuideDialog setBaseViewLocationCoordinateCompensation(int[] baseViewLocationCoordinateCompensation) {
        this.baseViewLocationCoordinateCompensation = baseViewLocationCoordinateCompensation;
        return this;
    }

    public GuideDialog setBaseViewLocationCoordinateCompensation(int px) {
        this.baseViewLocationCoordinateCompensation = new int[]{px, px, px, px};
        this.refreshUI();
        return this;
    }

    public GuideDialog setBaseViewLocationCoordinateCompensation(int pxX, int pxY, int pxR, int pxB) {
        this.baseViewLocationCoordinateCompensation = new int[]{pxX, pxY, pxR, pxB};
        this.refreshUI();
        return this;
    }

    public GuideDialog setBaseViewLocationCoordinateCompensationLeft(int pxX) {
        this.baseViewLocationCoordinateCompensation[0] = pxX;
        this.refreshUI();
        return this;
    }

    public GuideDialog setBaseViewLocationCoordinateCompensationTop(int pxY) {
        this.baseViewLocationCoordinateCompensation[1] = pxY;
        this.refreshUI();
        return this;
    }

    public GuideDialog setBaseViewLocationCoordinateCompensationRight(int pxR) {
        this.baseViewLocationCoordinateCompensation[2] = pxR;
        this.refreshUI();
        return this;
    }

    public GuideDialog setBaseViewLocationCoordinateCompensationBottom(int pxB) {
        this.baseViewLocationCoordinateCompensation[3] = pxB;
        this.refreshUI();
        return this;
    }

    public int getBaseViewLocationCoordinateCompensationLeft() {
        return this.baseViewLocationCoordinateCompensation[0];
    }

    public int getBaseViewLocationCoordinateCompensationTop() {
        return this.baseViewLocationCoordinateCompensation[1];
    }

    public int getBaseViewLocationCoordinateCompensationRight() {
        return this.baseViewLocationCoordinateCompensation[2];
    }

    public int getBaseViewLocationCoordinateCompensationBottom() {
        return this.baseViewLocationCoordinateCompensation[3];
    }

    public static enum STAGE_LIGHT_TYPE {
        RECTANGLE,
        SQUARE_OUTSIDE,
        SQUARE_INSIDE,
        CIRCLE_OUTSIDE,
        CIRCLE_INSIDE;

    }
}

