/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import java.io.IOException;
import kong.unirest.GenericType;
import kong.unirest.ObjectMapper;
import kong.unirest.UnirestException;

public class JacksonObjectMapper
implements ObjectMapper {
    private final com.fasterxml.jackson.databind.ObjectMapper om;

    public JacksonObjectMapper() {
        this(new com.fasterxml.jackson.databind.ObjectMapper());
        this.om.configure(JsonGenerator.Feature.IGNORE_UNKNOWN, true);
        this.om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public JacksonObjectMapper(com.fasterxml.jackson.databind.ObjectMapper om) {
        this.om = om;
    }

    public <T> T readValue(String value, Class<T> valueType) {
        try {
            return (T)this.om.readValue(value, valueType);
        }
        catch (IOException e) {
            throw new UnirestException((Exception)e);
        }
    }

    public <T> T readValue(String value, GenericType<T> genericType) {
        try {
            return (T)this.om.readValue(value, this.om.constructType(genericType.getType()));
        }
        catch (IOException e) {
            throw new UnirestException((Exception)e);
        }
    }

    public String writeValue(Object value) {
        try {
            return this.om.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new UnirestException((Exception)((Object)e));
        }
    }
}

