/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core;

import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import kong.unirest.core.SocketSet;
import kong.unirest.core.UnirestAssertion;

public class MockWebSocket
implements WebSocket {
    private SocketSet remoteSocketSet;

    private CompletableFuture<WebSocket> sendToOtherSide(BiConsumer<WebSocket, WebSocket.Listener> consumer) {
        if (this.remoteSocketSet == null) {
            throw new UnirestAssertion("Socket is not initialized. Make sure to call init(SocketSet) with the remote set.", new Object[0]);
        }
        consumer.accept((WebSocket)this.remoteSocketSet.getSocket(), (WebSocket.Listener)this.remoteSocketSet.getListener());
        return CompletableFuture.completedFuture(this);
    }

    @Override
    public CompletableFuture<WebSocket> sendText(CharSequence data, boolean last) {
        return this.sendToOtherSide((s, l) -> l.onText((WebSocket)s, data, last));
    }

    @Override
    public CompletableFuture<WebSocket> sendBinary(ByteBuffer data, boolean last) {
        return this.sendToOtherSide((s, l) -> l.onBinary((WebSocket)s, data, last));
    }

    @Override
    public CompletableFuture<WebSocket> sendPing(ByteBuffer message) {
        return this.sendToOtherSide((s, l) -> l.onPing((WebSocket)s, message));
    }

    @Override
    public CompletableFuture<WebSocket> sendPong(ByteBuffer message) {
        return this.sendToOtherSide((s, l) -> l.onPong((WebSocket)s, message));
    }

    @Override
    public CompletableFuture<WebSocket> sendClose(int statusCode, String reason) {
        return this.sendToOtherSide((s, l) -> l.onClose((WebSocket)s, statusCode, reason));
    }

    @Override
    public void request(long n) {
    }

    @Override
    public String getSubprotocol() {
        return null;
    }

    @Override
    public boolean isOutputClosed() {
        return false;
    }

    @Override
    public boolean isInputClosed() {
        return false;
    }

    @Override
    public void abort() {
    }

    public void init(SocketSet otherSide) {
        this.remoteSocketSet = otherSide;
        otherSide.open();
    }
}

