/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core;

import java.util.function.Function;
import java.util.function.Supplier;
import kong.unirest.core.BaseRequest;
import kong.unirest.core.Config;
import kong.unirest.core.Expectation;
import kong.unirest.core.ExpectedResponse;
import kong.unirest.core.Headers;
import kong.unirest.core.HttpRequest;
import kong.unirest.core.MockRawResponse;
import kong.unirest.core.MockResponse;
import kong.unirest.core.ObjectMapper;
import kong.unirest.core.RawResponse;
import kong.unirest.core.ResponseBuilder;
import kong.unirest.core.Times;
import kong.unirest.core.UnirestAssertion;
import kong.unirest.core.Util;
import kong.unirest.core.json.JSONElement;

class ExpectedResponseRecord
implements ExpectedResponse,
ResponseBuilder {
    private Expectation expectation;
    private Function<ObjectMapper, String> response = o -> null;
    private Headers responseHeaders = new Headers();
    private int responseStatus = 200;
    private String responseText = "Ok";

    ExpectedResponseRecord(Expectation expectation) {
        this.expectation = expectation;
    }

    @Override
    public ExpectedResponse withHeader(String key, String value) {
        this.responseHeaders.add(key, value);
        return this;
    }

    @Override
    public ExpectedResponse withHeaders(Headers value) {
        value.all().forEach(h -> this.withHeader(h.getName(), h.getValue()));
        return this;
    }

    @Override
    public ExpectedResponse withStatus(int httpStatus) {
        return this.withStatus(httpStatus, "");
    }

    @Override
    public ExpectedResponse withStatus(int httpStatus, String statusMessage) {
        this.responseStatus = httpStatus;
        this.responseText = statusMessage;
        return this;
    }

    @Override
    public ExpectedResponse thenReturn(String body) {
        this.response = o -> body;
        return this;
    }

    @Override
    public ExpectedResponse thenReturn(JSONElement jsonObject) {
        this.response = o -> jsonObject.toString();
        return this;
    }

    @Override
    public ExpectedResponse thenReturn(Supplier<String> supplier) {
        this.response = o -> (String)supplier.get();
        return this;
    }

    @Override
    public void verify() {
        this.verify(null);
    }

    @Override
    public void verify(Times times) {
        if (this.expectation == null) {
            throw new UnirestAssertion("A expectation was never invoked!", new Object[0]);
        }
        this.expectation.verify(times);
    }

    @Override
    public ExpectedResponse thenReturn(Object pojo) {
        if (pojo instanceof MockResponse) {
            MockResponse res = (MockResponse)((Object)pojo);
            return this.thenReturn(res);
        }
        this.response = o -> o.writeValue(pojo);
        return this;
    }

    private ExpectedResponse thenReturn(MockResponse res) {
        this.response = o -> res.getBody() == null ? null : String.valueOf(res.getBody());
        return this.withStatus(res.getStatus(), res.getStatusText()).withHeaders(res.getHeaders());
    }

    @Override
    public RawResponse toRawResponse(Config config, HttpRequest request) {
        return new MockRawResponse(this.response.apply(this.getObjectMapper(request, config)), this.responseHeaders, this.responseStatus, this.responseText, config, request.toSummary());
    }

    private ObjectMapper getObjectMapper(HttpRequest request, Config config) {
        return Util.tryCast((Object)request, BaseRequest.class).map(BaseRequest::getObjectMapper).orElseGet(() -> config.getObjectMapper());
    }

    void setExpectation(Expectation invocation) {
        this.expectation = invocation;
    }
}

