/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kong.unirest.core.BaseRequest;
import kong.unirest.core.Body;
import kong.unirest.core.BodyMatcher;
import kong.unirest.core.BodyPart;
import kong.unirest.core.Config;
import kong.unirest.core.EqualsBodyMatcher;
import kong.unirest.core.Expectation;
import kong.unirest.core.ExpectedResponse;
import kong.unirest.core.Headers;
import kong.unirest.core.HttpRequest;
import kong.unirest.core.HttpRequestMultiPart;
import kong.unirest.core.HttpRequestUniBody;
import kong.unirest.core.MatchStatus;
import kong.unirest.core.MockRawResponse;
import kong.unirest.core.ObjectMapper;
import kong.unirest.core.QueryParams;
import kong.unirest.core.RawResponse;
import kong.unirest.core.Routes;
import kong.unirest.core.UnirestAssertion;
import kong.unirest.core.Util;
import kong.unirest.core.json.JSONElement;

class Invocation
implements Expectation,
ExpectedResponse {
    private Routes routes;
    private Function<ObjectMapper, String> response = o -> null;
    private Headers expectedHeaders = new Headers();
    private Headers expectedQueryParams = new Headers();
    private List<HttpRequest> requests = new ArrayList<HttpRequest>();
    private Headers responseHeaders = new Headers();
    private Boolean expected = false;
    private BodyMatcher expectedBody;
    private MatchStatus expectedBodyStatus;
    private int responseStatus = 200;
    private String responseText = "Ok";

    public Invocation(Routes routes) {
        this.routes = routes;
        this.expected = true;
    }

    public Invocation(Routes routes, HttpRequest request) {
        this.routes = routes;
        this.expectedHeaders = request.getHeaders();
    }

    Invocation(Routes routes, Invocation other) {
        this.routes = routes;
        this.response = other.response;
        this.responseStatus = other.responseStatus;
        this.responseText = other.responseText;
        this.responseHeaders.putAll(other.responseHeaders);
    }

    Invocation() {
    }

    @Override
    public ExpectedResponse thenReturn(String body) {
        this.response = o -> body;
        return this;
    }

    @Override
    public ExpectedResponse thenReturn(JSONElement jsonObject) {
        this.response = o -> jsonObject.toString();
        return this;
    }

    @Override
    public ExpectedResponse thenReturn(Object pojo) {
        this.response = o -> o.writeValue(pojo);
        return this;
    }

    @Override
    public ExpectedResponse thenReturn(Supplier<String> supplier) {
        this.response = o -> (String)supplier.get();
        return this;
    }

    RawResponse getResponse(Config config, HttpRequest request) {
        return new MockRawResponse(this.response.apply(this.getObjectMapper(request, config)), this.responseHeaders, this.responseStatus, this.responseText, config, request.toSummary());
    }

    private ObjectMapper getObjectMapper(HttpRequest request, Config config) {
        return Util.tryCast((Object)request, BaseRequest.class).map(BaseRequest::getObjectMapper).orElseGet(() -> config.getObjectMapper());
    }

    private Headers allHeaders() {
        return this.requests.stream().map(i -> i.getHeaders()).reduce((h1, h2) -> {
            h1.putAll(h2);
            return h1;
        }).orElseGet(Headers::new);
    }

    public void log(HttpRequest request) {
        this.requests.add(request);
    }

    @Override
    public Expectation header(String key, String value) {
        this.expectedHeaders.add(key, value);
        return this;
    }

    @Override
    public Expectation queryString(String key, String value) {
        this.expectedQueryParams.add(key, value);
        return this;
    }

    @Override
    public Expectation body(String body) {
        this.expectedBody = new EqualsBodyMatcher(body);
        return this;
    }

    @Override
    public Expectation body(BodyMatcher matcher) {
        this.expectedBody = matcher;
        return this;
    }

    @Override
    public ExpectedResponse thenReturn() {
        return this;
    }

    public void verify() {
        if (this.requests.isEmpty()) {
            throw new UnirestAssertion("A expectation was never invoked! %s", this.details());
        }
    }

    private String details() {
        StringBuilder sb = new StringBuilder(this.routes.getMethod().name()).append(" ").append(this.routes.getPath()).append(System.lineSeparator());
        if (this.expectedHeaders.size() > 0) {
            sb.append("Headers:\n");
            sb.append(this.expectedHeaders);
        }
        if (this.expectedQueryParams.size() > 0) {
            sb.append("Params:\n");
            sb.append(this.expectedQueryParams);
        }
        if (this.expectedBody != null) {
            sb.append("Body:\n");
            if (this.expectedBodyStatus != null) {
                sb.append("\t" + this.expectedBodyStatus.getDescription());
            } else {
                sb.append("\t null");
            }
        }
        return sb.toString();
    }

    public boolean hasExpectedHeader(String key, String value) {
        Headers allH = this.allHeaders();
        return allH.containsKey(key) && allH.get(key).contains(value);
    }

    private Stream<Body> getBodyStream() {
        return this.requests.stream().filter(r -> r.getBody().isPresent()).map(r -> (Body)r.getBody().get());
    }

    public boolean hasBody(String body) {
        return this.getBodyStream().anyMatch(b -> this.uniBodyMatches(body, (Body)b));
    }

    private boolean uniBodyMatches(String body, Body o) {
        return Invocation.tryCast(o, HttpRequestUniBody.class).map(h -> h.uniPart()).map(u -> u.getValue().equals(body)).orElse(false);
    }

    public boolean hasField(String name, String value) {
        return this.getBodyStream().anyMatch(b -> this.hasField(name, value, (Body)b));
    }

    private boolean hasField(String name, String value, Body b) {
        return ((Collection)Invocation.tryCast(b, HttpRequestMultiPart.class).map(h -> h.multiParts()).orElse(Collections.emptyList())).stream().anyMatch(part -> part.getName().equals(name) && part.getValue().equals(value));
    }

    public Integer requestSize() {
        return this.requests.size();
    }

    public List<HttpRequest> getRequests() {
        return this.requests;
    }

    @Override
    public ExpectedResponse withHeader(String key, String value) {
        this.responseHeaders.add(key, value);
        return this;
    }

    @Override
    public ExpectedResponse withStatus(int httpStatus) {
        return this.withStatus(httpStatus, "");
    }

    @Override
    public ExpectedResponse withStatus(int httpStatus, String statusMessage) {
        this.responseStatus = httpStatus;
        this.responseText = statusMessage;
        return this;
    }

    public Boolean isExpected() {
        return this.expected;
    }

    public Integer scoreMatch(HttpRequest request) {
        int score = 0;
        score += this.scoreHeaders(request);
        score += this.scoreQuery(request);
        return score += this.scoreBody(request);
    }

    private int scoreBody(HttpRequest request) {
        if (this.expectedBody != null) {
            return Invocation.tryCast(request, Body.class).map(this::matchBody).orElse(-1000);
        }
        return 0;
    }

    private Integer matchBody(Body b) {
        if (b.isEntityBody()) {
            BodyPart bodyPart = b.uniPart();
            if (bodyPart == null && this.expectedBody == null) {
                return 1;
            }
            if (String.class.isAssignableFrom(bodyPart.getPartType())) {
                this.expectedBodyStatus = this.expectedBody.matches(Arrays.asList((String)bodyPart.getValue()));
                if (this.expectedBodyStatus.isSuccess()) {
                    return 1;
                }
                return -1000;
            }
            if (this.expectedBody != null) {
                return -1000;
            }
        } else {
            List<String> parts = b.multiParts().stream().map(p -> p.toString()).collect(Collectors.toList());
            if (parts.isEmpty() && this.expectedBody == null) {
                return 1;
            }
            this.expectedBodyStatus = this.expectedBody.matches(parts);
            if (this.expectedBodyStatus.isSuccess()) {
                return 1;
            }
            return -1000;
        }
        return 0;
    }

    private int scoreHeaders(HttpRequest request) {
        if (this.expectedHeaders.size() > 0) {
            long b = this.expectedHeaders.all().stream().filter(h -> request.getHeaders().get(h.getName()).contains(h.getValue())).count();
            if (b != (long)this.expectedHeaders.size()) {
                return -1000;
            }
            return Long.valueOf(b).intValue();
        }
        return 0;
    }

    private int scoreQuery(HttpRequest request) {
        if (this.expectedQueryParams.size() > 0) {
            QueryParams p = QueryParams.fromURI((String)request.getUrl());
            long b = this.expectedQueryParams.all().stream().filter(h -> p.getQueryParams().stream().anyMatch(q -> q.getName().equalsIgnoreCase(h.getName()) && q.getValue().equalsIgnoreCase(h.getValue()))).count();
            if (b != (long)this.expectedQueryParams.size()) {
                return -1000;
            }
            return Long.valueOf(b).intValue();
        }
        return 0;
    }

    private static <T, M extends T> Optional<M> tryCast(T original, Class<M> too) {
        if (original != null && too.isAssignableFrom(original.getClass())) {
            return Optional.of(original);
        }
        return Optional.empty();
    }
}

