/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import kong.unirest.core.Config;
import kong.unirest.core.Headers;
import kong.unirest.core.HttpResponseSummary;
import kong.unirest.core.RawResponse;
import kong.unirest.core.ResponseSummary;

public class MockRawResponse
implements RawResponse {
    private final String response;
    private final Headers responseHeaders;
    private final int status;
    private final String statusMessage;
    private final Config config;

    public MockRawResponse(String responseBody, Headers responseHeaders, int status, String statusMessage, Config config) {
        this.response = responseBody;
        this.responseHeaders = responseHeaders;
        this.status = status;
        this.statusMessage = statusMessage;
        this.config = config;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusText() {
        return this.statusMessage;
    }

    public Headers getHeaders() {
        return this.responseHeaders;
    }

    public InputStream getContent() {
        return new ByteArrayInputStream(this.response.getBytes());
    }

    public byte[] getContentAsBytes() {
        return this.response.getBytes();
    }

    public String getContentAsString() {
        return this.response;
    }

    public String getContentAsString(String charset) {
        if (Objects.isNull(this.response)) {
            return null;
        }
        return new String(this.response.getBytes(), this.tryGetCharset(charset));
    }

    private Charset tryGetCharset(String charset) {
        if (Objects.isNull(charset)) {
            return StandardCharsets.UTF_8;
        }
        return Charset.forName(charset);
    }

    public InputStreamReader getContentReader() {
        return new InputStreamReader(this.getContent());
    }

    public boolean hasContent() {
        return this.response != null;
    }

    public String getContentType() {
        return this.responseHeaders.getFirst("Content-Type");
    }

    public String getEncoding() {
        return this.responseHeaders.getFirst("Content-Encoding");
    }

    public Config getConfig() {
        return this.config;
    }

    public HttpResponseSummary toSummary() {
        return new ResponseSummary((RawResponse)this);
    }
}

