/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kong.unirest.Assert;
import kong.unirest.AsyncClient;
import kong.unirest.Client;
import kong.unirest.Config;
import kong.unirest.Expectation;
import kong.unirest.HttpMethod;
import kong.unirest.HttpRequest;
import kong.unirest.HttpResponse;
import kong.unirest.HttpResponseSummary;
import kong.unirest.MetricContext;
import kong.unirest.Path;
import kong.unirest.RawResponse;
import kong.unirest.ResponseSummary;
import kong.unirest.Routes;
import kong.unirest.Unirest;
import kong.unirest.UnirestAssertion;
import kong.unirest.UnirestInstance;

public class MockClient
implements Client,
AsyncClient {
    private final Supplier<Config> config;
    private List<Routes> routes = new ArrayList<Routes>();

    public MockClient(Supplier<Config> config) {
        this.config = config;
    }

    public static MockClient register() {
        return MockClient.register(Unirest.primaryInstance());
    }

    public static MockClient register(UnirestInstance unirest) {
        MockClient client = new MockClient(() -> ((UnirestInstance)unirest).config());
        unirest.config().httpClient((Client)client).asyncClient((AsyncClient)client);
        return client;
    }

    public static void clear() {
        MockClient.clear(Unirest.primaryInstance());
    }

    public static void clear(UnirestInstance unirest) {
        if (unirest.config().getClient() instanceof MockClient) {
            unirest.config().httpClient((Client)null);
        }
        if (unirest.config().getAsyncClient() instanceof MockClient) {
            unirest.config().asyncClient((AsyncClient)null);
        }
    }

    public <T> HttpResponse<T> request(HttpRequest request, Function<RawResponse, HttpResponse<T>> transformer) {
        Routes exp = this.findExpecation(request);
        Config c = this.config.get();
        c.getUniInterceptor().onRequest(request, c);
        MetricContext metric = c.getMetric().begin(request.toSummary());
        RawResponse response = exp.exchange(request, c);
        metric.complete((HttpResponseSummary)new ResponseSummary(response), null);
        HttpResponse<T> rez = transformer.apply(response);
        c.getUniInterceptor().onResponse(rez, request.toSummary(), c);
        return rez;
    }

    private Routes findExpecation(HttpRequest request) {
        return this.routes.stream().filter(e -> e.matches(request)).findFirst().orElseGet(() -> this.createNewPath(request));
    }

    private Routes createNewPath(HttpRequest request) {
        Routes p = new Routes(request);
        this.routes.add(p);
        return p;
    }

    public <T> CompletableFuture<HttpResponse<T>> request(HttpRequest request, Function<RawResponse, HttpResponse<T>> transformer, CompletableFuture<HttpResponse<T>> callback) {
        return CompletableFuture.supplyAsync(() -> this.request(request, transformer));
    }

    public Object getClient() {
        return this;
    }

    public Stream<Exception> close() {
        return Stream.empty();
    }

    public void registerShutdownHook() {
    }

    public Expectation expect(HttpMethod method, String path) {
        Path p = new Path(path);
        Routes exp = this.findByPath(method, p).orElseGet(() -> new Routes(method, p));
        if (!this.routes.contains(exp)) {
            this.routes.add(exp);
        }
        return exp.newExpectation();
    }

    public Expectation expect(HttpMethod method) {
        return this.expect(method, null);
    }

    public Assert assertThat(HttpMethod method, String path) {
        return this.findByPath(method, new Path(path)).orElseThrow(() -> new UnirestAssertion(String.format("No Matching Invocation:: %s %s", method, path), new Object[0]));
    }

    private Optional<Routes> findByPath(HttpMethod get, Path path) {
        return this.routes.stream().filter(e -> e.matches(get, path)).findFirst();
    }

    public void verifyAll() {
        this.routes.forEach(Routes::verifyAll);
    }
}

