/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kong.unirest.Body;
import kong.unirest.BodyMatcher;
import kong.unirest.BodyPart;
import kong.unirest.Config;
import kong.unirest.EqualsBodyMatcher;
import kong.unirest.Expectation;
import kong.unirest.ExpectedResponse;
import kong.unirest.Headers;
import kong.unirest.HttpRequest;
import kong.unirest.JsonObjectMapper;
import kong.unirest.MatchStatus;
import kong.unirest.MockRawResponse;
import kong.unirest.RawResponse;
import kong.unirest.Routes;
import kong.unirest.UnirestAssertion;
import kong.unirest.json.JSONElement;
import org.apache.http.client.utils.URIBuilder;

class Invocation
implements Expectation,
ExpectedResponse {
    private Routes routes;
    private String response;
    private Headers expectedHeaders = new Headers();
    private Headers expectedQueryParams = new Headers();
    private List<HttpRequest> requests = new ArrayList<HttpRequest>();
    private Headers responseHeaders = new Headers();
    private Boolean expected = false;
    private BodyMatcher expectedBody;
    private MatchStatus expectedBodyStatus;
    private int responseStatus = 200;
    private String responseText = "Ok";

    public Invocation(Routes routes) {
        this.routes = routes;
        this.expected = true;
    }

    public Invocation(Routes routes, HttpRequest request) {
        this.routes = routes;
        this.expectedHeaders = request.getHeaders();
    }

    @Override
    public ExpectedResponse thenReturn(String body) {
        this.response = body;
        return this;
    }

    @Override
    public ExpectedResponse thenReturn(JSONElement jsonObject) {
        this.response = jsonObject.toString();
        return this;
    }

    @Override
    public ExpectedResponse thenReturn(Object pojo) {
        this.response = new JsonObjectMapper().writeValue(pojo);
        return this;
    }

    RawResponse getResponse(Config config) {
        return new MockRawResponse(this.response, this.responseHeaders, this.responseStatus, this.responseText, config);
    }

    private Headers allHeaders() {
        return this.requests.stream().map(i -> i.getHeaders()).reduce((h1, h2) -> {
            h1.putAll(h2);
            return h1;
        }).orElseGet(Headers::new);
    }

    public void log(HttpRequest request) {
        this.requests.add(request);
    }

    @Override
    public Expectation header(String key, String value) {
        this.expectedHeaders.add(key, value);
        return this;
    }

    @Override
    public Expectation queryString(String key, String value) {
        this.expectedQueryParams.add(key, value);
        return this;
    }

    @Override
    public Expectation body(String body) {
        this.expectedBody = new EqualsBodyMatcher(body);
        return this;
    }

    @Override
    public Expectation body(BodyMatcher matcher) {
        this.expectedBody = matcher;
        return this;
    }

    @Override
    public ExpectedResponse thenReturn() {
        return this;
    }

    public void verify() {
        if (this.requests.isEmpty()) {
            throw new UnirestAssertion("A expectation was never invoked! %s", this.details());
        }
    }

    private String details() {
        StringBuilder sb = new StringBuilder(this.routes.getMethod().name()).append(" ").append(this.routes.getPath()).append(System.lineSeparator());
        if (this.expectedHeaders.size() > 0) {
            sb.append("Headers:\n");
            sb.append(this.expectedHeaders);
        }
        if (this.expectedQueryParams.size() > 0) {
            sb.append("Params:\n");
            sb.append(this.expectedQueryParams);
        }
        if (this.expectedBody != null) {
            sb.append("Body:\n");
            sb.append("\t" + this.expectedBodyStatus.getDescription());
        }
        return sb.toString();
    }

    public boolean hasExpectedHeader(String key, String value) {
        Headers allH = this.allHeaders();
        return allH.containsKey(key) && allH.get(key).contains(value);
    }

    public Integer requestSize() {
        return this.requests.size();
    }

    public List<HttpRequest> getRequests() {
        return this.requests;
    }

    @Override
    public ExpectedResponse withHeader(String key, String value) {
        this.responseHeaders.add(key, value);
        return this;
    }

    @Override
    public ExpectedResponse withStatus(int httpStatus) {
        return this.withStatus(httpStatus, "");
    }

    @Override
    public ExpectedResponse withStatus(int httpStatus, String statusMessage) {
        this.responseStatus = httpStatus;
        this.responseText = statusMessage;
        return this;
    }

    public Boolean isExpected() {
        return this.expected;
    }

    public Integer scoreMatch(HttpRequest request) {
        int score = 0;
        score += this.scoreHeaders(request);
        score += this.scoreQuery(request);
        return score += this.scoreBody(request);
    }

    private int scoreBody(HttpRequest request) {
        if (this.expectedBody != null) {
            return Invocation.tryCast(request, Body.class).map(this::matchBody).orElse(-1000);
        }
        return 0;
    }

    private Integer matchBody(Body b) {
        if (b.isEntityBody()) {
            BodyPart bodyPart = b.uniPart();
            if (bodyPart == null && this.expectedBody == null) {
                return 1;
            }
            if (String.class.isAssignableFrom(bodyPart.getPartType())) {
                this.expectedBodyStatus = this.expectedBody.matches(Arrays.asList((String)bodyPart.getValue()));
                if (this.expectedBodyStatus.isSuccess()) {
                    return 1;
                }
                return -1000;
            }
            if (this.expectedBody != null) {
                return -1000;
            }
        } else {
            List<String> parts = b.multiParts().stream().map(p -> p.toString()).collect(Collectors.toList());
            if (parts.isEmpty() && this.expectedBody == null) {
                return 1;
            }
            this.expectedBodyStatus = this.expectedBody.matches(parts);
            if (this.expectedBodyStatus.isSuccess()) {
                return 1;
            }
            return -1000;
        }
        return 0;
    }

    private URIBuilder geturi(HttpRequest request) {
        try {
            URIBuilder b = new URIBuilder(request.getUrl());
            return b;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private int scoreHeaders(HttpRequest request) {
        if (this.expectedHeaders.size() > 0) {
            long b = this.expectedHeaders.all().stream().filter(h -> request.getHeaders().get(h.getName()).contains(h.getValue())).count();
            if (b != (long)this.expectedHeaders.size()) {
                return -1000;
            }
            return Long.valueOf(b).intValue();
        }
        return 0;
    }

    private int scoreQuery(HttpRequest request) {
        if (this.expectedQueryParams.size() > 0) {
            URIBuilder p = this.geturi(request);
            long b = this.expectedQueryParams.all().stream().filter(h -> p.getQueryParams().stream().anyMatch(q -> q.getName().equalsIgnoreCase(h.getName()) && q.getValue().equalsIgnoreCase(h.getValue()))).count();
            if (b != (long)this.expectedQueryParams.size()) {
                return -1000;
            }
            return Long.valueOf(b).intValue();
        }
        return 0;
    }

    private static <T, M extends T> Optional<M> tryCast(T original, Class<M> too) {
        if (original != null && too.isAssignableFrom(original.getClass())) {
            return Optional.of(original);
        }
        return Optional.empty();
    }
}

