/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import kong.unirest.BodyMatcher;
import kong.unirest.MatchStatus;

public class FieldMatcher
implements BodyMatcher {
    private final Map<String, String> formParams;

    public static FieldMatcher of(String ... keyValuePairs) {
        return new FieldMatcher(FieldMatcher.mapOf(keyValuePairs));
    }

    public FieldMatcher(Map<String, String> formParams) {
        this.formParams = formParams;
    }

    @Override
    public MatchStatus matches(List<String> body) throws AssertionError {
        ArrayList<String> missing = new ArrayList<String>();
        boolean pass = true;
        for (Map.Entry<String, String> r : this.formParams.entrySet()) {
            String expectedParam = r.getKey() + "=" + r.getValue();
            if (!body.stream().noneMatch(p -> Objects.equals(expectedParam, p))) continue;
            missing.add(expectedParam);
            pass = false;
        }
        return new MatchStatus(pass, this.description(pass, missing));
    }

    private String description(boolean pass, List<String> missing) {
        if (pass) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(System.lineSeparator() + "", "Missing Expected Fields. Expected: " + System.lineSeparator(), "");
        missing.forEach(m -> joiner.add((CharSequence)m));
        return joiner.toString();
    }

    private static <K, V> Map<K, V> mapOf(Object ... keyValues) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        Object key = null;
        for (int index = 0; index < keyValues.length; ++index) {
            if (index % 2 == 0) {
                key = keyValues[index];
                continue;
            }
            map.put(key, keyValues[index]);
        }
        return map;
    }
}

