/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import kong.unirest.Config;
import kong.unirest.Headers;
import kong.unirest.HttpResponseSummary;
import kong.unirest.RawResponse;
import kong.unirest.ResponseSummary;

public class MockRawResponse
implements RawResponse {
    private final String response;
    private final Headers responseHeaders;
    private final int status;
    private final String statusMessage;
    private final Config config;

    public MockRawResponse(String responseBody, Headers responseHeaders, int status, String statusMessage, Config config) {
        this.response = responseBody;
        this.responseHeaders = responseHeaders;
        this.status = status;
        this.statusMessage = statusMessage;
        this.config = config;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusText() {
        return this.statusMessage;
    }

    public Headers getHeaders() {
        return this.responseHeaders;
    }

    public InputStream getContent() {
        return new ByteArrayInputStream(this.response.getBytes());
    }

    public byte[] getContentAsBytes() {
        return this.response.getBytes();
    }

    public String getContentAsString() {
        return this.response;
    }

    public String getContentAsString(String charset) {
        if (Objects.isNull(this.response)) {
            return null;
        }
        return new String(this.response.getBytes(), this.tryGetCharset(charset));
    }

    private Charset tryGetCharset(String charset) {
        if (Objects.isNull(charset)) {
            return StandardCharsets.UTF_8;
        }
        return Charset.forName(charset);
    }

    public InputStreamReader getContentReader() {
        return new InputStreamReader(this.getContent());
    }

    public boolean hasContent() {
        return this.response != null;
    }

    public String getContentType() {
        return this.responseHeaders.getFirst("Content-Type");
    }

    public String getEncoding() {
        return this.responseHeaders.getFirst("Content-Encoding");
    }

    public Config getConfig() {
        return this.config;
    }

    public HttpResponseSummary toSummary() {
        return new ResponseSummary((RawResponse)this);
    }
}

