/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.json;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kong.unirest.json.JSONException;
import kong.unirest.json.JSONPointer;
import kong.unirest.json.ToObjectMapper;

public abstract class JSONElement {
    protected static final transient ToObjectMapper MAPPER = new ToObjectMapper();
    private static final transient Gson GSON = new Gson();
    private static final transient Gson PRETTY_GSON = new Gson().newBuilder().setPrettyPrinting().create();
    private final JsonElement element;

    protected JSONElement(JsonElement e) {
        this.element = e;
    }

    public Writer write(Writer sw) throws JSONException {
        JSONElement.write(this.element, sw);
        return sw;
    }

    public Writer write(Writer sw, int indentFactor, int indent) throws JSONException {
        JSONElement.writePretty(this.element, sw);
        return sw;
    }

    public Object query(String query) {
        return this.query(JSONPointer.compile(query));
    }

    public Object query(JSONPointer query) {
        return query.queryFrom(this);
    }

    public Object optQuery(String query) {
        try {
            return this.query(query);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object optQuery(JSONPointer query) {
        try {
            return query.queryFrom(this);
        }
        catch (Exception e) {
            return null;
        }
    }

    JsonElement getElement() {
        return this.element;
    }

    static JsonObject toJsonObject(Map map) {
        return JSONElement.fromJson(JSONElement.toJson(map), JsonObject.class);
    }

    static <T> T fromJson(String json, Class<T> classOfT) {
        try {
            return (T)GSON.fromJson(json, classOfT);
        }
        catch (JsonSyntaxException e) {
            throw new JSONException("Invalid JSON");
        }
    }

    static String toJson(Object collection) {
        return GSON.toJson(collection);
    }

    static void write(JsonElement obj, Writer sw) {
        GSON.toJson(obj, (Appendable)sw);
    }

    static Object unwrap(Object o) {
        if (o instanceof Iterable) {
            return StreamSupport.stream(((Iterable)o).spliterator(), false).map(JSONElement::unwrapObject).collect(Collectors.toList());
        }
        return JSONElement.unwrapObject(o);
    }

    static Object unwrapObject(Object o) {
        if (o instanceof JSONElement) {
            return ((JSONElement)o).getElement();
        }
        return o;
    }

    static void writePretty(JsonElement obj, Writer sw) {
        PRETTY_GSON.toJson(obj, (Appendable)sw);
    }

    static JsonArray toJsonArray(Collection collection) {
        return JSONElement.fromJson(JSONElement.toJson(collection), JsonArray.class);
    }

    static String toPrettyJson(JsonElement obj) {
        return PRETTY_GSON.toJson(obj);
    }

    static Map<String, Object> toMap(JsonObject obj) {
        return (Map)GSON.fromJson((JsonElement)obj, Map.class);
    }
}

