/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kong.unirest.UnirestException;
import kong.unirest.Util;

class Path {
    private String url;
    private String rawPath;

    Path(String url) {
        this.url = url;
        this.rawPath = url;
    }

    public void param(Map<String, Object> params) {
        params.forEach((key, value) -> this.param((String)key, String.valueOf(value)));
    }

    public void param(String name, String value) {
        Matcher matcher = Pattern.compile("\\{" + name + "\\}").matcher(this.url);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        if (count == 0) {
            throw new UnirestException("Can't find route parameter name \"" + name + "\"");
        }
        this.url = this.url.replaceAll("\\{" + name + "\\}", this.encodePath(value));
    }

    private String encodePath(String value) {
        if (value == null) {
            return "";
        }
        return Util.encode(value).replaceAll("\\+", "%20");
    }

    public void queryString(String name, Collection<?> value) {
        for (Object cur : value) {
            this.queryString(name, cur);
        }
    }

    public void queryString(String name, Object value) {
        StringBuilder queryString = new StringBuilder();
        if (this.url.contains("?")) {
            queryString.append("&");
        } else {
            queryString.append("?");
        }
        try {
            queryString.append(URLEncoder.encode(name, "UTF-8"));
            if (value != null) {
                queryString.append("=").append(URLEncoder.encode(String.valueOf(value), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new UnirestException(e);
        }
        this.url = this.url + queryString.toString();
    }

    public void queryString(Map<String, Object> parameters) {
        if (parameters != null) {
            for (Map.Entry<String, Object> param : parameters.entrySet()) {
                this.queryString(param.getKey(), param.getValue());
            }
        }
    }

    public String toString() {
        return this.url;
    }

    public String rawPath() {
        return this.rawPath;
    }
}

