/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.Instant;
import java.util.Base64;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kong.unirest.UnirestConfigException;
import kong.unirest.UnirestException;

class Util {
    private static Supplier<Instant> clock = Instant::now;

    Util() {
    }

    static void freezeClock(Instant instant) {
        clock = () -> instant;
    }

    static void resetClock() {
        clock = Instant::now;
    }

    static Instant now() {
        return clock.get();
    }

    static <T, M extends T> Optional<M> tryCast(T original, Class<M> too) {
        if (original != null && too.isAssignableFrom(original.getClass())) {
            return Optional.of(original);
        }
        return Optional.empty();
    }

    static <T> Stream<T> stream(Optional<T> opt) {
        return opt.map(Stream::of).orElseGet(Stream::empty);
    }

    static String nullToEmpty(Object v) {
        if (v == null) {
            return "";
        }
        return String.valueOf(v);
    }

    static String encode(String input) {
        try {
            return URLEncoder.encode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnirestException(e);
        }
    }

    static boolean isNullOrEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static String toBasicAuthValue(String username, String password) {
        return "Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes());
    }

    static FileInputStream getFileInputStream(String location) {
        try {
            return new FileInputStream(location);
        }
        catch (FileNotFoundException e) {
            throw new UnirestConfigException(e);
        }
    }
}

