/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.json;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import kong.unirest.json.JSONArray;
import kong.unirest.json.JSONObject;
import kong.unirest.json.JSONPointerException;

public class JSONPointer {
    private final String section;
    private final JSONPointer next;

    private JSONPointer() {
        this.section = null;
        this.next = null;
    }

    public JSONPointer(String query) {
        JSONPointer compiled = JSONPointer.compile(query);
        this.section = compiled.section;
        this.next = compiled.next;
    }

    private JSONPointer(String section, JSONPointer nextNode) {
        this.section = section;
        this.next = nextNode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("/");
        sb.append(JSONPointer.unescape(this.section));
        if (this.next != null) {
            sb.append(this.next.toString());
        }
        return sb.toString();
    }

    public String toURIFragment() {
        return "#" + this.toUriChunk();
    }

    private String toUriChunk() {
        try {
            StringBuilder sb = new StringBuilder("/");
            sb.append(URLEncoder.encode(this.section, "UTF-8"));
            if (this.next != null) {
                sb.append(this.next.toUriChunk());
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new JSONPointerException("UTF-8 encoder not found. Is that even possible?", new Object[0]);
        }
    }

    public static JSONPointer compile(String query) {
        Objects.requireNonNull(query, "pointer cannot be null");
        if (!(query.equals("") || query.startsWith("/") || query.startsWith("#/"))) {
            throw new IllegalArgumentException("a JSON pointer should start with '/' or '#/'");
        }
        return JSONPointer.createPointer(query);
    }

    private static JSONPointer createPointer(String query) {
        if (query.equals("")) {
            return new JSONPointer();
        }
        return JSONPointer.compileNext(query);
    }

    private static JSONPointer compileNext(String query) {
        int end = query.length();
        int i = 1;
        while (i < end) {
            char c = query.charAt(i);
            if (c == '/') {
                return new JSONPointer(query.substring(1, i), JSONPointer.compileNext(query.substring(i)));
            }
            if (c != '~' || ++i >= end) continue;
            return JSONPointer.compileNextEscaped(query, i);
        }
        return new JSONPointer(query.substring(1), null);
    }

    private static JSONPointer compileNextEscaped(String query, int i) {
        int end = query.length();
        StringBuilder sb = new StringBuilder(Math.max(16, end));
        if (i > 2) {
            sb.append(query, 1, i - 1);
        }
        JSONPointer.escape(sb, query.charAt(i++));
        while (i < end) {
            char c = query.charAt(i);
            if (c == '/') {
                return new JSONPointer(sb.toString(), JSONPointer.compileNext(query.substring(i)));
            }
            if (c == '~' && ++i < end) {
                JSONPointer.escape(sb, query.charAt(i++));
                continue;
            }
            sb.append(c);
        }
        return new JSONPointer(sb.toString(), null);
    }

    private static String unescape(String s) {
        String finalToken = s;
        if (s.contains("~")) {
            finalToken = finalToken.replaceAll("~", "~0");
        }
        if (s.contains("/")) {
            finalToken = finalToken.replaceAll("/", "~1");
        }
        return finalToken;
    }

    private static void escape(StringBuilder sb, char c) {
        if (c == '0') {
            c = (char)126;
        } else if (c == '1') {
            c = (char)47;
        } else {
            sb.append('~');
        }
        sb.append(c);
    }

    public Object queryFrom(Object object) throws JSONPointerException {
        if (this.section == null) {
            return object;
        }
        Queryable e = this.verify(object);
        Object o = e.querySection(this.section);
        if (this.next != null) {
            return this.next.queryFrom(o);
        }
        return o;
    }

    private Queryable verify(Object object) {
        if (JSONObject.class.isInstance(object)) {
            return new QueryObject((JSONObject)object);
        }
        if (JSONArray.class.isInstance(object)) {
            return new QueryArray((JSONArray)object);
        }
        throw new IllegalArgumentException("May only query JSONObject or JSONArray");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private StringBuilder sb = new StringBuilder();

        private Builder() {
        }

        public Builder append(String token) {
            this.sb.append("/").append(token);
            return this;
        }

        public Builder append(int index) {
            return this.append(String.valueOf(index));
        }

        public JSONPointer build() {
            return new JSONPointer(this.sb.toString());
        }
    }

    private class QueryArray
    implements Queryable {
        private final JSONArray array;

        public QueryArray(JSONArray array) {
            this.array = array;
        }

        @Override
        public Object querySection(String key) {
            Integer index = this.getIndex(key);
            if (index > this.array.length()) {
                throw new JSONPointerException("index %s is out of bounds - the array has %s elements", index, this.array.length());
            }
            return this.array.get(index);
        }

        private Integer getIndex(String index) {
            try {
                return Integer.valueOf(index);
            }
            catch (NumberFormatException e) {
                throw new JSONPointerException("%s is not an array index", index);
            }
        }
    }

    private class QueryObject
    implements Queryable {
        private final JSONObject obj;

        public QueryObject(JSONObject object) {
            this.obj = object;
        }

        @Override
        public Object querySection(String key) {
            if (this.obj.has(key)) {
                return this.obj.get(key);
            }
            return null;
        }
    }

    private static interface Queryable<T> {
        public Object querySection(String var1);
    }
}

