/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.apache;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kong.unirest.Config;
import kong.unirest.UnirestConfigException;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;

class SecurityConfig {
    private final Config config;
    private SSLContext sslContext;
    private SSLConnectionSocketFactory sslSocketFactory;

    public SecurityConfig(Config config) {
        this.config = config;
    }

    public PoolingHttpClientConnectionManager createManager() {
        return this.buildSocketFactory().map(PoolingHttpClientConnectionManager::new).orElseGet(PoolingHttpClientConnectionManager::new);
    }

    private Optional<Registry<ConnectionSocketFactory>> buildSocketFactory() {
        try {
            if (!this.config.isVerifySsl()) {
                return Optional.of(this.createDisabledSSLContext());
            }
            if (this.config.getKeystore() != null) {
                return Optional.of(this.createCustomSslContext());
            }
        }
        catch (Exception e) {
            throw new UnirestConfigException(e);
        }
        return Optional.empty();
    }

    private Registry<ConnectionSocketFactory> createCustomSslContext() {
        SSLConnectionSocketFactory socketFactory = this.getSocketFactory();
        return RegistryBuilder.create().register("https", (Object)socketFactory).register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
    }

    private SSLConnectionSocketFactory getSocketFactory() {
        if (this.sslSocketFactory == null) {
            this.sslSocketFactory = new SSLConnectionSocketFactory(this.createSslContext(), (HostnameVerifier)new NoopHostnameVerifier());
        }
        return this.sslSocketFactory;
    }

    private Registry<ConnectionSocketFactory> createDisabledSSLContext() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
        return RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(new SSLContextBuilder().loadTrustMaterial(null, (x509CertChain, authType) -> true).build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build();
    }

    private SSLContext createSslContext() {
        if (this.sslContext == null) {
            try {
                char[] pass = Optional.ofNullable(this.config.getKeyStorePassword()).map(String::toCharArray).orElse(null);
                this.sslContext = SSLContexts.custom().loadKeyMaterial(this.config.getKeystore(), pass).build();
            }
            catch (Exception e) {
                throw new UnirestConfigException(e);
            }
        }
        return this.sslContext;
    }

    public void configureSecurity(HttpClientBuilder cb) {
        if (this.config.getKeystore() != null) {
            cb.setSSLContext(this.createSslContext());
            cb.setSSLSocketFactory((LayeredConnectionSocketFactory)this.getSocketFactory());
        }
        if (!this.config.isVerifySsl()) {
            this.disableSsl(cb);
        }
    }

    private void disableSsl(HttpClientBuilder cb) {
        try {
            cb.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            cb.setSSLContext(new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)((TrustStrategy)(arg0, arg1) -> true)).build());
        }
        catch (Exception e) {
            throw new UnirestConfigException(e);
        }
    }
}

