/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.apache;

import java.util.function.Function;
import kong.unirest.BasicResponse;
import kong.unirest.HttpResponse;
import kong.unirest.Proxy;
import kong.unirest.RawResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;

abstract class BaseApacheClient {
    BaseApacheClient() {
    }

    protected CredentialsProvider toApacheCreds(Proxy proxy) {
        if (proxy != null && proxy.isAuthenticated()) {
            BasicCredentialsProvider proxyCreds = new BasicCredentialsProvider();
            proxyCreds.setCredentials(new AuthScope(proxy.getHost(), proxy.getPort().intValue()), (Credentials)new UsernamePasswordCredentials(proxy.getUsername(), proxy.getPassword()));
            return proxyCreds;
        }
        return null;
    }

    protected <T> HttpResponse<T> transformBody(Function<RawResponse, HttpResponse<T>> transformer, RawResponse rr) {
        try {
            return transformer.apply(rr);
        }
        catch (RuntimeException e) {
            String originalBody = this.recoverBody(rr);
            return new BasicResponse(rr, originalBody, e);
        }
    }

    private String recoverBody(RawResponse rr) {
        try {
            return rr.getContentAsString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

