/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core;

import java.util.StringJoiner;
import java.util.function.Function;
import kong.unirest.core.Body;
import kong.unirest.core.HttpRequest;
import kong.unirest.core.Path;

class SummaryFormatter
implements Function<HttpRequest<?>, String> {
    SummaryFormatter() {
    }

    @Override
    public String apply(HttpRequest<?> req) {
        StringJoiner sb = new StringJoiner(System.lineSeparator());
        sb.add(req.getHttpMethod().name() + " " + req.getUrl());
        req.getHeaders().all().forEach(h -> sb.add(h.getName() + ": " + h.getValue()));
        req.getBody().ifPresent(body -> {
            if (!req.getHeaders().containsKey("content-type") && body.isMultiPart()) {
                sb.add(String.format("Content-Type: multipart/form-data; boundary=%s;charset=%s\"", body.getBoundary(), body.getCharset()));
            }
        });
        sb.add("===================================");
        this.addBody(req, sb);
        return sb.toString();
    }

    private void addBody(HttpRequest<?> req, StringJoiner sb) {
        req.getBody().ifPresent(b -> {
            if (b.isEntityBody()) {
                sb.add(String.valueOf(b.uniPart().getValue()));
            } else if (b.isMultiPart()) {
                this.toMultiPartAproximation((Body)b, sb);
            } else {
                Path path = new Path("/");
                b.multiParts().stream().filter(p -> !p.isFile()).forEach(p -> path.queryString(p.getName(), p.getValue()));
                sb.add(path.getQueryString());
            }
        });
    }

    private String toMultiPartAproximation(Body b, StringJoiner sj) {
        b.multiParts().forEach(p -> {
            sj.add("--" + b.getBoundary());
            if (p.isFile()) {
                sj.add(String.format("Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"", p.getName(), p.getFileName()));
                sj.add("Content-Type: " + p.getContentType());
                sj.add("<BINARY DATA>");
            } else {
                sj.add("Content-Disposition: form-data; name:\"" + p.getName() + "\"");
                sj.add("Content-Type: " + p.getContentType());
                sj.add(String.valueOf(p.getValue()));
            }
            sj.add("");
        });
        return sj.toString();
    }
}

