/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core.json;

import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import kong.unirest.core.UnirestConfigException;
import kong.unirest.core.json.JsonEngine;

public class CoreFactory {
    private static final List<Supplier<JsonEngine>> SERVICE_LOCATORS = List.of(CoreFactory::findEngineWithServiceLocator, CoreFactory::findEngineWithClassLoader);
    private static final List<String> KNOWN_IMPLEMENTATIONS = List.of("kong.unirest.jackson.JacksonEngine", "kong.unirest.gson.GsonEngine");
    private static JsonEngine engine;

    public static void autoConfig() {
        engine = CoreFactory.findEngine();
    }

    public static JsonEngine getCore() {
        if (engine == null) {
            throw CoreFactory.getException();
        }
        return engine;
    }

    public static void setEngine(JsonEngine jsonEngine) {
        engine = jsonEngine;
    }

    public static JsonEngine findEngine() {
        for (Supplier<JsonEngine> engineSupplier : SERVICE_LOCATORS) {
            JsonEngine foundEngine = engineSupplier.get();
            if (foundEngine == null) continue;
            return foundEngine;
        }
        return null;
    }

    public static JsonEngine findEngineWithServiceLocator() {
        return ServiceLoader.load(JsonEngine.class).findFirst().orElse(null);
    }

    public static JsonEngine findEngineWithClassLoader() {
        for (String className : KNOWN_IMPLEMENTATIONS) {
            try {
                Class<?> engineClass = Class.forName(className);
                return (JsonEngine)engineClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private static UnirestConfigException getException() {
        return new UnirestConfigException(String.format("No Json Parsing Implementation Provided%nPlease add a dependency for a Unirest JSON Engine. This can be one of:%n<!-- Google Gson (the previous core impl) -->%n<dependency>%n  <groupId>com.konghq</groupId>%n  <artifactId>unirest-object-mappers-gson</artifactId>%n  <version>${latest-version}</version>%n</dependency>%n%n<!-- Jackson -->%n<dependency>%n  <groupId>com.konghq</groupId>%n  <artifactId>unirest-object-mappers-jackson</artifactId>%n  <version>${latest-version}</version>%n</dependency>)%n%nAlternatively you may register your own JsonEngine directly with CoreFactory.setEngine(JsonEngine jsonEngine)", new Object[0]));
    }

    static {
        CoreFactory.autoConfig();
    }
}

