/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core;

import java.util.Optional;
import kong.unirest.core.BaseRequest;
import kong.unirest.core.Body;
import kong.unirest.core.BodyPart;
import kong.unirest.core.Config;
import kong.unirest.core.HttpMethod;
import kong.unirest.core.JsonPatch;
import kong.unirest.core.JsonPatchRequest;
import kong.unirest.core.UnibodyString;

class HttpRequestJsonPatch
extends BaseRequest<JsonPatchRequest>
implements JsonPatchRequest {
    private JsonPatch items = new JsonPatch();

    HttpRequestJsonPatch(Config config, String url) {
        super(config, HttpMethod.PATCH, url);
        this.header("Content-Type", "application/json-patch+json");
    }

    @Override
    public JsonPatchRequest add(String path, Object value) {
        this.items.add(path, value);
        return this;
    }

    @Override
    public JsonPatchRequest remove(String path) {
        this.items.remove(path);
        return this;
    }

    @Override
    public JsonPatchRequest replace(String path, Object value) {
        this.items.replace(path, value);
        return this;
    }

    @Override
    public JsonPatchRequest test(String path, Object value) {
        this.items.test(path, value);
        return this;
    }

    @Override
    public JsonPatchRequest move(String from, String path) {
        this.items.move(from, path);
        return this;
    }

    @Override
    public JsonPatchRequest copy(String from, String path) {
        this.items.copy(from, path);
        return this;
    }

    @Override
    public Optional<Body> getBody() {
        return Optional.of(this);
    }

    @Override
    public BodyPart uniPart() {
        String bodyAsString = this.items.toString();
        return new UnibodyString(bodyAsString);
    }

    @Override
    public boolean isMultiPart() {
        return false;
    }

    @Override
    public boolean isEntityBody() {
        return true;
    }
}

