/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core;

import kong.unirest.core.json.JSONArray;
import kong.unirest.core.json.JSONException;
import kong.unirest.core.json.JSONObject;

public class JsonNode {
    private JSONObject jsonObject;
    private JSONArray jsonArray;
    private boolean array;

    public JsonNode(String json) {
        if (json == null || "".equals(json.trim())) {
            this.jsonObject = new JSONObject();
        } else {
            try {
                this.jsonObject = new JSONObject(json);
            }
            catch (JSONException e) {
                this.jsonArray = new JSONArray(json);
                this.array = true;
            }
        }
    }

    public JSONObject getObject() {
        return this.jsonObject;
    }

    public JSONArray getArray() {
        JSONArray result = this.jsonArray;
        if (!this.array) {
            result = new JSONArray();
            result.put(this.jsonObject);
        }
        return result;
    }

    public boolean isArray() {
        return this.array;
    }

    public String toString() {
        if (this.isArray()) {
            return this.jsonArray.toString();
        }
        return this.jsonObject.toString();
    }

    public String toPrettyString() {
        if (this.isArray()) {
            return this.jsonArray.toString(2);
        }
        return this.jsonObject.toString(2);
    }
}

