/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.hash.HashOverflowException;
import com.koloboke.collect.impl.PrimitiveConstants;
import com.koloboke.collect.impl.ShortArrays;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.HashConfigWrapper;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.ParallelKVShortLHash;
import com.koloboke.collect.impl.hash.UpdatableLHash;
import java.util.ConcurrentModificationException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public abstract class UpdatableParallelKVShortLHashSO
extends UpdatableLHash
implements ParallelKVShortLHash,
PrimitiveConstants,
UnsafeConstants {
    short freeValue;
    int[] table;

    void copy(ParallelKVShortLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.table = (int[])hash.table().clone();
    }

    void move(ParallelKVShortLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.table = hash.table();
    }

    final void init(HashConfigWrapper configWrapper, int size, short freeValue) {
        this.freeValue = freeValue;
        super.init(configWrapper, size);
    }

    @Override
    public short freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return false;
    }

    @Override
    public short removedValue() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object key) {
        return this.contains((Short)key);
    }

    public boolean contains(short key) {
        return this.index(key) >= 0;
    }

    int index(short key) {
        short free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVShortKeyMixing.mix((short)key) & capacityMask;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            do {
                if ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return index;
            } while (cur != free);
            return -1;
        }
        return -1;
    }

    private short findNewFreeOrRemoved() {
        short newFree;
        block6: {
            int mc = this.modCount();
            int size = this.size();
            if (size >= 65535) {
                throw new HashOverflowException();
            }
            short free = this.freeValue;
            ThreadLocalRandom random = ThreadLocalRandom.current();
            if (size > 49152) {
                int nf = ((Random)random).nextInt(65536) * 21859;
                for (int i = 0; i < 65536; ++i) {
                    newFree = (short)(nf += 21859);
                    if (newFree == free || this.index(newFree) >= 0) {
                        continue;
                    }
                    break block6;
                }
                if (mc != this.modCount()) {
                    throw new ConcurrentModificationException();
                }
                throw new AssertionError((Object)"Impossible state");
            }
            while ((newFree = (short)((Random)random).nextInt()) == free || this.index(newFree) >= 0) {
            }
        }
        return newFree;
    }

    short changeFree() {
        int mc = this.modCount();
        short newFree = this.findNewFreeOrRemoved();
        this.incrementModCount();
        ShortArrays.replaceAllKeys((int[])this.table, (short)this.freeValue, (short)newFree);
        this.freeValue = newFree;
        if (++mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newFree;
    }

    @Override
    void allocateArrays(int capacity) {
        this.table = new int[capacity];
        if (this.freeValue != 0) {
            ShortArrays.fillKeys((int[])this.table, (short)this.freeValue);
        }
    }

    @Override
    public void clear() {
        super.clear();
        ShortArrays.fillKeys((int[])this.table, (short)this.freeValue);
    }
}

