/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.impl.IntArrays;
import com.koloboke.collect.impl.PrimitiveConstants;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.HashConfigWrapper;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.ParallelKVIntLHash;
import com.koloboke.collect.impl.hash.UpdatableLHash;
import java.util.ConcurrentModificationException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public abstract class UpdatableParallelKVIntLHashSO
extends UpdatableLHash
implements ParallelKVIntLHash,
PrimitiveConstants,
UnsafeConstants {
    int freeValue;
    long[] table;

    void copy(ParallelKVIntLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.table = (long[])hash.table().clone();
    }

    void move(ParallelKVIntLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.table = hash.table();
    }

    final void init(HashConfigWrapper configWrapper, int size, int freeValue) {
        this.freeValue = freeValue;
        super.init(configWrapper, size);
    }

    @Override
    public int freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return false;
    }

    @Override
    public int removedValue() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object key) {
        return this.contains((Integer)key);
    }

    public boolean contains(int key) {
        return this.index(key) >= 0;
    }

    int index(int key) {
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix((int)key) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return index;
            } while (cur != free);
            return -1;
        }
        return -1;
    }

    private int findNewFreeOrRemoved() {
        int newFree;
        int free = this.freeValue;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while ((newFree = ((Random)random).nextInt()) == free || this.index(newFree) >= 0) {
        }
        return newFree;
    }

    int changeFree() {
        int mc = this.modCount();
        int newFree = this.findNewFreeOrRemoved();
        this.incrementModCount();
        IntArrays.replaceAllKeys((long[])this.table, (int)this.freeValue, (int)newFree);
        this.freeValue = newFree;
        if (++mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newFree;
    }

    @Override
    void allocateArrays(int capacity) {
        this.table = new long[capacity];
        if (this.freeValue != 0) {
            IntArrays.fillKeys((long[])this.table, (int)this.freeValue);
        }
    }

    @Override
    public void clear() {
        super.clear();
        IntArrays.fillKeys((long[])this.table, (int)this.freeValue);
    }
}

