/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.DoubleCollection;
import com.koloboke.collect.DoubleCursor;
import com.koloboke.collect.DoubleIterator;
import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractDoubleValueView;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonFloatDoubleMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalDoubleCollectionOps;
import com.koloboke.collect.impl.InternalFloatDoubleMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.SeparateKVFloatDoubleLHash;
import com.koloboke.collect.impl.hash.UpdatableLHashSeparateKVFloatDoubleMapSO;
import com.koloboke.collect.map.FloatDoubleCursor;
import com.koloboke.collect.set.DoubleSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.FloatDoubleConsumer;
import com.koloboke.function.FloatDoublePredicate;
import com.koloboke.function.FloatDoubleToDoubleFunction;
import com.koloboke.function.FloatToDoubleFunction;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class UpdatableLHashSeparateKVFloatDoubleMapGO
extends UpdatableLHashSeparateKVFloatDoubleMapSO {
    @Override
    final void copy(SeparateKVFloatDoubleLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVFloatDoubleLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public double defaultValue() {
        return 0.0;
    }

    public boolean containsEntry(float key, double value) {
        int k = Float.floatToIntBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index] == Double.doubleToLongBits(value);
        }
        return false;
    }

    public boolean containsEntry(int key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public Double get(Object key) {
        int k = Float.floatToIntBits(((Float)key).floatValue());
        int index = this.index(k);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return null;
    }

    public double get(float key) {
        int k = Float.floatToIntBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return this.defaultValue();
    }

    public Double getOrDefault(Object key, Double defaultValue) {
        int k = Float.floatToIntBits(((Float)key).floatValue());
        int index = this.index(k);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return defaultValue;
    }

    public double getOrDefault(float key, double defaultValue) {
        int k = Float.floatToIntBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Float, ? super Double> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            action.accept(Float.valueOf(Float.intBitsToFloat(key)), (Double)Double.longBitsToDouble(vals[i]));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(FloatDoubleConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            action.accept(Float.intBitsToFloat(key), Double.longBitsToDouble(vals[i]));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(FloatDoublePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE || predicate.test(Float.intBitsToFloat(key), Double.longBitsToDouble(vals[i]))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public FloatDoubleCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonFloatDoubleMapOps.containsAllEntries((InternalFloatDoubleMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalFloatDoubleMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalFloatDoubleMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            m.justPut(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Float, Double>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public DoubleCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            long val = vals[i];
            hashCode += key ^ (int)(val ^ val >>> 32);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            sb.append(' ');
            sb.append(Float.intBitsToFloat(key));
            sb.append('=');
            sb.append(Double.longBitsToDouble(vals[i]));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        int[] keys = this.set;
        long[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        int[] newKeys = this.set;
        int capacityMask = newKeys.length - 1;
        long[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            int index = LHash.SeparateKVFloatKeyMixing.mix((int)key) & capacityMask;
            if (newKeys[index] != 0x7FFFFFFE) {
                while (newKeys[index = index - 1 & capacityMask] != 0x7FFFFFFE) {
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Double put(Float key, Double value) {
        int k = Float.floatToIntBits(key.floatValue());
        int index = this.insert(k, Double.doubleToLongBits(value));
        if (index < 0) {
            return null;
        }
        long[] vals = this.values;
        double prevValue = Double.longBitsToDouble(vals[index]);
        vals[index] = Double.doubleToLongBits(value);
        return prevValue;
    }

    public double put(float key, double value) {
        int k = Float.floatToIntBits(key);
        int index = this.insert(k, Double.doubleToLongBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        long[] vals = this.values;
        double prevValue = Double.longBitsToDouble(vals[index]);
        vals[index] = Double.doubleToLongBits(value);
        return prevValue;
    }

    public Double putIfAbsent(Float key, Double value) {
        int k = Float.floatToIntBits(key.floatValue());
        int index = this.insert(k, Double.doubleToLongBits(value));
        if (index < 0) {
            return null;
        }
        return Double.longBitsToDouble(this.values[index]);
    }

    public double putIfAbsent(float key, double value) {
        int k = Float.floatToIntBits(key);
        int index = this.insert(k, Double.doubleToLongBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        return Double.longBitsToDouble(this.values[index]);
    }

    public void justPut(float key, double value) {
        int k = Float.floatToIntBits(key);
        int index = this.insert(k, Double.doubleToLongBits(value));
        if (index < 0) {
            return;
        }
        this.values[index] = Double.doubleToLongBits(value);
    }

    public void justPut(int key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    /*
     * Unable to fully structure code
     */
    public Double compute(Float key, BiFunction<? super Float, ? super Double, ? extends Double> remappingFunction) {
        block4: {
            k = Float.floatToIntBits(key.floatValue());
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVFloatKeyMixing.mix((int)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block4;
            if (cur == 0x7FFFFFFE) ** GOTO lbl13
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFE) continue;
lbl13:
                // 2 sources

                if ((newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)), null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = Double.doubleToLongBits(newValue);
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)), (Double)Double.longBitsToDouble(vals[index]))) != null) {
            vals[index] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public double compute(float key, FloatDoubleToDoubleFunction remappingFunction) {
        block2: {
            k = Float.floatToIntBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVFloatKeyMixing.mix((int)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block2;
            if (cur == 0x7FFFFFFE) ** GOTO lbl13
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFE) continue;
lbl13:
                // 2 sources

                newValue = remappingFunction.applyAsDouble(Float.intBitsToFloat(k), this.defaultValue());
                this.incrementModCount();
                keys[index] = k;
                vals[index] = Double.doubleToLongBits(newValue);
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = remappingFunction.applyAsDouble(Float.intBitsToFloat(k), Double.longBitsToDouble(vals[index]));
        vals[index] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    public Double computeIfAbsent(Float key, Function<? super Float, ? extends Double> mappingFunction) {
        Double value;
        int k = Float.floatToIntBits(key.floatValue());
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        int[] keys = this.set;
        long[] vals = this.values;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVFloatKeyMixing.mix((int)k) & capacityMask;
        int cur = keys[index];
        if (cur == k) {
            return Double.longBitsToDouble(vals[index]);
        }
        if (cur != 0x7FFFFFFE) {
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != k) continue;
                return Double.longBitsToDouble(vals[index]);
            } while (cur != 0x7FFFFFFE);
        }
        if ((value = mappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)))) != null) {
            this.incrementModCount();
            keys[index] = k;
            vals[index] = Double.doubleToLongBits(value);
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public double computeIfAbsent(float key, FloatToDoubleFunction mappingFunction) {
        int k = Float.floatToIntBits(key);
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        int[] keys = this.set;
        long[] vals = this.values;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVFloatKeyMixing.mix((int)k) & capacityMask;
        int cur = keys[index];
        if (cur == k) {
            return Double.longBitsToDouble(vals[index]);
        }
        if (cur != 0x7FFFFFFE) {
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != k) continue;
                return Double.longBitsToDouble(vals[index]);
            } while (cur != 0x7FFFFFFE);
        }
        double value = mappingFunction.applyAsDouble(Float.intBitsToFloat(k));
        this.incrementModCount();
        keys[index] = k;
        vals[index] = Double.doubleToLongBits(value);
        this.postInsertHook();
        return value;
    }

    public Double computeIfPresent(Float key, BiFunction<? super Float, ? super Double, ? extends Double> remappingFunction) {
        int k = Float.floatToIntBits(key.floatValue());
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            long[] vals = this.values;
            Double newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)), (Double)Double.longBitsToDouble(vals[index]));
            if (newValue != null) {
                vals[index] = Double.doubleToLongBits(newValue);
                return newValue;
            }
            throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
        }
        return null;
    }

    public double computeIfPresent(float key, FloatDoubleToDoubleFunction remappingFunction) {
        int k = Float.floatToIntBits(key);
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            long[] vals = this.values;
            double newValue = remappingFunction.applyAsDouble(Float.intBitsToFloat(k), Double.longBitsToDouble(vals[index]));
            vals[index] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    public Double merge(Float key, Double value, BiFunction<? super Double, ? super Double, ? extends Double> remappingFunction) {
        block4: {
            k = Float.floatToIntBits(key.floatValue());
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVFloatKeyMixing.mix((int)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block4;
            if (cur == 0x7FFFFFFE) ** GOTO lbl15
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFE) continue;
lbl15:
                // 2 sources

                this.incrementModCount();
                keys[index] = k;
                vals[index] = Double.doubleToLongBits(value);
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Double)Double.longBitsToDouble(vals[index]), value)) != null) {
            vals[index] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public double merge(float key, double value, DoubleBinaryOperator remappingFunction) {
        block2: {
            k = Float.floatToIntBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVFloatKeyMixing.mix((int)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block2;
            if (cur == 0x7FFFFFFE) ** GOTO lbl13
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFE) continue;
lbl13:
                // 2 sources

                this.incrementModCount();
                keys[index] = k;
                vals[index] = Double.doubleToLongBits(value);
                this.postInsertHook();
                return value;
            }
        }
        newValue = remappingFunction.applyAsDouble(Double.longBitsToDouble(vals[index]), value);
        vals[index] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public double addValue(float key, double value) {
        block1: {
            k = Float.floatToIntBits(key);
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVFloatKeyMixing.mix((int)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block1;
            if (cur == 0x7FFFFFFE) ** GOTO lbl11
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFE) continue;
lbl11:
                // 2 sources

                newValue = this.defaultValue() + value;
                this.incrementModCount();
                keys[index] = k;
                vals[index] = Double.doubleToLongBits(newValue);
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = Double.longBitsToDouble(vals[index]) + value;
        vals[index] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public double addValue(float key, double addition, double initialValue) {
        block1: {
            k = Float.floatToIntBits(key);
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVFloatKeyMixing.mix((int)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block1;
            if (cur == 0x7FFFFFFE) ** GOTO lbl11
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFE) continue;
lbl11:
                // 2 sources

                newValue = initialValue + addition;
                this.incrementModCount();
                keys[index] = k;
                vals[index] = Double.doubleToLongBits(newValue);
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = Double.longBitsToDouble(vals[index]) + addition;
        vals[index] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    public void putAll(@Nonnull Map<? extends Float, ? extends Double> m) {
        CommonFloatDoubleMapOps.putAll((InternalFloatDoubleMapOps)this, m);
    }

    public Double replace(Float key, Double value) {
        int k = Float.floatToIntBits(key.floatValue());
        int index = this.index(k);
        if (index >= 0) {
            long[] vals = this.values;
            double oldValue = Double.longBitsToDouble(vals[index]);
            vals[index] = Double.doubleToLongBits(value);
            return oldValue;
        }
        return null;
    }

    public double replace(float key, double value) {
        int k = Float.floatToIntBits(key);
        int index = this.index(k);
        if (index >= 0) {
            long[] vals = this.values;
            double oldValue = Double.longBitsToDouble(vals[index]);
            vals[index] = Double.doubleToLongBits(value);
            return oldValue;
        }
        return this.defaultValue();
    }

    public boolean replace(Float key, Double oldValue, Double newValue) {
        return this.replace(key.floatValue(), (double)oldValue, (double)newValue);
    }

    public boolean replace(float key, double oldValue, double newValue) {
        int k = Float.floatToIntBits(key);
        int index = this.index(k);
        if (index >= 0) {
            long[] vals = this.values;
            if (vals[index] == Double.doubleToLongBits(oldValue)) {
                vals[index] = Double.doubleToLongBits(newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super Float, ? super Double, ? extends Double> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            vals[i] = Double.doubleToLongBits(function.apply(Float.valueOf(Float.intBitsToFloat(key)), (Double)Double.longBitsToDouble(vals[i])));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(FloatDoubleToDoubleFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            vals[i] = Double.doubleToLongBits(function.applyAsDouble(Float.intBitsToFloat(key), Double.longBitsToDouble(vals[i])));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Double remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(float key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(int key) {
        throw new UnsupportedOperationException();
    }

    public double remove(float key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        return this.remove(((Float)key).floatValue(), (Double)value);
    }

    public boolean remove(float key, double value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(FloatDoublePredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements FloatDoubleCursor {
        final int[] keys;
        final long[] vals;
        int expectedModCount;
        int index;
        int curKey;
        long curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(FloatDoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            long[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat(key), Double.longBitsToDouble(vals[i]));
            }
            if (index != this.index || mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public float key() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return Float.intBitsToFloat(curKey);
            }
            throw new IllegalStateException();
        }

        public double value() {
            if (this.curKey != 0x7FFFFFFE) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(double value) {
            if (this.curKey != 0x7FFFFFFE) {
                if (this.expectedModCount != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = Double.doubleToLongBits(value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                int[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements DoubleCursor {
        final int[] keys;
        final long[] vals;
        int expectedModCount;
        int index;
        int curKey;
        long curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            long[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
            if (index != this.index || mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public double elem() {
            if (this.curKey != 0x7FFFFFFE) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                int[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements DoubleIterator {
        final int[] keys;
        final long[] vals;
        int expectedModCount;
        int nextIndex;
        double next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            int[] keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            this.vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            long[] vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] >= 0x7FFFFFFE) continue;
                this.next = Double.longBitsToDouble(vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public double nextDouble() {
            if (this.expectedModCount == UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    int[] keys = this.keys;
                    double prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] >= 0x7FFFFFFE) continue;
                        this.next = Double.longBitsToDouble(this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Double> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            long[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept((Double)Double.longBitsToDouble(vals[i]));
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(DoubleConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            long[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Double next() {
            return this.nextDouble();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Float, Double>> {
        final int[] keys;
        final long[] vals;
        int expectedModCount;
        int index;
        int curKey;
        long curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(Consumer<? super Map.Entry<Float, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            long[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                action.accept((Map.Entry<Float, Double>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (index != this.index || mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public Map.Entry<Float, Double> elem() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                int[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Float, Double>> {
        final int[] keys;
        final long[] vals;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            int[] keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            this.vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            long[] vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                int key = keys[nextI];
                if (key >= 0x7FFFFFFE) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Float, Double>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            long[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                action.accept((Map.Entry<Float, Double>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Float, Double> next() {
            int mc = this.expectedModCount;
            if (mc == UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    int[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        int key = keys[nextI];
                        if (key >= 0x7FFFFFFE) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractDoubleValueView {
        ValueView() {
        }

        public int size() {
            return UpdatableLHashSeparateKVFloatDoubleMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableLHashSeparateKVFloatDoubleMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return UpdatableLHashSeparateKVFloatDoubleMapGO.this.containsValue(o);
        }

        public boolean contains(double v) {
            return UpdatableLHashSeparateKVFloatDoubleMapGO.this.containsValue(v);
        }

        public boolean contains(long bits) {
            return UpdatableLHashSeparateKVFloatDoubleMapGO.this.containsValue(bits);
        }

        public void forEach(Consumer<? super Double> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount();
            int[] keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            long[] vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept((Double)Double.longBitsToDouble(vals[i]));
            }
            if (mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount();
            int[] keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            long[] vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
            if (mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(DoublePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount();
            int[] keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            long[] vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE || predicate.test(Double.longBitsToDouble(vals[i]))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.allContainingIn((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount();
            int[] keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            long[] vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE || c.contains(Double.longBitsToDouble(vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount();
            int[] keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            long[] vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.reverseAddAllTo((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount();
            int[] keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            long[] vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                changed |= c.add(Double.longBitsToDouble(vals[i]));
            }
            if (mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount();
            int[] keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            long[] vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                changed |= c.add(vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(DoubleSet s) {
            if (s instanceof InternalDoubleCollectionOps) {
                return this.reverseRemoveAllFrom((InternalDoubleCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount();
            int[] keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            long[] vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                changed |= s.removeDouble(Double.longBitsToDouble(vals[i]));
            }
            if (mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalDoubleCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount();
            int[] keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            long[] vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                changed |= s.removeDouble(vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public DoubleIterator iterator() {
            int mc = UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public DoubleCursor cursor() {
            int mc = UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount();
            int[] keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            long[] vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                result[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount();
            int[] keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            long[] vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                a[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public double[] toDoubleArray() {
            int size = this.size();
            double[] result = new double[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount();
            int[] keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            long[] vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                result[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public double[] toArray(double[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new double[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount();
            int[] keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            long[] vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                a[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount();
            int[] keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            long[] vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                sb.append(' ').append(Double.longBitsToDouble(vals[i])).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeDouble((Double)o);
        }

        public boolean removeDouble(double v) {
            return UpdatableLHashSeparateKVFloatDoubleMapGO.this.removeValue(v);
        }

        public boolean removeDouble(long bits) {
            return UpdatableLHashSeparateKVFloatDoubleMapGO.this.removeValue(bits);
        }

        public void clear() {
            UpdatableLHashSeparateKVFloatDoubleMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Double> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(DoublePredicate filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends FloatDoubleEntry {
        private int key;
        private long value;

        ReusableEntry() {
        }

        ReusableEntry with(int key, long value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    class MutableEntry
    extends FloatDoubleEntry {
        final int modCount;
        private final int index;
        final int key;
        private long value;

        MutableEntry(int modCount, int index, int key, long value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }

        public Double setValue(Double newValue) {
            long unwrappedNewValue;
            if (this.modCount != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            double oldValue = Double.longBitsToDouble(this.value);
            this.value = unwrappedNewValue = Double.doubleToLongBits(newValue);
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(long newValue) {
            UpdatableLHashSeparateKVFloatDoubleMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class FloatDoubleEntry
    extends AbstractEntry<Float, Double> {
        FloatDoubleEntry() {
        }

        abstract int key();

        public final Float getKey() {
            return Float.valueOf(Float.intBitsToFloat(this.key()));
        }

        abstract long value();

        public final Double getValue() {
            return Double.longBitsToDouble(this.value());
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                int k2 = Float.floatToIntBits(((Float)e2.getKey()).floatValue());
                long v2 = Double.doubleToLongBits((Double)e2.getValue());
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((int)this.key()) ^ Primitives.hashCode((long)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Float, Double>>
    implements HashObjSet<Map.Entry<Float, Double>>,
    InternalObjCollectionOps<Map.Entry<Float, Double>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Float, Double>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableLHashSeparateKVFloatDoubleMapGO.this.hashConfig();
        }

        public int size() {
            return UpdatableLHashSeparateKVFloatDoubleMapGO.this.size;
        }

        public double currentLoad() {
            return UpdatableLHashSeparateKVFloatDoubleMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableLHashSeparateKVFloatDoubleMapGO.this.containsEntry(((Float)e.getKey()).floatValue(), (Double)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount();
            int[] keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            long[] vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount();
            int[] keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            long[] vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Float, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount();
            int[] keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            long[] vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                action.accept((Map.Entry<Float, Double>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Float, Double>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount();
            int[] keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            long[] vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || predicate.test((Map.Entry<Float, Double>)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Float, Double>> iterator() {
            int mc = UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Float, Double>> cursor() {
            int mc = UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount();
            int[] keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            long[] vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount();
            int[] keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            long[] vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            if (mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Float, Double>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount();
            int[] keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            long[] vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return UpdatableLHashSeparateKVFloatDoubleMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount();
            int[] keys = UpdatableLHashSeparateKVFloatDoubleMapGO.this.set;
            long[] vals = UpdatableLHashSeparateKVFloatDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                sb.append(' ');
                sb.append(Float.intBitsToFloat(key));
                sb.append('=');
                sb.append(Double.longBitsToDouble(vals[i]));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableLHashSeparateKVFloatDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableLHashSeparateKVFloatDoubleMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                float key = ((Float)e.getKey()).floatValue();
                double value = (Double)e.getValue();
                return UpdatableLHashSeparateKVFloatDoubleMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Float, Double>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            UpdatableLHashSeparateKVFloatDoubleMapGO.this.doClear();
        }
    }
}

