/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.CharCollection;
import com.koloboke.collect.CharCursor;
import com.koloboke.collect.CharIterator;
import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractCharValueView;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonCharCharMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalCharCharMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.ParallelKVCharCharLHash;
import com.koloboke.collect.impl.hash.UpdatableLHashParallelKVCharCharMapSO;
import com.koloboke.collect.map.CharCharCursor;
import com.koloboke.collect.set.CharSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.CharBinaryOperator;
import com.koloboke.function.CharCharConsumer;
import com.koloboke.function.CharCharPredicate;
import com.koloboke.function.CharCharToCharFunction;
import com.koloboke.function.CharConsumer;
import com.koloboke.function.CharPredicate;
import com.koloboke.function.CharUnaryOperator;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class UpdatableLHashParallelKVCharCharMapGO
extends UpdatableLHashParallelKVCharCharMapSO {
    final void copy(ParallelKVCharCharLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVCharCharLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public char defaultValue() {
        return '\u0000';
    }

    public boolean containsEntry(char key, char value) {
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix((char)key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == key) {
                return (char)(entry >>> 16) == value;
            }
            if (cur == free) {
                return false;
            }
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (char)(entry >>> 16) == value;
            } while (cur != free);
            return false;
        }
        return false;
    }

    public Character get(Object key) {
        char free;
        char k = ((Character)key).charValue();
        if (k != (free = this.freeValue)) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix((char)k) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == k) {
                return Character.valueOf((char)(entry >>> 16));
            }
            if (cur == free) {
                return null;
            }
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return Character.valueOf((char)(entry >>> 16));
            } while (cur != free);
            return null;
        }
        return null;
    }

    public char get(char key) {
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix((char)key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == key) {
                return (char)(entry >>> 16);
            }
            if (cur == free) {
                return this.defaultValue();
            }
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (char)(entry >>> 16);
            } while (cur != free);
            return this.defaultValue();
        }
        return this.defaultValue();
    }

    public Character getOrDefault(Object key, Character defaultValue) {
        char free;
        char k = ((Character)key).charValue();
        if (k != (free = this.freeValue)) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix((char)k) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == k) {
                return Character.valueOf((char)(entry >>> 16));
            }
            if (cur == free) {
                return defaultValue;
            }
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return Character.valueOf((char)(entry >>> 16));
            } while (cur != free);
            return defaultValue;
        }
        return defaultValue;
    }

    public char getOrDefault(char key, char defaultValue) {
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix((char)key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == key) {
                return (char)(entry >>> 16);
            }
            if (cur == free) {
                return defaultValue;
            }
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (char)(entry >>> 16);
            } while (cur != free);
            return defaultValue;
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Character, ? super Character> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            action.accept(Character.valueOf(key), Character.valueOf((char)(entry >>> 16)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(CharCharConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            action.accept(key, (char)(entry >>> 16));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(CharCharPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free || predicate.test(key, (char)(entry >>> 16))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public CharCharCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonCharCharMapOps.containsAllEntries((InternalCharCharMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalCharCharMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free || m.containsEntry(key, (char)(entry >>> 16))) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalCharCharMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            m.justPut(key, (char)(entry >>> 16));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Character, Character>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public CharCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            hashCode += key ^ (char)(entry >>> 16);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append((char)(entry >>> 16));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        int[] newTab = this.table;
        int capacityMask = newTab.length - 1;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            int index = LHash.ParallelKVCharKeyMixing.mix((char)key) & capacityMask;
            if (U.getChar(newTab, INT_BASE + CHAR_KEY_OFFSET + ((long)index << 2)) != free) {
                while (U.getChar(newTab, INT_BASE + CHAR_KEY_OFFSET + ((long)(index = index - 1 & capacityMask) << 2)) != free) {
                }
            }
            newTab[index] = entry;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Character put(Character key, Character value) {
        char free;
        char k = key.charValue();
        if (k == (free = this.freeValue)) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVCharKeyMixing.mix((char)k) & capacityMask;
        int entry = tab[index];
        char cur = (char)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = k | value.charValue() << 16;
            this.postInsertHook();
            return null;
        }
        if (cur != k) {
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
                this.incrementModCount();
                tab[index] = k | value.charValue() << 16;
                this.postInsertHook();
                return null;
            } while (cur != k);
        }
        char prevValue = (char)(entry >>> 16);
        U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), value.charValue());
        return Character.valueOf(prevValue);
    }

    public char put(char key, char value) {
        char free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVCharKeyMixing.mix((char)key) & capacityMask;
        int entry = tab[index];
        char cur = (char)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = key | value << 16;
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur != key) {
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
                this.incrementModCount();
                tab[index] = key | value << 16;
                this.postInsertHook();
                return this.defaultValue();
            } while (cur != key);
        }
        char prevValue = (char)(entry >>> 16);
        U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), value);
        return prevValue;
    }

    public Character putIfAbsent(Character key, Character value) {
        char free;
        char k = key.charValue();
        if (k == (free = this.freeValue)) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVCharKeyMixing.mix((char)k) & capacityMask;
        int entry = tab[index];
        char cur = (char)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = k | value.charValue() << 16;
            this.postInsertHook();
            return null;
        }
        if (cur == k) {
            return Character.valueOf((char)(entry >>> 16));
        }
        do {
            if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
            this.incrementModCount();
            tab[index] = k | value.charValue() << 16;
            this.postInsertHook();
            return null;
        } while (cur != k);
        return Character.valueOf((char)(entry >>> 16));
    }

    public char putIfAbsent(char key, char value) {
        char free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVCharKeyMixing.mix((char)key) & capacityMask;
        int entry = tab[index];
        char cur = (char)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = key | value << 16;
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur == key) {
            return (char)(entry >>> 16);
        }
        do {
            if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
            this.incrementModCount();
            tab[index] = key | value << 16;
            this.postInsertHook();
            return this.defaultValue();
        } while (cur != key);
        return (char)(entry >>> 16);
    }

    public void justPut(char key, char value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        U.putChar(this.table, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), value);
    }

    /*
     * Unable to fully structure code
     */
    public Character compute(Character key, BiFunction<? super Character, ? super Character, ? extends Character> remappingFunction) {
        block5: {
            k = key.charValue();
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVCharKeyMixing.mix((char)k) & capacityMask;
            entry = tab[index];
            cur = (char)entry;
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl16
            while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != free) continue;
lbl16:
                // 2 sources

                if ((newValue = remappingFunction.apply(Character.valueOf(k), null)) != null) {
                    this.incrementModCount();
                    tab[index] = k | newValue.charValue() << 16;
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(Character.valueOf(k), Character.valueOf((char)(entry >>> 16)))) != null) {
            UpdatableLHashParallelKVCharCharMapGO.U.putChar(tab, UpdatableLHashParallelKVCharCharMapGO.INT_BASE + UpdatableLHashParallelKVCharCharMapGO.CHAR_VALUE_OFFSET + ((long)index << 2), newValue.charValue());
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public char compute(char key, CharCharToCharFunction remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVCharKeyMixing.mix((char)key) & capacityMask;
            entry = tab[index];
            cur = (char)entry;
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl15
            while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                newValue = remappingFunction.applyAsChar(key, this.defaultValue());
                this.incrementModCount();
                tab[index] = key | newValue << 16;
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = remappingFunction.applyAsChar(key, (char)(entry >>> 16));
        UpdatableLHashParallelKVCharCharMapGO.U.putChar(tab, UpdatableLHashParallelKVCharCharMapGO.INT_BASE + UpdatableLHashParallelKVCharCharMapGO.CHAR_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    public Character computeIfAbsent(Character key, Function<? super Character, ? extends Character> mappingFunction) {
        Character value;
        char k = key.charValue();
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        char free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVCharKeyMixing.mix((char)k) & capacityMask;
        int entry = tab[index];
        char cur = (char)entry;
        if (cur == k) {
            return Character.valueOf((char)(entry >>> 16));
        }
        if (cur != free) {
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return Character.valueOf((char)(entry >>> 16));
            } while (cur != free);
        }
        if ((value = mappingFunction.apply(Character.valueOf(k))) != null) {
            this.incrementModCount();
            tab[index] = k | value.charValue() << 16;
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public char computeIfAbsent(char key, CharUnaryOperator mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        char free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVCharKeyMixing.mix((char)key) & capacityMask;
        int entry = tab[index];
        char cur = (char)entry;
        if (cur == key) {
            return (char)(entry >>> 16);
        }
        if (cur != free) {
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (char)(entry >>> 16);
            } while (cur != free);
        }
        char value = mappingFunction.applyAsChar(key);
        this.incrementModCount();
        tab[index] = key | value << 16;
        this.postInsertHook();
        return value;
    }

    public Character computeIfPresent(Character key, BiFunction<? super Character, ? super Character, ? extends Character> remappingFunction) {
        char k = key.charValue();
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        char free = this.freeValue;
        if (k != free) {
            Character newValue;
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix((char)k) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != k) {
                    if (cur != free) continue;
                    return null;
                }
            }
            if ((newValue = remappingFunction.apply(Character.valueOf(k), Character.valueOf((char)(entry >>> 16)))) != null) {
                U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), newValue.charValue());
                return newValue;
            }
            throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
        }
        return null;
    }

    public char computeIfPresent(char key, CharCharToCharFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix((char)key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return this.defaultValue();
                }
            }
            char newValue = remappingFunction.applyAsChar(key, (char)(entry >>> 16));
            U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    public Character merge(Character key, Character value, BiFunction<? super Character, ? super Character, ? extends Character> remappingFunction) {
        block5: {
            k = key.charValue();
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVCharKeyMixing.mix((char)k) & capacityMask;
            entry = tab[index];
            cur = (char)entry;
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl18
            while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != free) continue;
lbl18:
                // 2 sources

                this.incrementModCount();
                tab[index] = k | value.charValue() << 16;
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply(Character.valueOf((char)(entry >>> 16)), value)) != null) {
            UpdatableLHashParallelKVCharCharMapGO.U.putChar(tab, UpdatableLHashParallelKVCharCharMapGO.INT_BASE + UpdatableLHashParallelKVCharCharMapGO.CHAR_VALUE_OFFSET + ((long)index << 2), newValue.charValue());
            return newValue;
        }
        throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public char merge(char key, char value, CharBinaryOperator remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVCharKeyMixing.mix((char)key) & capacityMask;
            entry = tab[index];
            cur = (char)entry;
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl15
            while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                this.incrementModCount();
                tab[index] = key | value << 16;
                this.postInsertHook();
                return value;
            }
        }
        newValue = remappingFunction.applyAsChar((char)(entry >>> 16), value);
        UpdatableLHashParallelKVCharCharMapGO.U.putChar(tab, UpdatableLHashParallelKVCharCharMapGO.INT_BASE + UpdatableLHashParallelKVCharCharMapGO.CHAR_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public char addValue(char key, char value) {
        block2: {
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVCharKeyMixing.mix((char)key) & capacityMask;
            entry = tab[index];
            cur = (char)entry;
            if (cur == key) break block2;
            if (cur == free) ** GOTO lbl13
            while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) {
                if (cur != free) continue;
lbl13:
                // 2 sources

                newValue = (char)(this.defaultValue() + value);
                this.incrementModCount();
                tab[index] = key | newValue << 16;
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = (char)((char)(entry >>> 16) + value);
        UpdatableLHashParallelKVCharCharMapGO.U.putChar(tab, UpdatableLHashParallelKVCharCharMapGO.INT_BASE + UpdatableLHashParallelKVCharCharMapGO.CHAR_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public char addValue(char key, char addition, char initialValue) {
        block2: {
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVCharKeyMixing.mix((char)key) & capacityMask;
            entry = tab[index];
            cur = (char)entry;
            if (cur == key) break block2;
            if (cur == free) ** GOTO lbl13
            while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) {
                if (cur != free) continue;
lbl13:
                // 2 sources

                newValue = (char)(initialValue + addition);
                this.incrementModCount();
                tab[index] = key | newValue << 16;
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = (char)((char)(entry >>> 16) + addition);
        UpdatableLHashParallelKVCharCharMapGO.U.putChar(tab, UpdatableLHashParallelKVCharCharMapGO.INT_BASE + UpdatableLHashParallelKVCharCharMapGO.CHAR_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    public void putAll(@Nonnull Map<? extends Character, ? extends Character> m) {
        CommonCharCharMapOps.putAll((InternalCharCharMapOps)this, m);
    }

    public Character replace(Character key, Character value) {
        char free;
        char k = key.charValue();
        if (k != (free = this.freeValue)) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix((char)k) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != k) {
                    if (cur != free) continue;
                    return null;
                }
            }
            char oldValue = (char)(entry >>> 16);
            U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), value.charValue());
            return Character.valueOf(oldValue);
        }
        return null;
    }

    public char replace(char key, char value) {
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix((char)key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return this.defaultValue();
                }
            }
            char oldValue = (char)(entry >>> 16);
            U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), value);
            return oldValue;
        }
        return this.defaultValue();
    }

    public boolean replace(Character key, Character oldValue, Character newValue) {
        return this.replace(key.charValue(), oldValue.charValue(), newValue.charValue());
    }

    public boolean replace(char key, char oldValue, char newValue) {
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix((char)key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            if ((char)(entry >>> 16) == oldValue) {
                U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)index << 2), newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super Character, ? super Character, ? extends Character> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)i << 2), function.apply(Character.valueOf(key), Character.valueOf((char)(entry >>> 16))).charValue());
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(CharCharToCharFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            U.putChar(tab, INT_BASE + CHAR_VALUE_OFFSET + ((long)i << 2), function.applyAsChar(key, (char)(entry >>> 16)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Character remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(char key) {
        throw new UnsupportedOperationException();
    }

    public char remove(char key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        return this.remove(((Character)key).charValue(), ((Character)value).charValue());
    }

    public boolean remove(char key, char value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(CharCharPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements CharCharCursor {
        final int[] tab;
        final char free;
        int expectedModCount;
        int index;
        char curKey;
        char curValue;

        NoRemovedMapCursor(int mc) {
            char free;
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVCharCharMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableLHashParallelKVCharCharMapGO.this.freeValue);
        }

        public void forEachForward(CharCharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(key, (char)(entry >>> 16));
            }
            if (index != this.index || mc != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char key() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public char value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(char value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_VALUE_OFFSET + ((long)this.index << 2), value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                int[] tab = this.tab;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (char)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements CharCursor {
        final int[] tab;
        final char free;
        int expectedModCount;
        int index;
        char curKey;
        char curValue;

        NoRemovedValueCursor(int mc) {
            char free;
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVCharCharMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableLHashParallelKVCharCharMapGO.this.freeValue);
        }

        public void forEachForward(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept((char)(entry >>> 16));
            }
            if (index != this.index || mc != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                int[] tab = this.tab;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (char)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements CharIterator {
        final int[] tab;
        final char free;
        int expectedModCount;
        int nextIndex;
        char next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVCharCharMapGO.this.table;
            int[] tab = UpdatableLHashParallelKVCharCharMapGO.this.table;
            char free = this.free = UpdatableLHashParallelKVCharCharMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                if ((char)entry == free) continue;
                this.next = (char)(entry >>> 16);
                break;
            }
            this.nextIndex = nextI;
        }

        public char nextChar() {
            if (this.expectedModCount == UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    int[] tab = this.tab;
                    char free = this.free;
                    char prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        if ((char)entry == free) continue;
                        this.next = (char)(entry >>> 16);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Character> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept(Character.valueOf((char)(entry >>> 16)));
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(CharConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept((char)(entry >>> 16));
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Character next() {
            return Character.valueOf(this.nextChar());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Character, Character>> {
        final int[] tab;
        final char free;
        int expectedModCount;
        int index;
        char curKey;
        char curValue;

        NoRemovedEntryCursor(int mc) {
            char free;
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVCharCharMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableLHashParallelKVCharCharMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Character, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Character, Character>)((Object)new MutableEntry(mc, i, key, (char)(entry >>> 16))));
            }
            if (index != this.index || mc != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Character, Character> elem() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                int[] tab = this.tab;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (char)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Character, Character>> {
        final int[] tab;
        final char free;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVCharCharMapGO.this.table;
            int[] tab = UpdatableLHashParallelKVCharCharMapGO.this.table;
            char free = this.free = UpdatableLHashParallelKVCharCharMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                char key = (char)entry;
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, (char)(entry >>> 16));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Character, Character>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Character, Character>)((Object)new MutableEntry(mc, i, key, (char)(entry >>> 16))));
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Character, Character> next() {
            int mc = this.expectedModCount;
            if (mc == UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    int[] tab = this.tab;
                    char free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        char key = (char)entry;
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, (char)(entry >>> 16));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractCharValueView {
        ValueView() {
        }

        public int size() {
            return UpdatableLHashParallelKVCharCharMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableLHashParallelKVCharCharMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return UpdatableLHashParallelKVCharCharMapGO.this.containsValue(o);
        }

        public boolean contains(char v) {
            return UpdatableLHashParallelKVCharCharMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Character> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashParallelKVCharCharMapGO.this.modCount();
            char free = UpdatableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept(Character.valueOf((char)(entry >>> 16)));
            }
            if (mc != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashParallelKVCharCharMapGO.this.modCount();
            char free = UpdatableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept((char)(entry >>> 16));
            }
            if (mc != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(CharPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableLHashParallelKVCharCharMapGO.this.modCount();
            char free = UpdatableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free || predicate.test((char)(entry >>> 16))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(CharCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableLHashParallelKVCharCharMapGO.this.modCount();
            char free = UpdatableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free || c.contains((char)(entry >>> 16))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(CharCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashParallelKVCharCharMapGO.this.modCount();
            char free = UpdatableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                changed |= c.add((char)(entry >>> 16));
            }
            if (mc != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(CharSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashParallelKVCharCharMapGO.this.modCount();
            char free = UpdatableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                changed |= s.removeChar((char)(entry >>> 16));
            }
            if (mc != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public CharIterator iterator() {
            int mc = UpdatableLHashParallelKVCharCharMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public CharCursor cursor() {
            int mc = UpdatableLHashParallelKVCharCharMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVCharCharMapGO.this.modCount();
            char free = UpdatableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                result[resultIndex++] = Character.valueOf((char)(entry >>> 16));
            }
            if (mc != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVCharCharMapGO.this.modCount();
            char free = UpdatableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                a[resultIndex++] = Character.valueOf((char)(entry >>> 16));
            }
            if (mc != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public char[] toCharArray() {
            int size = this.size();
            char[] result = new char[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVCharCharMapGO.this.modCount();
            char free = UpdatableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                result[resultIndex++] = (char)(entry >>> 16);
            }
            if (mc != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public char[] toArray(char[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new char[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = '\u0000';
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVCharCharMapGO.this.modCount();
            char free = UpdatableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                a[resultIndex++] = (char)(entry >>> 16);
            }
            if (mc != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = '\u0000';
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableLHashParallelKVCharCharMapGO.this.modCount();
            char free = UpdatableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                sb.append(' ').append((char)(entry >>> 16)).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeChar(((Character)o).charValue());
        }

        public boolean removeChar(char v) {
            return UpdatableLHashParallelKVCharCharMapGO.this.removeValue(v);
        }

        public void clear() {
            UpdatableLHashParallelKVCharCharMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Character> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(CharPredicate filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends CharCharEntry {
        private char key;
        private char value;

        ReusableEntry() {
        }

        ReusableEntry with(char key, char value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }
    }

    class MutableEntry
    extends CharCharEntry {
        final int modCount;
        private final int index;
        final char key;
        private char value;

        MutableEntry(int modCount, int index, char key, char value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }

        public Character setValue(Character newValue) {
            char unwrappedNewValue;
            if (this.modCount != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            char oldValue = this.value;
            this.value = unwrappedNewValue = newValue.charValue();
            this.updateValueInTable(unwrappedNewValue);
            return Character.valueOf(oldValue);
        }

        void updateValueInTable(char newValue) {
            UnsafeConstants.U.putChar(UpdatableLHashParallelKVCharCharMapGO.this.table, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_VALUE_OFFSET + ((long)this.index << 2), newValue);
        }
    }

    abstract class CharCharEntry
    extends AbstractEntry<Character, Character> {
        CharCharEntry() {
        }

        abstract char key();

        public final Character getKey() {
            return Character.valueOf(this.key());
        }

        abstract char value();

        public final Character getValue() {
            return Character.valueOf(this.value());
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                char k2 = ((Character)e2.getKey()).charValue();
                char v2 = ((Character)e2.getValue()).charValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((char)this.key()) ^ Primitives.hashCode((char)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Character, Character>>
    implements HashObjSet<Map.Entry<Character, Character>>,
    InternalObjCollectionOps<Map.Entry<Character, Character>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Character, Character>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableLHashParallelKVCharCharMapGO.this.hashConfig();
        }

        public int size() {
            return UpdatableLHashParallelKVCharCharMapGO.this.size;
        }

        public double currentLoad() {
            return UpdatableLHashParallelKVCharCharMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableLHashParallelKVCharCharMapGO.this.containsEntry(((Character)e.getKey()).charValue(), ((Character)e.getValue()).charValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVCharCharMapGO.this.modCount();
            char free = UpdatableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, (char)(entry >>> 16));
            }
            if (mc != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVCharCharMapGO.this.modCount();
            char free = UpdatableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, (char)(entry >>> 16));
            }
            if (mc != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Character, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashParallelKVCharCharMapGO.this.modCount();
            char free = UpdatableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Character, Character>)((Object)new MutableEntry(mc, i, key, (char)(entry >>> 16))));
            }
            if (mc != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Character, Character>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableLHashParallelKVCharCharMapGO.this.modCount();
            char free = UpdatableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || predicate.test((Map.Entry<Character, Character>)((Object)new MutableEntry(mc, i, key, (char)(entry >>> 16))))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Character, Character>> iterator() {
            int mc = UpdatableLHashParallelKVCharCharMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Character, Character>> cursor() {
            int mc = UpdatableLHashParallelKVCharCharMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableLHashParallelKVCharCharMapGO.this.modCount();
            char free = UpdatableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || c.contains((Object)e.with(key, (char)(entry >>> 16)))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableLHashParallelKVCharCharMapGO.this.modCount();
            char free = UpdatableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, (char)(entry >>> 16)));
            }
            if (mc != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Character, Character>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashParallelKVCharCharMapGO.this.modCount();
            char free = UpdatableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, (char)(entry >>> 16)));
            }
            if (mc != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return UpdatableLHashParallelKVCharCharMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableLHashParallelKVCharCharMapGO.this.modCount();
            char free = UpdatableLHashParallelKVCharCharMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVCharCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append((char)(entry >>> 16));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableLHashParallelKVCharCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableLHashParallelKVCharCharMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                char key = ((Character)e.getKey()).charValue();
                char value = ((Character)e.getValue()).charValue();
                return UpdatableLHashParallelKVCharCharMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Character, Character>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            UpdatableLHashParallelKVCharCharMapGO.this.doClear();
        }
    }
}

