/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.MutableSeparateKVObjLHashSO;
import com.koloboke.collect.impl.hash.ObjHash;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public abstract class MutableSeparateKVObjLHashGO<E>
extends MutableSeparateKVObjLHashSO<E> {
    @Override
    @Nonnull
    public Object[] keys() {
        return this.set;
    }

    public int capacity() {
        return this.set.length;
    }

    public void forEach(Consumer<? super E> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            action.accept(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(Predicate<? super E> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE || predicate.test(key)) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    public boolean allContainingIn(ObjCollection<?> c) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        Object[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE || c.contains(key)) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public boolean reverseAddAllTo(ObjCollection<? super E> c) {
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            changed |= c.add(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean reverseRemoveAllFrom(ObjSet<?> s) {
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            changed |= s.remove(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public ObjIterator<E> iterator() {
        int mc = this.modCount();
        return new NoRemovedIterator(mc);
    }

    public ObjCursor<E> setCursor() {
        int mc = this.modCount();
        return new NoRemovedCursor(mc);
    }

    @Nonnull
    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        Object[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            result[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        int size = this.size();
        if (a.length < size) {
            Class<?> elementType = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(elementType, size);
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        Object[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            a[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = null;
        }
        return a;
    }

    public int setHashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        Object[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            hashCode += this.nullableKeyHashCode(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    public String setToString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        Object[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            sb.append(' ').append(key != this ? key : "(this Collection)").append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '[');
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    abstract boolean justRemove(E var1);

    public boolean removeIf(Predicate<? super E> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                Object key = keys[i];
                if (key == FREE || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    Object keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
                        Object castedKeyToShift = keyToShift;
                        if ((LHash.SeparateKVObjKeyMixing.mix((int)this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = REMOVED;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = castedKeyToShift;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                    }
                    keys[indexToRemove] = FREE;
                    this.postRemoveHook();
                } else {
                    keys[i] = REMOVED;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashObjSet<E> thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                Object key = keys[i];
                if (key == FREE || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    Object keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
                        Object castedKeyToShift = keyToShift;
                        if ((LHash.SeparateKVObjKeyMixing.mix((int)this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = REMOVED;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = castedKeyToShift;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                    }
                    keys[indexToRemove] = FREE;
                    this.postRemoveHook();
                } else {
                    keys[i] = REMOVED;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean retainAll(@Nonnull HashObjSet<E> thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        for (int i = keys.length - 1; i >= 0; --i) {
            block12: {
                Object key = keys[i];
                if (key == FREE || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    Object keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
                        Object castedKeyToShift = keyToShift;
                        if ((LHash.SeparateKVObjKeyMixing.mix((int)this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = REMOVED;
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = castedKeyToShift;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                    }
                    keys[indexToRemove] = FREE;
                    this.postRemoveHook();
                } else {
                    keys[i] = REMOVED;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    void closeDelayedRemoved(int firstDelayedRemoved) {
        Object[] keys = this.set;
        int capacityMask = keys.length - 1;
        for (int i = firstDelayedRemoved; i >= 0; --i) {
            Object keyToShift;
            int indexToRemove;
            if (keys[i] != REMOVED) continue;
            int indexToShift = indexToRemove = i;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
                Object castedKeyToShift = keyToShift;
                if (keyToShift != REMOVED && (LHash.SeparateKVObjKeyMixing.mix((int)this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = castedKeyToShift;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
            }
            keys[indexToRemove] = FREE;
            this.postRemoveHook();
        }
    }

    class NoRemovedCursor
    implements ObjCursor<E> {
        Object[] keys;
        final int capacityMask;
        int expectedModCount;
        int index;
        Object curKey;

        NoRemovedCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableSeparateKVObjLHashGO.this.set;
            Object[] keys = MutableSeparateKVObjLHashGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super E> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(key);
            }
            if (index != this.index || mc != MutableSeparateKVObjLHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public E elem() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableSeparateKVObjLHashGO.this.modCount()) {
                Object[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            Object curKey = this.curKey;
            if (curKey == ObjHash.FREE) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableSeparateKVObjLHashGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = ObjHash.FREE;
            int index = this.index;
            Object[] keys = this.keys;
            if (keys == MutableSeparateKVObjLHashGO.this.set) {
                Object keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableSeparateKVObjLHashGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                    Object castedKeyToShift = keyToShift;
                    if ((LHash.SeparateKVObjKeyMixing.mix((int)MutableSeparateKVObjLHashGO.this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = ObjHash.FREE;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = castedKeyToShift;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                }
                keys[indexToRemove] = ObjHash.FREE;
                MutableSeparateKVObjLHashGO.this.postRemoveHook();
                return;
            } else {
                MutableSeparateKVObjLHashGO.this.justRemove(curKey);
                keys[index] = null;
            }
        }
    }

    class NoRemovedIterator
    implements ObjIterator<E> {
        Object[] keys;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        E next;

        NoRemovedIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableSeparateKVObjLHashGO.this.set;
            Object[] keys = MutableSeparateKVObjLHashGO.this.set;
            this.capacityMask = keys.length - 1;
            int nextI = keys.length;
            while (--nextI >= 0) {
                Object key = keys[nextI];
                if (key == ObjHash.FREE) continue;
                this.next = key;
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(Consumer<? super E> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(key);
            }
            if (nextI != this.nextIndex || mc != MutableSeparateKVObjLHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public E next() {
            if (this.expectedModCount == MutableSeparateKVObjLHashGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    Object[] keys = this.keys;
                    Object prev = this.next;
                    while (--nextI >= 0) {
                        Object key = keys[nextI];
                        if (key == ObjHash.FREE) continue;
                        this.next = key;
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableSeparateKVObjLHashGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            Object[] keys = this.keys;
            if (keys == MutableSeparateKVObjLHashGO.this.set) {
                Object keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableSeparateKVObjLHashGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != ObjHash.FREE) {
                    Object castedKeyToShift = keyToShift;
                    if ((LHash.SeparateKVObjKeyMixing.mix((int)MutableSeparateKVObjLHashGO.this.nullableKeyHashCode(castedKeyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = ObjHash.FREE;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = castedKeyToShift;
                                }
                            }
                        }
                        keys[indexToRemove] = castedKeyToShift;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                }
                keys[indexToRemove] = ObjHash.FREE;
                MutableSeparateKVObjLHashGO.this.postRemoveHook();
                return;
            } else {
                MutableSeparateKVObjLHashGO.this.justRemove(keys[index]);
                keys[index] = null;
            }
        }
    }
}

