/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.impl.InternalShortObjMapOps;
import com.koloboke.collect.impl.hash.MutableQHashSeparateKVShortKeyMap;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.impl.hash.SeparateKVShortObjQHash;
import com.koloboke.collect.map.hash.HashShortObjMap;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class MutableQHashSeparateKVShortObjMapSO<V>
extends MutableQHashSeparateKVShortKeyMap
implements HashShortObjMap<V>,
InternalShortObjMapOps<V>,
SeparateKVShortObjQHash {
    V[] values;

    void copy(SeparateKVShortObjQHash hash) {
        super.copy(hash);
        this.values = (Object[])hash.valueArray().clone();
    }

    void move(SeparateKVShortObjQHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public Object[] valueArray() {
        return this.values;
    }

    boolean nullableValueEquals(@Nullable V a, @Nullable V b) {
        return a == b || a != null && this.valueEquals(a, b);
    }

    boolean valueEquals(@Nonnull V a, @Nullable V b) {
        return a.equals(b);
    }

    int nullableValueHashCode(@Nullable V value) {
        return value != null ? this.valueHashCode(value) : 0;
    }

    int valueHashCode(@Nonnull V value) {
        return value.hashCode();
    }

    int valueIndex(@Nullable Object value) {
        if (value == null) {
            return this.nullValueIndex();
        }
        if (this.isEmpty()) {
            return -1;
        }
        Object val = value;
        int index = -1;
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        short[] keys = this.set;
        V[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || !this.valueEquals(val, vals[i])) continue;
                index = i;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || key == removed || !this.valueEquals(val, vals[i])) continue;
                index = i;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    private int nullValueIndex() {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        short free = this.freeValue;
        short removed = this.removedValue;
        short[] keys = this.set;
        V[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || vals[i] != null) continue;
                index = i;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || key == removed || vals[i] != null) continue;
                index = i;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(Object value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(@Nullable Object value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    int insert(short key, V value) {
        block24: {
            short removed = this.removedValue;
            short free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            short[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVShortKeyMixing.mix((short)key) % capacity;
            short cur = keys[index];
            if (cur != free) {
                int firstRemoved;
                if (cur == key) {
                    return index;
                }
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == free) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == key) {
                                return bIndex;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == free) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == key) {
                                return fIndex;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block24;
                    }
                    if (cur == key) {
                        return bIndex;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block24;
                    }
                    if (cur == key) {
                        return fIndex;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                this.incrementModCount();
                keys[firstRemoved] = key;
                this.values[firstRemoved] = value;
                this.postRemovedSlotInsertHook();
                return -1;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postFreeSlotInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new Object[capacity];
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.values, null);
    }
}

