/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.CharCollection;
import com.koloboke.collect.CharCursor;
import com.koloboke.collect.CharIterator;
import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractCharValueView;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCharMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCharMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.MutableQHashSeparateKVObjCharMapSO;
import com.koloboke.collect.impl.hash.ObjHash;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.impl.hash.SeparateKVObjCharQHash;
import com.koloboke.collect.map.ObjCharCursor;
import com.koloboke.collect.set.CharSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.CharBinaryOperator;
import com.koloboke.function.CharConsumer;
import com.koloboke.function.CharPredicate;
import com.koloboke.function.ObjCharConsumer;
import com.koloboke.function.ObjCharPredicate;
import com.koloboke.function.ObjCharToCharFunction;
import com.koloboke.function.ToCharFunction;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class MutableQHashSeparateKVObjCharMapGO<K>
extends MutableQHashSeparateKVObjCharMapSO<K> {
    @Override
    final void copy(SeparateKVObjCharQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVObjCharQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public char defaultValue() {
        return '\u0000';
    }

    public boolean containsEntry(Object key, char value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public Character get(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return Character.valueOf(this.values[index]);
        }
        return null;
    }

    public char getChar(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    public Character getOrDefault(Object key, Character defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return Character.valueOf(this.values[index]);
        }
        return defaultValue;
    }

    public char getOrDefault(Object key, char defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super K, ? super Character> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        char[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                action.accept(key, Character.valueOf(vals[i]));
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                action.accept(key, Character.valueOf(vals[i]));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void forEach(ObjCharConsumer<? super K> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        char[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                action.accept(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                action.accept(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public boolean forEachWhile(ObjCharPredicate<? super K> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        char[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || predicate.test(key, vals[i])) continue;
                terminated = true;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED || predicate.test(key, vals[i])) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public ObjCharCursor<K> cursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedMapCursor(mc);
        }
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonObjCharMapOps.containsAllEntries((InternalObjCharMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalObjCharMapOps<?> m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        Object[] keys = this.set;
        char[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalObjCharMapOps<? super K> m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        char[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                m.justPut(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                m.justPut(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<K, Character>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public CharCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        Object[] keys = this.set;
        char[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                hashCode += this.nullableKeyHashCode(key) ^ vals[i];
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                hashCode += this.nullableKeyHashCode(key) ^ vals[i];
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        Object[] keys = this.set;
        char[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                sb.append(' ');
                sb.append(key != this ? key : "(this Map)");
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                sb.append(' ');
                sb.append(key != this ? key : "(this Map)");
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        Object[] keys = this.set;
        char[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        Object[] newKeys = this.set;
        int capacity = newKeys.length;
        char[] newVals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                int index = QHash.SeparateKVObjKeyMixing.mix((int)this.nullableKeyHashCode(key)) % capacity;
                if (newKeys[index] != FREE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] == FREE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] == FREE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                int index = QHash.SeparateKVObjKeyMixing.mix((int)this.nullableKeyHashCode(key)) % capacity;
                if (newKeys[index] != FREE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] == FREE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] == FREE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Character put(K key, Character value) {
        int index = this.insert(key, value.charValue());
        if (index < 0) {
            return null;
        }
        char[] vals = this.values;
        char prevValue = vals[index];
        vals[index] = value.charValue();
        return Character.valueOf(prevValue);
    }

    public char put(K key, char value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        char[] vals = this.values;
        char prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    public Character putIfAbsent(K key, Character value) {
        int index = this.insert(key, value.charValue());
        if (index < 0) {
            return null;
        }
        return Character.valueOf(this.values[index]);
    }

    public char putIfAbsent(K key, char value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.values[index];
    }

    public void justPut(K key, char value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    public Character compute(K key, BiFunction<? super K, ? super Character, ? extends Character> remappingFunction) {
        block31: {
            Character newValue;
            int index;
            char[] vals;
            block29: {
                Character newValue2;
                block30: {
                    Character newValue3;
                    int firstRemoved;
                    Object cur;
                    int capacity;
                    Object[] keys;
                    block33: {
                        block32: {
                            if (key == null) break block31;
                            if (remappingFunction == null) {
                                throw new NullPointerException();
                            }
                            keys = this.set;
                            vals = this.values;
                            capacity = keys.length;
                            index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(key)) % capacity;
                            cur = keys[index];
                            if (cur == key) break block29;
                            if (cur == FREE) break block30;
                            if (cur == REMOVED) break block32;
                            if (this.keyEquals(key, cur)) break block29;
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block30;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block30;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                            break block33;
                        }
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            index = bIndex;
                            break block29;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block30;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break block29;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            index = fIndex;
                            break block29;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block30;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break block29;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    if ((newValue3 = remappingFunction.apply(key, null)) != null) {
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = newValue3.charValue();
                        this.postRemovedSlotInsertHook();
                        return newValue3;
                    }
                    return null;
                }
                if ((newValue2 = remappingFunction.apply(key, null)) != null) {
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = newValue2.charValue();
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
            if ((newValue = remappingFunction.apply(key, Character.valueOf(vals[index]))) != null) {
                vals[index] = newValue.charValue();
                return newValue;
            }
            this.incrementModCount();
            keys[index] = REMOVED;
            this.postRemoveHook();
            return null;
        }
        return this.computeNullKey(remappingFunction);
    }

    Character computeNullKey(BiFunction<? super K, ? super Character, ? extends Character> remappingFunction) {
        Character newValue;
        int index;
        char[] vals;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                Character newValue2;
                block26: {
                    if (cur != FREE) {
                        Character newValue3;
                        int firstRemoved;
                        if (cur != REMOVED) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == null) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == null) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((newValue3 = remappingFunction.apply(null, null)) != null) {
                            this.incrementModCount();
                            keys[firstRemoved] = null;
                            vals[firstRemoved] = newValue3.charValue();
                            this.postRemovedSlotInsertHook();
                            return newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = remappingFunction.apply(null, null)) != null) {
                    this.incrementModCount();
                    keys[index] = null;
                    vals[index] = newValue2.charValue();
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(null, Character.valueOf(vals[index]))) != null) {
            vals[index] = newValue.charValue();
            return newValue;
        }
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return null;
    }

    public char compute(K key, ObjCharToCharFunction<? super K> remappingFunction) {
        block28: {
            char newValue;
            int index;
            char[] vals;
            block26: {
                block27: {
                    int firstRemoved;
                    Object cur;
                    int capacity;
                    Object[] keys;
                    block30: {
                        block29: {
                            if (key == null) break block28;
                            if (remappingFunction == null) {
                                throw new NullPointerException();
                            }
                            keys = this.set;
                            vals = this.values;
                            capacity = keys.length;
                            index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(key)) % capacity;
                            cur = keys[index];
                            if (cur == key) break block26;
                            if (cur == FREE) break block27;
                            if (cur == REMOVED) break block29;
                            if (this.keyEquals(key, cur)) break block26;
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block27;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block27;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                            break block30;
                        }
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            index = bIndex;
                            break block26;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block27;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break block26;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            index = fIndex;
                            break block26;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block27;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break block26;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    char newValue2 = remappingFunction.applyAsChar(key, this.defaultValue());
                    this.incrementModCount();
                    keys[firstRemoved] = key;
                    vals[firstRemoved] = newValue2;
                    this.postRemovedSlotInsertHook();
                    return newValue2;
                }
                newValue = remappingFunction.applyAsChar(key, this.defaultValue());
                this.incrementModCount();
                keys[index] = key;
                vals[index] = newValue;
                this.postFreeSlotInsertHook();
                return newValue;
            }
            vals[index] = newValue = remappingFunction.applyAsChar(key, vals[index]);
            return newValue;
        }
        return this.computeNullKey(remappingFunction);
    }

    char computeNullKey(ObjCharToCharFunction<? super K> remappingFunction) {
        char newValue;
        int index;
        char[] vals;
        block22: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                block23: {
                    if (cur != FREE) {
                        int firstRemoved;
                        if (cur != REMOVED) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == null) {
                                        index = bIndex;
                                        break block22;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block23;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == null) {
                                        index = fIndex;
                                        break block22;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block23;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                index = bIndex;
                                break block22;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block23;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                index = fIndex;
                                break block22;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block23;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        char newValue2 = remappingFunction.applyAsChar(null, this.defaultValue());
                        this.incrementModCount();
                        keys[firstRemoved] = null;
                        vals[firstRemoved] = newValue2;
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = remappingFunction.applyAsChar(null, this.defaultValue());
                this.incrementModCount();
                keys[index] = null;
                vals[index] = newValue;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsChar(null, vals[index]);
        return newValue;
    }

    public Character computeIfAbsent(K key, Function<? super K, ? extends Character> mappingFunction) {
        if (key != null) {
            Character value;
            block34: {
                if (mappingFunction == null) {
                    throw new NullPointerException();
                }
                Object[] keys = this.set;
                char[] vals = this.values;
                int capacity = keys.length;
                int index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(key)) % capacity;
                Object cur = keys[index];
                if (cur == key) {
                    return Character.valueOf(vals[index]);
                }
                if (cur != FREE) {
                    Character value2;
                    int firstRemoved;
                    if (cur != REMOVED) {
                        if (this.keyEquals(key, cur)) {
                            return Character.valueOf(vals[index]);
                        }
                        if (this.noRemoved()) {
                            int bIndex = index;
                            int fIndex = index;
                            int step = 1;
                            while (true) {
                                if ((bIndex -= step) < 0) {
                                    bIndex += capacity;
                                }
                                if ((cur = keys[bIndex]) == key) {
                                    return Character.valueOf(vals[bIndex]);
                                }
                                if (cur == FREE) {
                                    index = bIndex;
                                    break block34;
                                }
                                if (this.keyEquals(key, cur)) {
                                    return Character.valueOf(vals[bIndex]);
                                }
                                int t = (fIndex += step) - capacity;
                                if (t >= 0) {
                                    fIndex = t;
                                }
                                if ((cur = keys[fIndex]) == key) {
                                    return Character.valueOf(vals[fIndex]);
                                }
                                if (cur == FREE) {
                                    index = fIndex;
                                    break block34;
                                }
                                if (this.keyEquals(key, cur)) {
                                    return Character.valueOf(vals[fIndex]);
                                }
                                step += 2;
                            }
                        }
                        firstRemoved = -1;
                    } else {
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            return Character.valueOf(vals[bIndex]);
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block34;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                return Character.valueOf(vals[bIndex]);
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            return Character.valueOf(vals[fIndex]);
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block34;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                return Character.valueOf(vals[fIndex]);
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    if ((value2 = mappingFunction.apply(key)) != null) {
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = value2.charValue();
                        this.postRemovedSlotInsertHook();
                        return value2;
                    }
                    return null;
                }
            }
            if ((value = mappingFunction.apply(key)) != null) {
                this.incrementModCount();
                keys[index] = key;
                vals[index] = value.charValue();
                this.postFreeSlotInsertHook();
                return value;
            }
            return null;
        }
        return this.computeIfAbsentNullKey(mappingFunction);
    }

    Character computeIfAbsentNullKey(Function<? super K, ? extends Character> mappingFunction) {
        Character value;
        block24: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            char[] vals = this.values;
            int capacity = keys.length;
            int index = 0;
            Object cur = keys[0];
            if (cur == null) {
                return Character.valueOf(vals[index]);
            }
            if (cur != FREE) {
                Character value2;
                int firstRemoved;
                if (cur != REMOVED) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                return Character.valueOf(vals[bIndex]);
                            }
                            if (cur == FREE) {
                                index = bIndex;
                                break block24;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                return Character.valueOf(vals[fIndex]);
                            }
                            if (cur == FREE) {
                                index = fIndex;
                                break block24;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == null) {
                        return Character.valueOf(vals[bIndex]);
                    }
                    if (cur == FREE) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block24;
                    }
                    if (cur == REMOVED && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == null) {
                        return Character.valueOf(vals[fIndex]);
                    }
                    if (cur == FREE) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block24;
                    }
                    if (cur == REMOVED && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                if ((value2 = mappingFunction.apply(null)) != null) {
                    this.incrementModCount();
                    keys[firstRemoved] = null;
                    vals[firstRemoved] = value2.charValue();
                    this.postRemovedSlotInsertHook();
                    return value2;
                }
                return null;
            }
        }
        if ((value = mappingFunction.apply(null)) != null) {
            this.incrementModCount();
            keys[index] = null;
            vals[index] = value.charValue();
            this.postFreeSlotInsertHook();
            return value;
        }
        return null;
    }

    public char computeIfAbsent(K key, ToCharFunction<? super K> mappingFunction) {
        if (key != null) {
            block32: {
                if (mappingFunction == null) {
                    throw new NullPointerException();
                }
                Object[] keys = this.set;
                char[] vals = this.values;
                int capacity = keys.length;
                int index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(key)) % capacity;
                Object cur = keys[index];
                if (cur == key) {
                    return vals[index];
                }
                if (cur != FREE) {
                    int firstRemoved;
                    if (cur != REMOVED) {
                        if (this.keyEquals(key, cur)) {
                            return vals[index];
                        }
                        if (this.noRemoved()) {
                            int bIndex = index;
                            int fIndex = index;
                            int step = 1;
                            while (true) {
                                if ((bIndex -= step) < 0) {
                                    bIndex += capacity;
                                }
                                if ((cur = keys[bIndex]) == key) {
                                    return vals[bIndex];
                                }
                                if (cur == FREE) {
                                    index = bIndex;
                                    break block32;
                                }
                                if (this.keyEquals(key, cur)) {
                                    return vals[bIndex];
                                }
                                int t = (fIndex += step) - capacity;
                                if (t >= 0) {
                                    fIndex = t;
                                }
                                if ((cur = keys[fIndex]) == key) {
                                    return vals[fIndex];
                                }
                                if (cur == FREE) {
                                    index = fIndex;
                                    break block32;
                                }
                                if (this.keyEquals(key, cur)) {
                                    return vals[fIndex];
                                }
                                step += 2;
                            }
                        }
                        firstRemoved = -1;
                    } else {
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            return vals[bIndex];
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block32;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                return vals[bIndex];
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            return vals[fIndex];
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block32;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                return vals[fIndex];
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    char value = mappingFunction.applyAsChar(key);
                    this.incrementModCount();
                    keys[firstRemoved] = key;
                    vals[firstRemoved] = value;
                    this.postRemovedSlotInsertHook();
                    return value;
                }
            }
            char value = mappingFunction.applyAsChar(key);
            this.incrementModCount();
            keys[index] = key;
            vals[index] = value;
            this.postFreeSlotInsertHook();
            return value;
        }
        return this.computeIfAbsentNullKey(mappingFunction);
    }

    char computeIfAbsentNullKey(ToCharFunction<? super K> mappingFunction) {
        block22: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            char[] vals = this.values;
            int capacity = keys.length;
            int index = 0;
            Object cur = keys[0];
            if (cur == null) {
                return vals[index];
            }
            if (cur != FREE) {
                int firstRemoved;
                if (cur != REMOVED) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                return vals[bIndex];
                            }
                            if (cur == FREE) {
                                index = bIndex;
                                break block22;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                return vals[fIndex];
                            }
                            if (cur == FREE) {
                                index = fIndex;
                                break block22;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == null) {
                        return vals[bIndex];
                    }
                    if (cur == FREE) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block22;
                    }
                    if (cur == REMOVED && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == null) {
                        return vals[fIndex];
                    }
                    if (cur == FREE) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block22;
                    }
                    if (cur == REMOVED && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                char value = mappingFunction.applyAsChar(null);
                this.incrementModCount();
                keys[firstRemoved] = null;
                vals[firstRemoved] = value;
                this.postRemovedSlotInsertHook();
                return value;
            }
        }
        char value = mappingFunction.applyAsChar(null);
        this.incrementModCount();
        keys[index] = null;
        vals[index] = value;
        this.postFreeSlotInsertHook();
        return value;
    }

    public Character computeIfPresent(K key, BiFunction<? super K, ? super Character, ? extends Character> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            char[] vals = this.values;
            Character newValue = remappingFunction.apply(key, Character.valueOf(vals[index]));
            if (newValue != null) {
                vals[index] = newValue.charValue();
                return newValue;
            }
            this.incrementModCount();
            this.set[index] = REMOVED;
            this.postRemoveHook();
            return null;
        }
        return null;
    }

    public char computeIfPresent(K key, ObjCharToCharFunction<? super K> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            char newValue;
            char[] vals = this.values;
            vals[index] = newValue = remappingFunction.applyAsChar(key, vals[index]);
            return newValue;
        }
        return this.defaultValue();
    }

    public Character merge(K key, Character value, BiFunction<? super Character, ? super Character, ? extends Character> remappingFunction) {
        block30: {
            Character newValue;
            int index;
            char[] vals;
            block28: {
                block29: {
                    int firstRemoved;
                    Object cur;
                    int capacity;
                    Object[] keys;
                    block32: {
                        block31: {
                            if (key == null) break block30;
                            if (value == null) {
                                throw new NullPointerException();
                            }
                            if (remappingFunction == null) {
                                throw new NullPointerException();
                            }
                            keys = this.set;
                            vals = this.values;
                            capacity = keys.length;
                            index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(key)) % capacity;
                            cur = keys[index];
                            if (cur == key) break block28;
                            if (cur == FREE) break block29;
                            if (cur == REMOVED) break block31;
                            if (this.keyEquals(key, cur)) break block28;
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                            break block32;
                        }
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            index = bIndex;
                            break block28;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block29;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break block28;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            index = fIndex;
                            break block28;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block29;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break block28;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    this.incrementModCount();
                    keys[firstRemoved] = key;
                    vals[firstRemoved] = value.charValue();
                    this.postRemovedSlotInsertHook();
                    return value;
                }
                this.incrementModCount();
                keys[index] = key;
                vals[index] = value.charValue();
                this.postFreeSlotInsertHook();
                return value;
            }
            if ((newValue = remappingFunction.apply(Character.valueOf(vals[index]), value)) != null) {
                vals[index] = newValue.charValue();
                return newValue;
            }
            this.incrementModCount();
            keys[index] = REMOVED;
            this.postRemoveHook();
            return null;
        }
        return this.mergeNullKey(value, remappingFunction);
    }

    Character mergeNullKey(Character value, BiFunction<? super Character, ? super Character, ? extends Character> remappingFunction) {
        Character newValue;
        int index;
        char[] vals;
        block24: {
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                block25: {
                    if (cur != FREE) {
                        int firstRemoved;
                        if (cur != REMOVED) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == null) {
                                        index = bIndex;
                                        break block24;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == null) {
                                        index = fIndex;
                                        break block24;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block25;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block25;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = null;
                        vals[firstRemoved] = value.charValue();
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = null;
                vals[index] = value.charValue();
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply(Character.valueOf(vals[index]), value)) != null) {
            vals[index] = newValue.charValue();
            return newValue;
        }
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return null;
    }

    public char merge(K key, char value, CharBinaryOperator remappingFunction) {
        block28: {
            char newValue;
            int index;
            char[] vals;
            block26: {
                block27: {
                    int firstRemoved;
                    Object cur;
                    int capacity;
                    Object[] keys;
                    block30: {
                        block29: {
                            if (key == null) break block28;
                            if (remappingFunction == null) {
                                throw new NullPointerException();
                            }
                            keys = this.set;
                            vals = this.values;
                            capacity = keys.length;
                            index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(key)) % capacity;
                            cur = keys[index];
                            if (cur == key) break block26;
                            if (cur == FREE) break block27;
                            if (cur == REMOVED) break block29;
                            if (this.keyEquals(key, cur)) break block26;
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block27;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block27;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                            break block30;
                        }
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            index = bIndex;
                            break block26;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block27;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break block26;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            index = fIndex;
                            break block26;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block27;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break block26;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    this.incrementModCount();
                    keys[firstRemoved] = key;
                    vals[firstRemoved] = value;
                    this.postRemovedSlotInsertHook();
                    return value;
                }
                this.incrementModCount();
                keys[index] = key;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
            vals[index] = newValue = remappingFunction.applyAsChar(vals[index], value);
            return newValue;
        }
        return this.mergeNullKey(value, remappingFunction);
    }

    char mergeNullKey(char value, CharBinaryOperator remappingFunction) {
        char newValue;
        int index;
        char[] vals;
        block22: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                block23: {
                    if (cur != FREE) {
                        int firstRemoved;
                        if (cur != REMOVED) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == null) {
                                        index = bIndex;
                                        break block22;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block23;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == null) {
                                        index = fIndex;
                                        break block22;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block23;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                index = bIndex;
                                break block22;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block23;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                index = fIndex;
                                break block22;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block23;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = null;
                        vals[firstRemoved] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = null;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsChar(vals[index], value);
        return newValue;
    }

    public char addValue(K key, char value) {
        block27: {
            char newValue;
            int index;
            char[] vals;
            block25: {
                block26: {
                    int firstRemoved;
                    Object cur;
                    int capacity;
                    Object[] keys;
                    block29: {
                        block28: {
                            if (key == null) break block27;
                            keys = this.set;
                            vals = this.values;
                            capacity = keys.length;
                            index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(key)) % capacity;
                            cur = keys[index];
                            if (cur == key) break block25;
                            if (cur == FREE) break block26;
                            if (cur == REMOVED) break block28;
                            if (this.keyEquals(key, cur)) break block25;
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                            break block29;
                        }
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            index = bIndex;
                            break block25;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block26;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break block25;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            index = fIndex;
                            break block25;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block26;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break block25;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    char newValue2 = (char)(this.defaultValue() + value);
                    this.incrementModCount();
                    keys[firstRemoved] = key;
                    vals[firstRemoved] = newValue2;
                    this.postRemovedSlotInsertHook();
                    return newValue2;
                }
                newValue = (char)(this.defaultValue() + value);
                this.incrementModCount();
                keys[index] = key;
                vals[index] = newValue;
                this.postFreeSlotInsertHook();
                return newValue;
            }
            vals[index] = newValue = (char)(vals[index] + value);
            return newValue;
        }
        return this.addValueNullKey(value);
    }

    char addValueNullKey(char value) {
        char newValue;
        int index;
        char[] vals;
        block21: {
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                block22: {
                    if (cur != FREE) {
                        int firstRemoved;
                        if (cur != REMOVED) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == null) {
                                        index = bIndex;
                                        break block21;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block22;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == null) {
                                        index = fIndex;
                                        break block21;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block22;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                index = bIndex;
                                break block21;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block22;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                index = fIndex;
                                break block21;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block22;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        char newValue2 = (char)(this.defaultValue() + value);
                        this.incrementModCount();
                        keys[firstRemoved] = null;
                        vals[firstRemoved] = newValue2;
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = (char)(this.defaultValue() + value);
                this.incrementModCount();
                keys[index] = null;
                vals[index] = newValue;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = (char)(vals[index] + value);
        return newValue;
    }

    public char addValue(K key, char addition, char initialValue) {
        block27: {
            char newValue;
            int index;
            char[] vals;
            block25: {
                block26: {
                    int firstRemoved;
                    Object cur;
                    int capacity;
                    Object[] keys;
                    block29: {
                        block28: {
                            if (key == null) break block27;
                            keys = this.set;
                            vals = this.values;
                            capacity = keys.length;
                            index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(key)) % capacity;
                            cur = keys[index];
                            if (cur == key) break block25;
                            if (cur == FREE) break block26;
                            if (cur == REMOVED) break block28;
                            if (this.keyEquals(key, cur)) break block25;
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                            break block29;
                        }
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            index = bIndex;
                            break block25;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block26;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break block25;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            index = fIndex;
                            break block25;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block26;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break block25;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    char newValue2 = (char)(initialValue + addition);
                    this.incrementModCount();
                    keys[firstRemoved] = key;
                    vals[firstRemoved] = newValue2;
                    this.postRemovedSlotInsertHook();
                    return newValue2;
                }
                newValue = (char)(initialValue + addition);
                this.incrementModCount();
                keys[index] = key;
                vals[index] = newValue;
                this.postFreeSlotInsertHook();
                return newValue;
            }
            vals[index] = newValue = (char)(vals[index] + addition);
            return newValue;
        }
        return this.addValueWithInitialNullKey(addition, initialValue);
    }

    char addValueWithInitialNullKey(char addition, char initialValue) {
        char newValue;
        int index;
        char[] vals;
        block21: {
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                block22: {
                    if (cur != FREE) {
                        int firstRemoved;
                        if (cur != REMOVED) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == null) {
                                        index = bIndex;
                                        break block21;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block22;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == null) {
                                        index = fIndex;
                                        break block21;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block22;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                index = bIndex;
                                break block21;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block22;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                index = fIndex;
                                break block21;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block22;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        char newValue2 = (char)(initialValue + addition);
                        this.incrementModCount();
                        keys[firstRemoved] = null;
                        vals[firstRemoved] = newValue2;
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = (char)(initialValue + addition);
                this.incrementModCount();
                keys[index] = null;
                vals[index] = newValue;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = (char)(vals[index] + addition);
        return newValue;
    }

    public void putAll(@Nonnull Map<? extends K, ? extends Character> m) {
        CommonObjCharMapOps.putAll((InternalObjCharMapOps)this, m);
    }

    public Character replace(K key, Character value) {
        int index = this.index(key);
        if (index >= 0) {
            char[] vals = this.values;
            char oldValue = vals[index];
            vals[index] = value.charValue();
            return Character.valueOf(oldValue);
        }
        return null;
    }

    public char replace(K key, char value) {
        int index = this.index(key);
        if (index >= 0) {
            char[] vals = this.values;
            char oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    public boolean replace(K key, Character oldValue, Character newValue) {
        return this.replace(key, oldValue.charValue(), newValue.charValue());
    }

    public boolean replace(K key, char oldValue, char newValue) {
        int index = this.index(key);
        if (index >= 0) {
            char[] vals = this.values;
            if (vals[index] == oldValue) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super K, ? super Character, ? extends Character> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        char[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                vals[i] = function.apply(key, Character.valueOf(vals[i])).charValue();
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                vals[i] = function.apply(key, Character.valueOf(vals[i])).charValue();
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(ObjCharToCharFunction<? super K> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        char[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                vals[i] = function.applyAsChar(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                vals[i] = function.applyAsChar(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        this.incrementModCount();
        super.removeAt(index);
        this.postRemoveHook();
    }

    /*
     * Enabled aggressive block sorting
     */
    public Character remove(Object key) {
        if (key == null) {
            return this.removeNullKey();
        }
        Object k = key;
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(k)) % capacity;
        Object cur = keys[index];
        if (cur != k) {
            int bIndex;
            if (cur == FREE) {
                return null;
            }
            if (cur != REMOVED) {
                if (!this.keyEquals(k, cur)) {
                    if (!this.noRemoved()) {
                    } else {
                        bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return null;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = bIndex;
                                break;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return null;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                }
            } else {
                bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return null;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return null;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
        }
        char val = this.values[index];
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return Character.valueOf(val);
    }

    Character removeNullKey() {
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur != null) {
            if (cur == FREE) {
                return null;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == null) {
                    index = bIndex;
                    break;
                }
                if (cur == FREE) {
                    return null;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == null) {
                    index = fIndex;
                    break;
                }
                if (cur == FREE) {
                    return null;
                }
                step += 2;
            }
        }
        char val = this.values[index];
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return Character.valueOf(val);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean justRemove(Object key) {
        if (key == null) {
            return this.justRemoveNullKey();
        }
        Object k = key;
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(k)) % capacity;
        Object cur = keys[index];
        if (cur != k) {
            if (cur == FREE) {
                return false;
            }
            if (cur != REMOVED) {
                if (!this.keyEquals(k, cur)) {
                    if (!this.noRemoved()) {
                    } else {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return false;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = bIndex;
                                break;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return false;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                }
            } else {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return false;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return false;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
        }
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return true;
    }

    boolean justRemoveNullKey() {
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur != null) {
            if (cur == FREE) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == null) {
                    index = bIndex;
                    break;
                }
                if (cur == FREE) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == null) {
                    index = fIndex;
                    break;
                }
                if (cur == FREE) {
                    return false;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public char removeAsChar(Object key) {
        if (key == null) {
            return this.removeAsCharNullKey();
        }
        Object k = key;
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(k)) % capacity;
        Object cur = keys[index];
        if (cur != k) {
            int bIndex;
            if (cur == FREE) {
                return this.defaultValue();
            }
            if (cur != REMOVED) {
                if (!this.keyEquals(k, cur)) {
                    if (!this.noRemoved()) {
                    } else {
                        bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return this.defaultValue();
                            }
                            if (this.keyEquals(k, cur)) {
                                index = bIndex;
                                break;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return this.defaultValue();
                            }
                            if (this.keyEquals(k, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                }
            } else {
                bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return this.defaultValue();
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return this.defaultValue();
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
        }
        char val = this.values[index];
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return val;
    }

    char removeAsCharNullKey() {
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur != null) {
            if (cur == FREE) {
                return this.defaultValue();
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == null) {
                    index = bIndex;
                    break;
                }
                if (cur == FREE) {
                    return this.defaultValue();
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == null) {
                    index = fIndex;
                    break;
                }
                if (cur == FREE) {
                    return this.defaultValue();
                }
                step += 2;
            }
        }
        char val = this.values[index];
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return val;
    }

    public boolean remove(Object key, Object value) {
        return this.remove(key, ((Character)value).charValue());
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean remove(Object key, char value) {
        if (key == null) {
            return this.removeEntryNullKey(value);
        }
        Object k = key;
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(k)) % capacity;
        Object cur = keys[index];
        if (cur != k) {
            if (cur == FREE) {
                return false;
            }
            if (cur != REMOVED) {
                if (!this.keyEquals(k, cur)) {
                    if (!this.noRemoved()) {
                    } else {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return false;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = bIndex;
                                break;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return false;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                }
            } else {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return false;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return false;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
        }
        if (this.values[index] == value) {
            this.incrementModCount();
            keys[index] = REMOVED;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    boolean removeEntryNullKey(char value) {
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur != null) {
            if (cur == FREE) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == null) {
                    index = bIndex;
                    break;
                }
                if (cur == FREE) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == null) {
                    index = fIndex;
                    break;
                }
                if (cur == FREE) {
                    return false;
                }
                step += 2;
            }
        }
        if (this.values[index] == value) {
            this.incrementModCount();
            keys[index] = REMOVED;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeIf(ObjCharPredicate<? super K> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        char[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || !filter.test(key, vals[i])) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = REMOVED;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED || !filter.test(key, vals[i])) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = REMOVED;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedMapCursor
    implements ObjCharCursor<K> {
        final Object[] keys;
        final char[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        char curValue;

        SomeRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(ObjCharConsumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            char[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public K key() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public char value() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(char value) {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                Object[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
            this.keys[this.index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedMapCursor
    implements ObjCharCursor<K> {
        final Object[] keys;
        final char[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        char curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(ObjCharConsumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            char[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public K key() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public char value() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(char value) {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                Object[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
            this.keys[this.index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueCursor
    implements CharCursor {
        final Object[] keys;
        final char[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        char curValue;

        SomeRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            char[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public char elem() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                Object[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
            this.keys[this.index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueIterator
    implements CharIterator {
        final Object[] keys;
        final char[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        char next;

        SomeRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            this.vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                Object key = keys[nextI];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public char nextChar() {
            if (this.expectedModCount == MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    Object[] keys = this.keys;
                    char prev = this.next;
                    while (--nextI >= 0) {
                        Object key = keys[nextI];
                        if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Character> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            char[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept(Character.valueOf(vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(CharConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            char[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Character next() {
            return Character.valueOf(this.nextChar());
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
            this.keys[index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueCursor
    implements CharCursor {
        final Object[] keys;
        final char[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        char curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            char[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public char elem() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                Object[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
            this.keys[this.index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueIterator
    implements CharIterator {
        final Object[] keys;
        final char[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        char next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            this.vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == ObjHash.FREE) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public char nextChar() {
            if (this.expectedModCount == MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    Object[] keys = this.keys;
                    char prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == ObjHash.FREE) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Character> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            char[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(Character.valueOf(vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(CharConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            char[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Character next() {
            return Character.valueOf(this.nextChar());
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
            this.keys[index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryCursor
    implements ObjCursor<Map.Entry<K, Character>> {
        final Object[] keys;
        final char[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        char curValue;

        SomeRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super Map.Entry<K, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            char[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (index != this.index || mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public Map.Entry<K, Character> elem() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                Object[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
            this.keys[this.index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryIterator
    implements ObjIterator<Map.Entry<K, Character>> {
        final Object[] keys;
        final char[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        SomeRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            this.vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                Object key = keys[nextI];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<K, Character>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            char[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<K, Character> next() {
            int mc = this.expectedModCount;
            if (mc == MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    Object[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        Object key = keys[nextI];
                        if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
            this.keys[index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<K, Character>> {
        final Object[] keys;
        final char[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        char curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super Map.Entry<K, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            char[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (index != this.index || mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public Map.Entry<K, Character> elem() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                Object[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
            this.keys[this.index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<K, Character>> {
        final Object[] keys;
        final char[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            this.vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                Object key = keys[nextI];
                if (key == ObjHash.FREE) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<K, Character>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            Object[] keys = this.keys;
            char[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<K, Character> next() {
            int mc = this.expectedModCount;
            if (mc == MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    Object[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        Object key = keys[nextI];
                        if (key == ObjHash.FREE) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
            this.keys[index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
        }
    }

    class ValueView
    extends AbstractCharValueView {
        ValueView() {
        }

        public int size() {
            return MutableQHashSeparateKVObjCharMapGO.this.size();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVObjCharMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return MutableQHashSeparateKVObjCharMapGO.this.containsValue(o);
        }

        public boolean contains(char v) {
            return MutableQHashSeparateKVObjCharMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Character> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    action.accept(Character.valueOf(vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    action.accept(Character.valueOf(vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    action.accept(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    action.accept(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(CharPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || predicate.test(vals[i])) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || predicate.test(vals[i])) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(CharCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(CharCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    changed |= c.add(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    changed |= c.add(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(CharSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    changed |= s.removeChar(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    changed |= s.removeChar(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public CharIterator iterator() {
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            if (!MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                return new SomeRemovedValueIterator(mc);
            }
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public CharCursor cursor() {
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            if (!MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                return new SomeRemovedValueCursor(mc);
            }
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    result[resultIndex++] = Character.valueOf(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    result[resultIndex++] = Character.valueOf(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    a[resultIndex++] = Character.valueOf(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    a[resultIndex++] = Character.valueOf(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public char[] toCharArray() {
            int size = this.size();
            char[] result = new char[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    result[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    result[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public char[] toArray(char[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new char[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = '\u0000';
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    a[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    a[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = '\u0000';
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    sb.append(' ').append(vals[i]).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    sb.append(' ').append(vals[i]).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeChar(((Character)o).charValue());
        }

        public boolean removeChar(char v) {
            return MutableQHashSeparateKVObjCharMapGO.this.removeValue(v);
        }

        public void clear() {
            MutableQHashSeparateKVObjCharMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Character> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || !filter.test(Character.valueOf(vals[i]))) continue;
                    MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !filter.test(Character.valueOf(vals[i]))) continue;
                    MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(CharPredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || !filter.test(vals[i])) continue;
                    MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !filter.test(vals[i])) continue;
                    MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof CharCollection) {
                return this.removeAll((CharCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || !c.contains(Character.valueOf(vals[i]))) continue;
                    MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !c.contains(Character.valueOf(vals[i]))) continue;
                    MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(CharCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof CharCollection) {
                return this.retainAll((CharCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || c.contains(Character.valueOf(vals[i]))) continue;
                    MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || c.contains(Character.valueOf(vals[i]))) continue;
                    MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(CharCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends ObjCharEntry {
        private K key;
        private char value;

        ReusableEntry() {
        }

        ReusableEntry with(K key, char value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }
    }

    class MutableEntry
    extends ObjCharEntry {
        final int modCount;
        private final int index;
        final K key;
        private char value;

        MutableEntry(int modCount, int index, K key, char value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }

        public Character setValue(Character newValue) {
            char unwrappedNewValue;
            if (this.modCount != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            char oldValue = this.value;
            this.value = unwrappedNewValue = newValue.charValue();
            this.updateValueInTable(unwrappedNewValue);
            return Character.valueOf(oldValue);
        }

        void updateValueInTable(char newValue) {
            MutableQHashSeparateKVObjCharMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class ObjCharEntry
    extends AbstractEntry<K, Character> {
        ObjCharEntry() {
        }

        abstract K key();

        public final K getKey() {
            return this.key();
        }

        abstract char value();

        public final Character getValue() {
            return Character.valueOf(this.value());
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                Object k2 = e2.getKey();
                char v2 = ((Character)e2.getValue()).charValue();
                return MutableQHashSeparateKVObjCharMapGO.this.nullableKeyEquals(k2, this.key()) && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return MutableQHashSeparateKVObjCharMapGO.this.nullableKeyHashCode(this.key()) ^ Primitives.hashCode((char)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<K, Character>>
    implements HashObjSet<Map.Entry<K, Character>>,
    InternalObjCollectionOps<Map.Entry<K, Character>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<K, Character>> equivalence() {
            return Equivalence.entryEquivalence(MutableQHashSeparateKVObjCharMapGO.this.keyEquivalence(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableQHashSeparateKVObjCharMapGO.this.hashConfig();
        }

        public int size() {
            return MutableQHashSeparateKVObjCharMapGO.this.size;
        }

        public double currentLoad() {
            return MutableQHashSeparateKVObjCharMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableQHashSeparateKVObjCharMapGO.this.containsEntry(e.getKey(), ((Character)e.getValue()).charValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<K, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<K, Character>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || predicate.test((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || predicate.test((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<K, Character>> iterator() {
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            if (!MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                return new SomeRemovedEntryIterator(mc);
            }
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<K, Character>> cursor() {
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            if (!MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                return new SomeRemovedEntryCursor(mc);
            }
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<K, Character>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return MutableQHashSeparateKVObjCharMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    sb.append(' ');
                    sb.append(key != this ? key : "(this Collection)");
                    sb.append('=');
                    sb.append(vals[i]);
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    sb.append(' ');
                    sb.append(key != this ? key : "(this Collection)");
                    sb.append('=');
                    sb.append(vals[i]);
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVObjCharMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                char value = ((Character)e.getValue()).charValue();
                return MutableQHashSeparateKVObjCharMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<K, Character>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || !filter.test((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !filter.test((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || !c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = MutableQHashSeparateKVObjCharMapGO.this.values;
            if (MutableQHashSeparateKVObjCharMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVObjCharMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjCharMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public void clear() {
            MutableQHashSeparateKVObjCharMapGO.this.doClear();
        }
    }
}

