/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.CommonSetOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.hash.MutableObjQHashSetSO;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.impl.hash.SeparateKVObjQHash;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Set;
import javax.annotation.Nonnull;

public class MutableQHashObjSetGO<E>
extends MutableObjQHashSetSO<E>
implements HashObjSet<E>,
InternalObjCollectionOps<E> {
    @Override
    final void copy(SeparateKVObjQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVObjQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public int hashCode() {
        return this.setHashCode();
    }

    @Override
    public String toString() {
        return this.setToString();
    }

    @Override
    public boolean equals(Object obj) {
        return CommonSetOps.equals((Set)((Object)this), (Object)obj);
    }

    public boolean containsAll(@Nonnull Collection<?> c) {
        return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
    }

    @Nonnull
    public ObjCursor<E> cursor() {
        return this.setCursor();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean add(E key) {
        block27: {
            if (key == null) return this.addNullKey();
            Object[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(key)) % capacity;
            Object cur = keys[index];
            if (cur != FREE) {
                int firstRemoved;
                if (cur == key) {
                    return false;
                }
                if (cur != REMOVED) {
                    if (this.keyEquals(key, cur)) return false;
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == FREE) {
                                index = bIndex;
                                break block27;
                            }
                            if (cur == key || this.keyEquals(key, cur)) {
                                return false;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == FREE) {
                                index = fIndex;
                                break block27;
                            }
                            if (cur == key || this.keyEquals(key, cur)) {
                                return false;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == FREE) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block27;
                    }
                    if (cur == key) {
                        return false;
                    }
                    if (cur != REMOVED) {
                        if (this.keyEquals(key, cur)) {
                            return false;
                        }
                    } else if (firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == FREE) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block27;
                    }
                    if (cur == key) {
                        return false;
                    }
                    if (cur != REMOVED) {
                        if (this.keyEquals(key, cur)) {
                            return false;
                        }
                    } else if (firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                this.incrementModCount();
                keys[firstRemoved] = key;
                this.postRemovedSlotInsertHook();
                return true;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.postFreeSlotInsertHook();
        return true;
    }

    private boolean addNullKey() {
        block21: {
            Object[] keys = this.set;
            int capacity = keys.length;
            int index = 0;
            Object cur = keys[0];
            if (cur != FREE) {
                int firstRemoved;
                if (cur == null) {
                    return false;
                }
                if (cur != REMOVED) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == FREE) {
                                index = bIndex;
                                break block21;
                            }
                            if (cur == null) {
                                return false;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == FREE) {
                                index = fIndex;
                                break block21;
                            }
                            if (cur == null) {
                                return false;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == FREE) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block21;
                    }
                    if (cur == null) {
                        return false;
                    }
                    if (cur == REMOVED && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == FREE) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block21;
                    }
                    if (cur == null) {
                        return false;
                    }
                    if (cur == REMOVED && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                this.incrementModCount();
                keys[firstRemoved] = null;
                this.postRemovedSlotInsertHook();
                return true;
            }
        }
        this.incrementModCount();
        keys[index] = null;
        this.postFreeSlotInsertHook();
        return true;
    }

    public boolean addAll(@Nonnull Collection<? extends E> c) {
        return CommonObjCollectionOps.addAll((ObjCollection)this, c);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean remove(Object key) {
        if (key == null) {
            return this.removeNullKey();
        }
        Object k = key;
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVObjKeyMixing.mix((int)this.keyHashCode(k)) % capacity;
        Object cur = keys[index];
        if (cur != k) {
            if (cur == FREE) {
                return false;
            }
            if (cur != REMOVED) {
                if (!this.keyEquals(k, cur)) {
                    if (!this.noRemoved()) {
                    } else {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return false;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = bIndex;
                                break;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return false;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                }
            } else {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return false;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return false;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
        }
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return true;
    }

    private boolean removeNullKey() {
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur != null) {
            if (cur == FREE) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == null) {
                    index = bIndex;
                    break;
                }
                if (cur == FREE) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == null) {
                    index = fIndex;
                    break;
                }
                if (cur == FREE) {
                    return false;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return true;
    }

    @Override
    boolean justRemove(E key) {
        return this.remove(key);
    }

    public boolean removeAll(@Nonnull Collection<?> c) {
        InternalObjCollectionOps c2;
        if (c instanceof InternalObjCollectionOps && (c2 = (InternalObjCollectionOps)c).size() < this.size() && this.equivalence().equals((Object)c2.equivalence())) {
            return c2.reverseRemoveAllFrom((ObjSet)this);
        }
        return this.removeAll(this, c);
    }

    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.retainAll(this, c);
    }
}

