/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.FloatCollection;
import com.koloboke.collect.FloatCursor;
import com.koloboke.collect.FloatIterator;
import com.koloboke.collect.impl.InternalFloatCollectionOps;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.MutableParallelKVFloatQHashSO;
import com.koloboke.collect.set.FloatSet;
import com.koloboke.collect.set.hash.HashFloatSet;
import com.koloboke.function.FloatConsumer;
import com.koloboke.function.FloatPredicate;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public abstract class MutableParallelKVFloatQHashGO
extends MutableParallelKVFloatQHashSO {
    @Override
    @Nonnull
    public long[] table() {
        return this.table;
    }

    @Override
    public int capacity() {
        return this.table.length;
    }

    public void forEach(Consumer<? super Float> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE) continue;
            action.accept(Float.valueOf(Float.intBitsToFloat(key)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(FloatConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE) continue;
            action.accept(Float.intBitsToFloat(key));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(FloatPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE || predicate.test(Float.intBitsToFloat(key))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    public boolean allContainingIn(FloatCollection c) {
        if (c instanceof InternalFloatCollectionOps) {
            return this.allContainingIn((InternalFloatCollectionOps)c);
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE || c.contains(Float.intBitsToFloat(key))) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    boolean allContainingIn(InternalFloatCollectionOps c) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE || c.contains(key)) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public boolean reverseAddAllTo(FloatCollection c) {
        if (c instanceof InternalFloatCollectionOps) {
            return this.reverseAddAllTo((InternalFloatCollectionOps)c);
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE) continue;
            changed |= c.add(Float.intBitsToFloat(key));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean reverseAddAllTo(InternalFloatCollectionOps c) {
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE) continue;
            changed |= c.add(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean reverseRemoveAllFrom(FloatSet s) {
        if (s instanceof InternalFloatCollectionOps) {
            return this.reverseRemoveAllFrom((InternalFloatCollectionOps)s);
        }
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE) continue;
            changed |= s.removeFloat(Float.intBitsToFloat(key));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean reverseRemoveAllFrom(InternalFloatCollectionOps s) {
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE) continue;
            changed |= s.removeFloat(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public FloatIterator iterator() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedIterator(mc);
        }
        return new NoRemovedIterator(mc);
    }

    public FloatCursor setCursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedCursor(mc);
        }
        return new NoRemovedCursor(mc);
    }

    @Nonnull
    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE) continue;
            result[resultIndex++] = Float.valueOf(Float.intBitsToFloat(key));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        int size = this.size();
        if (a.length < size) {
            Class<?> elementType = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(elementType, size);
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE) continue;
            a[resultIndex++] = Float.valueOf(Float.intBitsToFloat(key));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = null;
        }
        return a;
    }

    @Nonnull
    public float[] toFloatArray() {
        int size = this.size();
        float[] result = new float[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE) continue;
            result[resultIndex++] = Float.intBitsToFloat(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public float[] toArray(float[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new float[size];
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = 0.0f;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE) continue;
            a[resultIndex++] = Float.intBitsToFloat(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = 0.0f;
        }
        return a;
    }

    public int setHashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE) continue;
            hashCode += key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    public String setToString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE) continue;
            sb.append(' ').append(Float.intBitsToFloat(key)).append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '[');
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    abstract boolean justRemove(int var1);

    public boolean removeIf(Predicate<? super Float> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE || !filter.test(Float.valueOf(Float.intBitsToFloat(key)))) continue;
            this.incrementModCount();
            ++mc;
            U.putInt(tab, base + off, Integer.MAX_VALUE);
            this.postRemoveHook();
            changed = true;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean removeIf(FloatPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE || !filter.test(Float.intBitsToFloat(key))) continue;
            this.incrementModCount();
            ++mc;
            U.putInt(tab, base + off, Integer.MAX_VALUE);
            this.postRemoveHook();
            changed = true;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashFloatSet thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE || !c.contains(Float.valueOf(Float.intBitsToFloat(key)))) continue;
            this.incrementModCount();
            ++mc;
            U.putInt(tab, base + off, Integer.MAX_VALUE);
            this.postRemoveHook();
            changed = true;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashFloatSet thisC, @Nonnull FloatCollection c) {
        if (c instanceof InternalFloatCollectionOps) {
            return this.removeAll(thisC, (InternalFloatCollectionOps)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE || !c.contains(Float.intBitsToFloat(key))) continue;
            this.incrementModCount();
            ++mc;
            U.putInt(tab, base + off, Integer.MAX_VALUE);
            this.postRemoveHook();
            changed = true;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashFloatSet thisC, @Nonnull InternalFloatCollectionOps c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE || !c.contains(key)) continue;
            this.incrementModCount();
            ++mc;
            U.putInt(tab, base + off, Integer.MAX_VALUE);
            this.postRemoveHook();
            changed = true;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean retainAll(@Nonnull HashFloatSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof FloatCollection) {
            return this.retainAll(thisC, (FloatCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE || c.contains(Float.valueOf(Float.intBitsToFloat(key)))) continue;
            this.incrementModCount();
            ++mc;
            U.putInt(tab, base + off, Integer.MAX_VALUE);
            this.postRemoveHook();
            changed = true;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashFloatSet thisC, @Nonnull FloatCollection c) {
        if (c instanceof InternalFloatCollectionOps) {
            return this.retainAll(thisC, (InternalFloatCollectionOps)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE || c.contains(Float.intBitsToFloat(key))) continue;
            this.incrementModCount();
            ++mc;
            U.putInt(tab, base + off, Integer.MAX_VALUE);
            this.postRemoveHook();
            changed = true;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashFloatSet thisC, @Nonnull InternalFloatCollectionOps c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE || c.contains(key)) continue;
            this.incrementModCount();
            ++mc;
            U.putInt(tab, base + off, Integer.MAX_VALUE);
            this.postRemoveHook();
            changed = true;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedCursor
    implements FloatCursor {
        final long[] tab;
        int expectedModCount;
        int index;
        int curKey;

        SomeRemovedCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVFloatQHashGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat(key));
            }
            if (index != this.index || mc != MutableParallelKVFloatQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public float elem() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return Float.intBitsToFloat(curKey);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableParallelKVFloatQHashGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != 0x7FFFFFFE) {
                if (this.expectedModCount++ != MutableParallelKVFloatQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = 0x7FFFFFFE;
            MutableParallelKVFloatQHashGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)this.index << 3), Integer.MAX_VALUE);
            MutableParallelKVFloatQHashGO.this.postRemoveHook();
        }
    }

    class SomeRemovedIterator
    implements FloatIterator {
        final long[] tab;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        float next;

        SomeRemovedIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVFloatQHashGO.this.table;
            long[] tab = MutableParallelKVFloatQHashGO.this.table;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                this.next = Float.intBitsToFloat(key);
                break;
            }
            this.nextIndex = nextI;
        }

        public float nextFloat() {
            if (this.expectedModCount == MutableParallelKVFloatQHashGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    float prev = this.next;
                    while (--nextI >= 0) {
                        long entry = tab[nextI];
                        int key = (int)entry;
                        if (key >= 0x7FFFFFFE) continue;
                        this.next = Float.intBitsToFloat(key);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Float> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept(Float.valueOf(Float.intBitsToFloat(key)));
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVFloatQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(FloatConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat(key));
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVFloatQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Float next() {
            return Float.valueOf(this.nextFloat());
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableParallelKVFloatQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableParallelKVFloatQHashGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)index << 3), Integer.MAX_VALUE);
            MutableParallelKVFloatQHashGO.this.postRemoveHook();
        }
    }

    class NoRemovedCursor
    implements FloatCursor {
        final long[] tab;
        int expectedModCount;
        int index;
        int curKey;

        NoRemovedCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVFloatQHashGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat(key));
            }
            if (index != this.index || mc != MutableParallelKVFloatQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public float elem() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return Float.intBitsToFloat(curKey);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableParallelKVFloatQHashGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != 0x7FFFFFFE) {
                if (this.expectedModCount++ != MutableParallelKVFloatQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = 0x7FFFFFFE;
            MutableParallelKVFloatQHashGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)this.index << 3), Integer.MAX_VALUE);
            MutableParallelKVFloatQHashGO.this.postRemoveHook();
        }
    }

    class NoRemovedIterator
    implements FloatIterator {
        final long[] tab;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        float next;

        NoRemovedIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVFloatQHashGO.this.table;
            long[] tab = MutableParallelKVFloatQHashGO.this.table;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                this.next = Float.intBitsToFloat(key);
                break;
            }
            this.nextIndex = nextI;
        }

        public float nextFloat() {
            if (this.expectedModCount == MutableParallelKVFloatQHashGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    float prev = this.next;
                    while (--nextI >= 0) {
                        long entry = tab[nextI];
                        int key = (int)entry;
                        if (key >= 0x7FFFFFFE) continue;
                        this.next = Float.intBitsToFloat(key);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Float> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept(Float.valueOf(Float.intBitsToFloat(key)));
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVFloatQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(FloatConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat(key));
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVFloatQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Float next() {
            return Float.valueOf(this.nextFloat());
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableParallelKVFloatQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableParallelKVFloatQHashGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_KEY_OFFSET + ((long)index << 3), Integer.MAX_VALUE);
            MutableParallelKVFloatQHashGO.this.postRemoveHook();
        }
    }
}

