/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.CharCollection;
import com.koloboke.collect.CharCursor;
import com.koloboke.collect.CharIterator;
import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractObjValueView;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonCharObjMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalCharObjMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.MutableLHashSeparateKVCharObjMapSO;
import com.koloboke.collect.impl.hash.MutableSeparateKVCharLHashGO;
import com.koloboke.collect.impl.hash.SeparateKVCharObjLHash;
import com.koloboke.collect.map.CharObjCursor;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashCharSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.CharFunction;
import com.koloboke.function.CharObjConsumer;
import com.koloboke.function.CharObjFunction;
import com.koloboke.function.CharObjPredicate;
import com.koloboke.function.CharPredicate;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class MutableLHashSeparateKVCharObjMapGO<V>
extends MutableLHashSeparateKVCharObjMapSO<V> {
    @Override
    final void copy(SeparateKVCharObjLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVCharObjLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public Equivalence<V> valueEquivalence() {
        return Equivalence.defaultEquality();
    }

    public boolean containsEntry(char key, Object value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.nullableValueEquals(this.values[index], value);
        }
        return false;
    }

    public V get(Object key) {
        int index = this.index(((Character)key).charValue());
        if (index >= 0) {
            return (V)this.values[index];
        }
        return null;
    }

    public V get(char key) {
        int index = this.index(key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return null;
    }

    public V getOrDefault(Object key, V defaultValue) {
        int index = this.index(((Character)key).charValue());
        if (index >= 0) {
            return (V)this.values[index];
        }
        return defaultValue;
    }

    public V getOrDefault(char key, V defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Character, ? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            action.accept(Character.valueOf(key), vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(CharObjConsumer<? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            action.accept(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(CharObjPredicate<? super V> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free || predicate.test(key, vals[i])) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public CharObjCursor<V> cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonCharObjMapOps.containsAllEntries((InternalCharObjMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalCharObjMapOps<?> m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalCharObjMapOps<? super V> m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Character, V>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ObjCollection<V> values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            hashCode += key ^ this.nullableValueHashCode(vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            Object val = vals[i];
            sb.append(val != this ? val : "(this Map)");
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        Object[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        char[] newKeys = this.set;
        int capacityMask = newKeys.length - 1;
        Object[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            int index = LHash.SeparateKVCharKeyMixing.mix((char)key) & capacityMask;
            if (newKeys[index] != free) {
                while (newKeys[index = index - 1 & capacityMask] != free) {
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public V put(Character key, V value) {
        int index = this.insert(key.charValue(), value);
        if (index < 0) {
            return null;
        }
        Object[] vals = this.values;
        Object prevValue = vals[index];
        vals[index] = value;
        return (V)prevValue;
    }

    public V put(char key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        Object[] vals = this.values;
        Object prevValue = vals[index];
        vals[index] = value;
        return (V)prevValue;
    }

    public V putIfAbsent(Character key, V value) {
        int index = this.insert(key.charValue(), value);
        if (index < 0) {
            return null;
        }
        return (V)this.values[index];
    }

    public V putIfAbsent(char key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        return (V)this.values[index];
    }

    public void justPut(char key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    /*
     * Unable to fully structure code
     */
    public V compute(Character key, BiFunction<? super Character, ? super V, ? extends V> remappingFunction) {
        block5: {
            k = key.charValue();
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVCharKeyMixing.mix((char)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl16
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != free) continue;
lbl16:
                // 2 sources

                if ((newValue = remappingFunction.apply(Character.valueOf(k), null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = newValue;
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(Character.valueOf(k), vals[index])) != null) {
            vals[index] = newValue;
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public V compute(char key, CharObjFunction<? super V, ? extends V> remappingFunction) {
        block5: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVCharKeyMixing.mix((char)key) & capacityMask;
            cur = keys[index];
            if (cur == key) break block5;
            if (cur == free) ** GOTO lbl15
            while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                if ((newValue = remappingFunction.apply(key, null)) != null) {
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = newValue;
                    this.postInsertHook();
                    return (V)newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(key, vals[index])) != null) {
            vals[index] = newValue;
            return (V)newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public V computeIfAbsent(Character key, Function<? super Character, ? extends V> mappingFunction) {
        block6: {
            k = key.charValue();
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVCharKeyMixing.mix((char)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block6;
            if (cur == free) ** GOTO lbl16
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != free) continue;
lbl16:
                // 2 sources

                if ((value = mappingFunction.apply(Character.valueOf(k))) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = value;
                    this.postInsertHook();
                    return value;
                }
                return null;
            }
        }
        if ((val = vals[index]) != null) {
            return (V)val;
        }
        value = mappingFunction.apply(Character.valueOf(k));
        if (value != null) {
            vals[index] = value;
            return value;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public V computeIfAbsent(char key, CharFunction<? extends V> mappingFunction) {
        block6: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVCharKeyMixing.mix((char)key) & capacityMask;
            cur = keys[index];
            if (cur == key) break block6;
            if (cur == free) ** GOTO lbl15
            while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                if ((value = mappingFunction.apply(key)) != null) {
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = value;
                    this.postInsertHook();
                    return (V)value;
                }
                return null;
            }
        }
        if ((val = vals[index]) != null) {
            return (V)val;
        }
        value = mappingFunction.apply(key);
        if (value != null) {
            vals[index] = value;
            return (V)value;
        }
        return null;
    }

    public V computeIfPresent(Character key, BiFunction<? super Character, ? super V, ? extends V> remappingFunction) {
        char k = key.charValue();
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            Object[] vals = this.values;
            Object val = vals[index];
            if (val != null) {
                V newValue = remappingFunction.apply(Character.valueOf(k), val);
                if (newValue != null) {
                    vals[index] = newValue;
                    return newValue;
                }
                this.removeAt(index);
                return null;
            }
            return null;
        }
        return null;
    }

    public V computeIfPresent(char key, CharObjFunction<? super V, ? extends V> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            Object[] vals = this.values;
            Object val = vals[index];
            if (val != null) {
                Object newValue = remappingFunction.apply(key, val);
                if (newValue != null) {
                    vals[index] = newValue;
                    return (V)newValue;
                }
                this.removeAt(index);
                return null;
            }
            return null;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public V merge(Character key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        block6: {
            k = key.charValue();
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVCharKeyMixing.mix((char)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block6;
            if (cur == free) ** GOTO lbl18
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != free) continue;
lbl18:
                // 2 sources

                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postInsertHook();
                return value;
            }
        }
        if ((val = vals[index]) != null) {
            newValue = remappingFunction.apply(val, value);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            this.removeAt(index);
            return null;
        }
        vals[index] = value;
        return value;
    }

    /*
     * Unable to fully structure code
     */
    public V merge(char key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        block6: {
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVCharKeyMixing.mix((char)key) & capacityMask;
            cur = keys[index];
            if (cur == key) break block6;
            if (cur == free) ** GOTO lbl17
            while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                if (cur != free) continue;
lbl17:
                // 2 sources

                this.incrementModCount();
                keys[index] = key;
                vals[index] = value;
                this.postInsertHook();
                return value;
            }
        }
        if ((val = vals[index]) != null) {
            newValue = remappingFunction.apply(val, value);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            this.removeAt(index);
            return null;
        }
        vals[index] = value;
        return value;
    }

    public void putAll(@Nonnull Map<? extends Character, ? extends V> m) {
        CommonCharObjMapOps.putAll((InternalCharObjMapOps)this, m);
    }

    public V replace(Character key, V value) {
        int index = this.index(key.charValue());
        if (index >= 0) {
            Object[] vals = this.values;
            Object oldValue = vals[index];
            vals[index] = value;
            return (V)oldValue;
        }
        return null;
    }

    public V replace(char key, V value) {
        int index = this.index(key);
        if (index >= 0) {
            Object[] vals = this.values;
            Object oldValue = vals[index];
            vals[index] = value;
            return (V)oldValue;
        }
        return null;
    }

    public boolean replace(Character key, V oldValue, V newValue) {
        return this.replace(key.charValue(), oldValue, newValue);
    }

    public boolean replace(char key, V oldValue, V newValue) {
        int index = this.index(key);
        if (index >= 0) {
            Object[] vals = this.values;
            if (this.nullableValueEquals(vals[index], oldValue)) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super Character, ? super V, ? extends V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            vals[i] = function.apply(Character.valueOf(key), vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(CharObjFunction<? super V, ? extends V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            vals[i] = function.apply(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        char keyToShift;
        int indexToRemove;
        char free = this.freeValue;
        char[] keys = this.set;
        Object[] vals = this.values;
        int capacityMask = keys.length - 1;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
            if ((LHash.SeparateKVCharKeyMixing.mix((char)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = keyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        keys[indexToRemove] = free;
        vals[indexToRemove] = null;
        this.postRemoveHook();
    }

    public V remove(Object key) {
        char free;
        char k = ((Character)key).charValue();
        if (k != (free = this.freeValue)) {
            char keyToShift;
            int indexToRemove;
            char[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVCharKeyMixing.mix((char)k) & capacityMask;
            char cur = keys[index];
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                    if (cur != free) continue;
                    return null;
                }
            }
            Object[] vals = this.values;
            Object val = vals[index];
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                if ((LHash.SeparateKVCharKeyMixing.mix((char)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = free;
            vals[indexToRemove] = null;
            this.postRemoveHook();
            return (V)val;
        }
        return null;
    }

    @Override
    public boolean justRemove(char key) {
        char free = this.freeValue;
        if (key != free) {
            char keyToShift;
            int indexToRemove;
            char[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVCharKeyMixing.mix((char)key) & capacityMask;
            char cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            Object[] vals = this.values;
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                if ((LHash.SeparateKVCharKeyMixing.mix((char)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = free;
            vals[indexToRemove] = null;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public V remove(char key) {
        char free = this.freeValue;
        if (key != free) {
            char keyToShift;
            int indexToRemove;
            char[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVCharKeyMixing.mix((char)key) & capacityMask;
            char cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return null;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                    if (cur != free) continue;
                    return null;
                }
            }
            Object[] vals = this.values;
            Object val = vals[index];
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                if ((LHash.SeparateKVCharKeyMixing.mix((char)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = free;
            vals[indexToRemove] = null;
            this.postRemoveHook();
            return (V)val;
        }
        return null;
    }

    public boolean remove(Object key, Object value) {
        return this.remove(((Character)key).charValue(), value);
    }

    public boolean remove(char key, Object value) {
        char free = this.freeValue;
        if (key != free) {
            Object[] vals;
            char[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVCharKeyMixing.mix((char)key) & capacityMask;
            char cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            if (this.nullableValueEquals((vals = this.values)[index], value)) {
                char keyToShift;
                int indexToRemove;
                this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                    if ((LHash.SeparateKVCharKeyMixing.mix((char)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = free;
                vals[indexToRemove] = null;
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeIf(CharObjPredicate<? super V> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                char key = keys[i];
                if (key == free || !filter.test(key, vals[i])) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVCharKeyMixing.mix((char)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    vals[indexToRemove] = null;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(Predicate<? super Character> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                char key = keys[i];
                if (key == free || !filter.test(Character.valueOf(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVCharKeyMixing.mix((char)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    vals[indexToRemove] = null;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(CharPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                char key = keys[i];
                if (key == free || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVCharKeyMixing.mix((char)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    vals[indexToRemove] = null;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeAll(@Nonnull HashCharSet thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                char key = keys[i];
                if (key == free || !c.contains(Character.valueOf(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVCharKeyMixing.mix((char)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    vals[indexToRemove] = null;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    boolean removeAll(@Nonnull HashCharSet thisC, @Nonnull CharCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                char key = keys[i];
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVCharKeyMixing.mix((char)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    vals[indexToRemove] = null;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean retainAll(@Nonnull HashCharSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof CharCollection) {
            return this.retainAll(thisC, (CharCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block13: {
                char key = keys[i];
                if (key == free || c.contains(Character.valueOf(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVCharKeyMixing.mix((char)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block13;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    vals[indexToRemove] = null;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashCharSet thisC, @Nonnull CharCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        Object[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block12: {
                char key = keys[i];
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVCharKeyMixing.mix((char)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    vals[indexToRemove] = null;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    void closeDelayedRemoved(int firstDelayedRemoved, char delayedRemoved) {
        char free = this.freeValue;
        char[] keys = this.set;
        Object[] vals = this.values;
        int capacityMask = keys.length - 1;
        for (int i = firstDelayedRemoved; i >= 0; --i) {
            char keyToShift;
            int indexToRemove;
            if (keys[i] != delayedRemoved) continue;
            int indexToShift = indexToRemove = i;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                if (keyToShift != delayedRemoved && (LHash.SeparateKVCharKeyMixing.mix((char)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + i) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = free;
            vals[indexToRemove] = null;
            this.postRemoveHook();
        }
    }

    @Override
    public CharIterator iterator() {
        int mc = this.modCount();
        return new NoRemovedKeyIterator(mc);
    }

    @Override
    public CharCursor setCursor() {
        int mc = this.modCount();
        return new NoRemovedKeyCursor(mc);
    }

    class NoRemovedMapCursor
    implements CharObjCursor<V> {
        char[] keys;
        V[] vals;
        final char free;
        final int capacityMask;
        int expectedModCount;
        int index;
        char curKey;
        V curValue;

        NoRemovedMapCursor(int mc) {
            char free;
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            this.curKey = free = (this.free = MutableLHashSeparateKVCharObjMapGO.this.freeValue);
        }

        public void forEachForward(CharObjConsumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] keys = this.keys;
            V[] vals = this.vals;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char key() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public V value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setValue(V value) {
            if (this.curKey == this.free) throw new IllegalStateException();
            if (this.expectedModCount != MutableLHashSeparateKVCharObjMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.vals[this.index] = value;
            if (this.vals == MutableLHashSeparateKVCharObjMapGO.this.values) return;
            MutableLHashSeparateKVCharObjMapGO.this.values[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                char[] keys = this.keys;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            char curKey = this.curKey;
            char free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVCharObjMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            char[] keys = this.keys;
            V[] vals = this.vals;
            if (keys == MutableLHashSeparateKVCharObjMapGO.this.set) {
                char keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVCharObjMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                    if ((LHash.SeparateKVCharKeyMixing.mix((char)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = free;
                                        this.vals[indexToRemove] = null;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = free;
                vals[indexToRemove] = null;
                MutableLHashSeparateKVCharObjMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVCharObjMapGO.this.justRemove(curKey);
                vals[index] = null;
            }
        }
    }

    class NoRemovedValueCursor
    implements ObjCursor<V> {
        char[] keys;
        V[] vals;
        final char free;
        final int capacityMask;
        int expectedModCount;
        int index;
        char curKey;
        V curValue;

        NoRemovedValueCursor(int mc) {
            char free;
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            this.curKey = free = (this.free = MutableLHashSeparateKVCharObjMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] keys = this.keys;
            V[] vals = this.vals;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public V elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                char[] keys = this.keys;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            char curKey = this.curKey;
            char free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVCharObjMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            char[] keys = this.keys;
            V[] vals = this.vals;
            if (keys == MutableLHashSeparateKVCharObjMapGO.this.set) {
                char keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVCharObjMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                    if ((LHash.SeparateKVCharKeyMixing.mix((char)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = free;
                                        this.vals[indexToRemove] = null;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = free;
                vals[indexToRemove] = null;
                MutableLHashSeparateKVCharObjMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVCharObjMapGO.this.justRemove(curKey);
                vals[index] = null;
            }
        }
    }

    class NoRemovedValueIterator
    implements ObjIterator<V> {
        char[] keys;
        V[] vals;
        final char free;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        V next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            Object[] vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            char free = this.free = MutableLHashSeparateKVCharObjMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(Consumer<? super V> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] keys = this.keys;
            V[] vals = this.vals;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public V next() {
            if (this.expectedModCount == MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    char[] keys = this.keys;
                    char free = this.free;
                    Object prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == free) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVCharObjMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            char[] keys = this.keys;
            V[] vals = this.vals;
            if (keys == MutableLHashSeparateKVCharObjMapGO.this.set) {
                char keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVCharObjMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != this.free) {
                    if ((LHash.SeparateKVCharKeyMixing.mix((char)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = this.free;
                                        this.vals[indexToRemove] = null;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = vals[indexToShift];
                                }
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = this.free;
                vals[indexToRemove] = null;
                MutableLHashSeparateKVCharObjMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVCharObjMapGO.this.justRemove(keys[index]);
                vals[index] = null;
            }
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Character, V>> {
        char[] keys;
        V[] vals;
        final char free;
        final int capacityMask;
        int expectedModCount;
        int index;
        char curKey;
        V curValue;

        NoRemovedEntryCursor(int mc) {
            char free;
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            this.curKey = free = (this.free = MutableLHashSeparateKVCharObjMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Character, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] keys = this.keys;
            V[] vals = this.vals;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry)((Object)new MutableEntry2(mc, i, key, vals[i])));
            }
            if (index != this.index || mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Character, V> elem() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry2(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                char[] keys = this.keys;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            char curKey = this.curKey;
            char free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVCharObjMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            char[] keys = this.keys;
            V[] vals = this.vals;
            if (keys == MutableLHashSeparateKVCharObjMapGO.this.set) {
                char keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVCharObjMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                    if ((LHash.SeparateKVCharKeyMixing.mix((char)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = free;
                                        this.vals[indexToRemove] = null;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = free;
                vals[indexToRemove] = null;
                MutableLHashSeparateKVCharObjMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVCharObjMapGO.this.justRemove(curKey);
                vals[index] = null;
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, char key, V value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(V newValue) {
                if (NoRemovedEntryCursor.this.vals == MutableLHashSeparateKVCharObjMapGO.this.values) {
                    NoRemovedEntryCursor.this.vals[NoRemovedEntryCursor.this.index] = newValue;
                } else {
                    MutableLHashSeparateKVCharObjMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Character, V>> {
        char[] keys;
        V[] vals;
        final char free;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            Object[] vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            char free = this.free = MutableLHashSeparateKVCharObjMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                char key = keys[nextI];
                if (key == free) continue;
                this.next = new MutableEntry2(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Character, V>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] keys = this.keys;
            V[] vals = this.vals;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry)((Object)new MutableEntry2(mc, i, key, vals[i])));
            }
            if (nextI != this.nextIndex || mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Character, V> next() {
            int mc = this.expectedModCount;
            if (mc == MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    char[] keys = this.keys;
                    char free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        char key = keys[nextI];
                        if (key == free) continue;
                        this.next = new MutableEntry2(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVCharObjMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            char[] keys = this.keys;
            V[] vals = this.vals;
            if (keys == MutableLHashSeparateKVCharObjMapGO.this.set) {
                char keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVCharObjMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != this.free) {
                    if ((LHash.SeparateKVCharKeyMixing.mix((char)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = this.free;
                                        this.vals[indexToRemove] = null;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = new MutableEntry2(MutableLHashSeparateKVCharObjMapGO.this.modCount(), indexToShift, keyToShift, vals[indexToShift]);
                                }
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = this.free;
                vals[indexToRemove] = null;
                MutableLHashSeparateKVCharObjMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVCharObjMapGO.this.justRemove(keys[index]);
                vals[index] = null;
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, char key, V value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(V newValue) {
                if (NoRemovedEntryIterator.this.vals == MutableLHashSeparateKVCharObjMapGO.this.values) {
                    NoRemovedEntryIterator.this.vals[NoRemovedEntryIterator.this.index] = newValue;
                } else {
                    MutableLHashSeparateKVCharObjMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class ValueView
    extends AbstractObjValueView<V> {
        ValueView() {
        }

        public Equivalence<V> equivalence() {
            return MutableLHashSeparateKVCharObjMapGO.this.valueEquivalence();
        }

        public int size() {
            return MutableLHashSeparateKVCharObjMapGO.this.size();
        }

        public boolean shrink() {
            return MutableLHashSeparateKVCharObjMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return MutableLHashSeparateKVCharObjMapGO.this.containsValue(o);
        }

        public void forEach(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashSeparateKVCharObjMapGO.this.modCount();
            char free = MutableLHashSeparateKVCharObjMapGO.this.freeValue;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            Object[] vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(Predicate<? super V> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashSeparateKVCharObjMapGO.this.modCount();
            char free = MutableLHashSeparateKVCharObjMapGO.this.freeValue;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            Object[] vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableLHashSeparateKVCharObjMapGO.this.modCount();
            char free = MutableLHashSeparateKVCharObjMapGO.this.freeValue;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            Object[] vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(ObjCollection<? super V> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVCharObjMapGO.this.modCount();
            char free = MutableLHashSeparateKVCharObjMapGO.this.freeValue;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            Object[] vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            if (mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVCharObjMapGO.this.modCount();
            char free = MutableLHashSeparateKVCharObjMapGO.this.freeValue;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            Object[] vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.remove(vals[i]);
            }
            if (mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public ObjIterator<V> iterator() {
            int mc = MutableLHashSeparateKVCharObjMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ObjCursor<V> cursor() {
            int mc = MutableLHashSeparateKVCharObjMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVCharObjMapGO.this.modCount();
            char free = MutableLHashSeparateKVCharObjMapGO.this.freeValue;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            Object[] vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVCharObjMapGO.this.modCount();
            char free = MutableLHashSeparateKVCharObjMapGO.this.freeValue;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            Object[] vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashSeparateKVCharObjMapGO.this.modCount();
            char free = MutableLHashSeparateKVCharObjMapGO.this.freeValue;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            Object[] vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object val;
                if (keys[i] == free) continue;
                sb.append(' ').append((val = vals[i]) != this ? val : "(this Collection)").append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return MutableLHashSeparateKVCharObjMapGO.this.removeValue(o);
        }

        public void clear() {
            MutableLHashSeparateKVCharObjMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super V> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVCharObjMapGO.this.modCount();
            char free = MutableLHashSeparateKVCharObjMapGO.this.freeValue;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            char delayedRemoved = '\u0000';
            Object[] vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    char key = keys[i];
                    if (key == free || !filter.test(vals[i])) continue;
                    MutableLHashSeparateKVCharObjMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        char keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVCharKeyMixing.mix((char)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        vals[indexToRemove] = null;
                        MutableLHashSeparateKVCharObjMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVCharObjMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVCharObjMapGO.this.modCount();
            char free = MutableLHashSeparateKVCharObjMapGO.this.freeValue;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            char delayedRemoved = '\u0000';
            Object[] vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    char key = keys[i];
                    if (key == free || !c.contains(vals[i])) continue;
                    MutableLHashSeparateKVCharObjMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        char keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVCharKeyMixing.mix((char)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        vals[indexToRemove] = null;
                        MutableLHashSeparateKVCharObjMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVCharObjMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVCharObjMapGO.this.modCount();
            char free = MutableLHashSeparateKVCharObjMapGO.this.freeValue;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            char delayedRemoved = '\u0000';
            Object[] vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    char key = keys[i];
                    if (key == free || c.contains(vals[i])) continue;
                    MutableLHashSeparateKVCharObjMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        char keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVCharKeyMixing.mix((char)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        vals[indexToRemove] = null;
                        MutableLHashSeparateKVCharObjMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVCharObjMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends CharObjEntry {
        private char key;
        private V value;

        ReusableEntry() {
        }

        ReusableEntry with(char key, V value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }
    }

    class MutableEntry
    extends CharObjEntry {
        final int modCount;
        private final int index;
        final char key;
        private V value;

        MutableEntry(int modCount, int index, char key, V value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }

        public V setValue(V newValue) {
            if (this.modCount != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            Object oldValue = this.value;
            Object unwrappedNewValue = newValue;
            this.value = unwrappedNewValue;
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(V newValue) {
            MutableLHashSeparateKVCharObjMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class CharObjEntry
    extends AbstractEntry<Character, V> {
        CharObjEntry() {
        }

        abstract char key();

        public final Character getKey() {
            return Character.valueOf(this.key());
        }

        abstract V value();

        public final V getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                char k2 = ((Character)e2.getKey()).charValue();
                Object v2 = e2.getValue();
                return this.key() == k2 && MutableLHashSeparateKVCharObjMapGO.this.nullableValueEquals(v2, this.value());
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((char)this.key()) ^ MutableLHashSeparateKVCharObjMapGO.this.nullableValueHashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Character, V>>
    implements HashObjSet<Map.Entry<Character, V>>,
    InternalObjCollectionOps<Map.Entry<Character, V>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Character, V>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), MutableLHashSeparateKVCharObjMapGO.this.valueEquivalence());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableLHashSeparateKVCharObjMapGO.this.hashConfig();
        }

        public int size() {
            return MutableLHashSeparateKVCharObjMapGO.this.size;
        }

        public double currentLoad() {
            return MutableLHashSeparateKVCharObjMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableLHashSeparateKVCharObjMapGO.this.containsEntry(((Character)e.getKey()).charValue(), e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVCharObjMapGO.this.modCount();
            char free = MutableLHashSeparateKVCharObjMapGO.this.freeValue;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            Object[] vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVCharObjMapGO.this.modCount();
            char free = MutableLHashSeparateKVCharObjMapGO.this.freeValue;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            Object[] vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Character, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashSeparateKVCharObjMapGO.this.modCount();
            char free = MutableLHashSeparateKVCharObjMapGO.this.freeValue;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            Object[] vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Character, V>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashSeparateKVCharObjMapGO.this.modCount();
            char free = MutableLHashSeparateKVCharObjMapGO.this.freeValue;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            Object[] vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || predicate.test((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Character, V>> iterator() {
            int mc = MutableLHashSeparateKVCharObjMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Character, V>> cursor() {
            int mc = MutableLHashSeparateKVCharObjMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVCharObjMapGO.this.modCount();
            char free = MutableLHashSeparateKVCharObjMapGO.this.freeValue;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            Object[] vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVCharObjMapGO.this.modCount();
            char free = MutableLHashSeparateKVCharObjMapGO.this.freeValue;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            Object[] vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            if (mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Character, V>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVCharObjMapGO.this.modCount();
            char free = MutableLHashSeparateKVCharObjMapGO.this.freeValue;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            Object[] vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return MutableLHashSeparateKVCharObjMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashSeparateKVCharObjMapGO.this.modCount();
            char free = MutableLHashSeparateKVCharObjMapGO.this.freeValue;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            Object[] vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                Object val = vals[i];
                sb.append(val != this ? val : "(this Collection)");
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableLHashSeparateKVCharObjMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                char key = ((Character)e.getKey()).charValue();
                Object value = e.getValue();
                return MutableLHashSeparateKVCharObjMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Character, V>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVCharObjMapGO.this.modCount();
            char free = MutableLHashSeparateKVCharObjMapGO.this.freeValue;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            char delayedRemoved = '\u0000';
            Object[] vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    char key = keys[i];
                    if (key == free || !filter.test((Map.Entry)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    MutableLHashSeparateKVCharObjMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        char keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVCharKeyMixing.mix((char)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        vals[indexToRemove] = null;
                        MutableLHashSeparateKVCharObjMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVCharObjMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVCharObjMapGO.this.modCount();
            char free = MutableLHashSeparateKVCharObjMapGO.this.freeValue;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            char delayedRemoved = '\u0000';
            Object[] vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block13: {
                    char key = keys[i];
                    if (key == free || !c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableLHashSeparateKVCharObjMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        char keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVCharKeyMixing.mix((char)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        vals[indexToRemove] = null;
                        MutableLHashSeparateKVCharObjMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVCharObjMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVCharObjMapGO.this.modCount();
            char free = MutableLHashSeparateKVCharObjMapGO.this.freeValue;
            char[] keys = MutableLHashSeparateKVCharObjMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            char delayedRemoved = '\u0000';
            Object[] vals = MutableLHashSeparateKVCharObjMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    char key = keys[i];
                    if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableLHashSeparateKVCharObjMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        char keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVCharKeyMixing.mix((char)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        vals[indexToRemove] = null;
                        MutableLHashSeparateKVCharObjMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVCharObjMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVCharObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public void clear() {
            MutableLHashSeparateKVCharObjMapGO.this.doClear();
        }
    }

    class NoRemovedKeyCursor
    extends MutableSeparateKVCharLHashGO.NoRemovedCursor {
        V[] vals;

        private NoRemovedKeyCursor(int mc) {
            super(MutableLHashSeparateKVCharObjMapGO.this, mc);
            this.vals = MutableLHashSeparateKVCharObjMapGO.this.values;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            char curKey = this.curKey;
            char free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVCharObjMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            char[] keys = this.keys;
            V[] vals = this.vals;
            if (keys == MutableLHashSeparateKVCharObjMapGO.this.set) {
                char keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVCharObjMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                    if ((LHash.SeparateKVCharKeyMixing.mix((char)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = free;
                                        this.vals[indexToRemove] = null;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = free;
                vals[indexToRemove] = null;
                MutableLHashSeparateKVCharObjMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVCharObjMapGO.this.justRemove(curKey);
                vals[index] = null;
            }
        }
    }

    class NoRemovedKeyIterator
    extends MutableSeparateKVCharLHashGO.NoRemovedIterator {
        V[] vals;

        private NoRemovedKeyIterator(int mc) {
            super(MutableLHashSeparateKVCharObjMapGO.this, mc);
            this.vals = MutableLHashSeparateKVCharObjMapGO.this.values;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVCharObjMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            char[] keys = this.keys;
            V[] vals = this.vals;
            if (keys == MutableLHashSeparateKVCharObjMapGO.this.set) {
                char keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVCharObjMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != this.free) {
                    if ((LHash.SeparateKVCharKeyMixing.mix((char)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = this.free;
                                        this.vals[indexToRemove] = null;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = keyToShift;
                                }
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = this.free;
                vals[indexToRemove] = null;
                MutableLHashSeparateKVCharObjMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVCharObjMapGO.this.justRemove(keys[index]);
                vals[index] = null;
            }
        }
    }
}

