/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.hash.LongHashFactory;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.AbstractHashFactory;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

abstract class LongHashFactorySO
extends AbstractHashFactory {
    final long lower;
    final long upper;
    final boolean randomFree;
    final boolean randomRemoved;
    final long freeValue;
    final long removedValue;

    LongHashFactorySO(HashConfig hashConf, int defaultExpectedSize, long lower, long upper) {
        super(hashConf, defaultExpectedSize);
        this.lower = lower;
        this.upper = upper;
        if (lower - 1L == upper) {
            this.randomFree = false;
            this.randomRemoved = true;
            this.removedValue = 0L;
            this.freeValue = 0L;
        } else {
            this.randomFree = false;
            this.freeValue = lower < upper && (lower > 0L || upper < 0L) || upper < lower && lower > 0L && upper < 0L ? 0L : lower - 1L;
            if (lower - 2L == upper) {
                this.randomRemoved = true;
                this.removedValue = 0L;
            } else {
                this.randomRemoved = false;
                this.removedValue = upper + 1L != 0L ? upper + 1L : upper + 2L;
            }
        }
    }

    public final long getLowerKeyDomainBound() {
        return this.lower;
    }

    public final long getUpperKeyDomainBound() {
        return this.upper;
    }

    long getFree() {
        if (this.randomFree) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            return ((Random)random).nextInt();
        }
        return this.freeValue;
    }

    String keySpecialString() {
        return ",lowerKeyDomainBound=" + LongHashFactorySO.boundAsString(this.getLowerKeyDomainBound()) + ",upperKeyDomainBound=" + LongHashFactorySO.boundAsString(this.getUpperKeyDomainBound());
    }

    private static String boundAsString(long bound) {
        return "" + bound;
    }

    int keySpecialHashCode(int hashCode) {
        hashCode = hashCode * 31 + Primitives.hashCode((long)this.getLowerKeyDomainBound());
        return hashCode * 31 + Primitives.hashCode((long)this.getUpperKeyDomainBound());
    }

    boolean keySpecialEquals(LongHashFactory other) {
        return this.getLowerKeyDomainBound() == other.getLowerKeyDomainBound() && this.getUpperKeyDomainBound() == other.getUpperKeyDomainBound();
    }
}

