/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.ShortCollection;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.hash.ImmutableLHashShortSet;
import com.koloboke.collect.impl.hash.ImmutableLHashShortSetGO;
import com.koloboke.collect.impl.hash.MutableLHashShortSet;
import com.koloboke.collect.impl.hash.MutableLHashShortSetGO;
import com.koloboke.collect.impl.hash.SeparateKVShortLHash;
import com.koloboke.collect.impl.hash.ShortLHashFactory;
import com.koloboke.collect.impl.hash.UpdatableLHashShortSet;
import com.koloboke.collect.impl.hash.UpdatableLHashShortSetGO;
import com.koloboke.collect.set.hash.HashShortSetFactory;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class LHashShortSetFactorySO
extends ShortLHashFactory
implements HashShortSetFactory {
    LHashShortSetFactorySO(HashConfig hashConf, int defaultExpectedSize, short lower, short upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    MutableLHashShortSetGO uninitializedMutableSet() {
        return new MutableLHashShortSet();
    }

    UpdatableLHashShortSetGO uninitializedUpdatableSet() {
        return new UpdatableLHashShortSet();
    }

    ImmutableLHashShortSetGO uninitializedImmutableSet() {
        return new ImmutableLHashShortSet();
    }

    @Nonnull
    public MutableLHashShortSetGO newMutableSet(int expectedSize) {
        MutableLHashShortSet set = new MutableLHashShortSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    @Nonnull
    public UpdatableLHashShortSetGO newUpdatableSet(int expectedSize) {
        UpdatableLHashShortSet set = new UpdatableLHashShortSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    @Nonnull
    public UpdatableLHashShortSetGO newUpdatableSet(Iterable<Short> elements, int expectedSize) {
        if (elements instanceof ShortCollection) {
            SeparateKVShortLHash hash;
            if (elements instanceof SeparateKVShortLHash && (hash = (SeparateKVShortLHash)((Object)elements)).hashConfig().equals(this.hashConf)) {
                UpdatableLHashShortSet set = new UpdatableLHashShortSet();
                set.copy(hash);
                return set;
            }
            int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
            UpdatableLHashShortSetGO set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
        UpdatableLHashShortSetGO set = this.newUpdatableSet(size);
        for (short e : elements) {
            set.add(e);
        }
        return set;
    }
}

