/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.CharCollection;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.hash.CharacterLHashFactory;
import com.koloboke.collect.impl.hash.ImmutableLHashCharSet;
import com.koloboke.collect.impl.hash.ImmutableLHashCharSetGO;
import com.koloboke.collect.impl.hash.MutableLHashCharSet;
import com.koloboke.collect.impl.hash.MutableLHashCharSetGO;
import com.koloboke.collect.impl.hash.SeparateKVCharLHash;
import com.koloboke.collect.impl.hash.UpdatableLHashCharSet;
import com.koloboke.collect.impl.hash.UpdatableLHashCharSetGO;
import com.koloboke.collect.set.hash.HashCharSetFactory;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class LHashCharSetFactorySO
extends CharacterLHashFactory
implements HashCharSetFactory {
    LHashCharSetFactorySO(HashConfig hashConf, int defaultExpectedSize, char lower, char upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    MutableLHashCharSetGO uninitializedMutableSet() {
        return new MutableLHashCharSet();
    }

    UpdatableLHashCharSetGO uninitializedUpdatableSet() {
        return new UpdatableLHashCharSet();
    }

    ImmutableLHashCharSetGO uninitializedImmutableSet() {
        return new ImmutableLHashCharSet();
    }

    @Nonnull
    public MutableLHashCharSetGO newMutableSet(int expectedSize) {
        MutableLHashCharSet set = new MutableLHashCharSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    @Nonnull
    public UpdatableLHashCharSetGO newUpdatableSet(int expectedSize) {
        UpdatableLHashCharSet set = new UpdatableLHashCharSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    @Nonnull
    public UpdatableLHashCharSetGO newUpdatableSet(Iterable<Character> elements, int expectedSize) {
        if (elements instanceof CharCollection) {
            SeparateKVCharLHash hash;
            if (elements instanceof SeparateKVCharLHash && (hash = (SeparateKVCharLHash)((Object)elements)).hashConfig().equals(this.hashConf)) {
                UpdatableLHashCharSet set = new UpdatableLHashCharSet();
                set.copy(hash);
                return set;
            }
            int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
            UpdatableLHashCharSetGO set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
        UpdatableLHashCharSetGO set = this.newUpdatableSet(size);
        for (char e : elements) {
            set.add(e);
        }
        return set;
    }
}

