/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.hash.ByteHashFactory;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.hash.HashContainerFactory;
import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.hash.ImmutableLHashByteSetGO;
import com.koloboke.collect.impl.hash.LHashByteSetFactorySO;
import com.koloboke.collect.impl.hash.LHashCapacities;
import com.koloboke.collect.impl.hash.MutableLHashByteSetGO;
import com.koloboke.collect.impl.hash.SeparateKVByteLHash;
import com.koloboke.collect.impl.hash.UpdatableLHashByteSetGO;
import com.koloboke.collect.set.hash.HashByteSet;
import com.koloboke.collect.set.hash.HashByteSetFactory;
import com.koloboke.function.ByteConsumer;
import com.koloboke.function.Predicate;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public abstract class LHashByteSetFactoryGO
extends LHashByteSetFactorySO {
    public LHashByteSetFactoryGO(HashConfig hashConf, int defaultExpectedSize, byte lower, byte upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    abstract HashByteSetFactory thisWith(HashConfig var1, int var2, byte var3, byte var4);

    abstract HashByteSetFactory lHashLikeThisWith(HashConfig var1, int var2, byte var3, byte var4);

    abstract HashByteSetFactory qHashLikeThisWith(HashConfig var1, int var2, byte var3, byte var4);

    public final HashByteSetFactory withHashConfig(@Nonnull HashConfig hashConf) {
        if (LHashCapacities.configIsSuitableForMutableLHash((HashConfig)hashConf)) {
            return this.lHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
        }
        return this.qHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    public final HashByteSetFactory withDefaultExpectedSize(int defaultExpectedSize) {
        if (defaultExpectedSize == this.getDefaultExpectedSize()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), defaultExpectedSize, this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    public String toString() {
        return "HashByteSetFactory[" + this.commonString() + this.keySpecialString() + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashByteSetFactory) {
            HashByteSetFactory factory = (HashByteSetFactory)obj;
            return this.commonEquals((HashContainerFactory<?>)factory) && this.keySpecialEquals((ByteHashFactory)factory);
        }
        return false;
    }

    public int hashCode() {
        return this.keySpecialHashCode(this.commonHashCode());
    }

    private UpdatableLHashByteSetGO shrunk(UpdatableLHashByteSetGO set) {
        Predicate shrinkCondition = this.hashConf.getShrinkCondition();
        if (shrinkCondition != null && shrinkCondition.test(set)) {
            set.shrink();
        }
        return set;
    }

    @Nonnull
    public UpdatableLHashByteSetGO newUpdatableSet() {
        return this.newUpdatableSet(this.getDefaultExpectedSize());
    }

    @Nonnull
    public MutableLHashByteSetGO newMutableSet() {
        return this.newMutableSet(this.getDefaultExpectedSize());
    }

    private static int sizeOr(Iterable elems, int defaultSize) {
        return elems instanceof Collection ? ((Collection)elems).size() : defaultSize;
    }

    @Nonnull
    public UpdatableLHashByteSetGO newUpdatableSet(Iterable<Byte> elements) {
        return this.newUpdatableSet((Iterable)elements, LHashByteSetFactoryGO.sizeOr(elements, this.getDefaultExpectedSize()));
    }

    @Nonnull
    public UpdatableLHashByteSetGO newUpdatableSet(Iterable<Byte> elems1, Iterable<Byte> elems2) {
        long expectedSize = LHashByteSetFactoryGO.sizeOr(elems1, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, Containers.sizeAsInt((long)(expectedSize += (long)LHashByteSetFactoryGO.sizeOr(elems2, 0))));
    }

    @Nonnull
    public UpdatableLHashByteSetGO newUpdatableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3) {
        long expectedSize = LHashByteSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)LHashByteSetFactoryGO.sizeOr(elems2, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, Containers.sizeAsInt((long)(expectedSize += (long)LHashByteSetFactoryGO.sizeOr(elems3, 0))));
    }

    @Nonnull
    public UpdatableLHashByteSetGO newUpdatableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, Iterable<Byte> elems4) {
        long expectedSize = LHashByteSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)LHashByteSetFactoryGO.sizeOr(elems2, 0);
        expectedSize += (long)LHashByteSetFactoryGO.sizeOr(elems3, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, Containers.sizeAsInt((long)(expectedSize += (long)LHashByteSetFactoryGO.sizeOr(elems4, 0))));
    }

    @Nonnull
    public UpdatableLHashByteSetGO newUpdatableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, Iterable<Byte> elems4, Iterable<Byte> elems5) {
        long expectedSize = LHashByteSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)LHashByteSetFactoryGO.sizeOr(elems2, 0);
        expectedSize += (long)LHashByteSetFactoryGO.sizeOr(elems3, 0);
        expectedSize += (long)LHashByteSetFactoryGO.sizeOr(elems4, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, Containers.sizeAsInt((long)(expectedSize += (long)LHashByteSetFactoryGO.sizeOr(elems5, 0))));
    }

    @Override
    @Nonnull
    public UpdatableLHashByteSetGO newUpdatableSet(Iterable<Byte> elements, int expectedSize) {
        return this.shrunk((UpdatableLHashByteSetGO)super.newUpdatableSet((Iterable)elements, expectedSize));
    }

    private static void addAll(UpdatableLHashByteSetGO set, Iterable<? extends Byte> elems) {
        if (elems instanceof Collection) {
            set.addAll((Collection)elems);
        } else {
            Iterator<? extends Byte> iterator = elems.iterator();
            while (iterator.hasNext()) {
                byte e = iterator.next();
                set.add(e);
            }
        }
    }

    @Nonnull
    public UpdatableLHashByteSetGO newUpdatableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, int expectedSize) {
        UpdatableLHashByteSetGO set = this.newUpdatableSet(expectedSize);
        LHashByteSetFactoryGO.addAll(set, elems1);
        LHashByteSetFactoryGO.addAll(set, elems2);
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableLHashByteSetGO newUpdatableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, int expectedSize) {
        UpdatableLHashByteSetGO set = this.newUpdatableSet(expectedSize);
        LHashByteSetFactoryGO.addAll(set, elems1);
        LHashByteSetFactoryGO.addAll(set, elems2);
        LHashByteSetFactoryGO.addAll(set, elems3);
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableLHashByteSetGO newUpdatableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, Iterable<Byte> elems4, int expectedSize) {
        UpdatableLHashByteSetGO set = this.newUpdatableSet(expectedSize);
        LHashByteSetFactoryGO.addAll(set, elems1);
        LHashByteSetFactoryGO.addAll(set, elems2);
        LHashByteSetFactoryGO.addAll(set, elems3);
        LHashByteSetFactoryGO.addAll(set, elems4);
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableLHashByteSetGO newUpdatableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, Iterable<Byte> elems4, Iterable<Byte> elems5, int expectedSize) {
        UpdatableLHashByteSetGO set = this.newUpdatableSet(expectedSize);
        LHashByteSetFactoryGO.addAll(set, elems1);
        LHashByteSetFactoryGO.addAll(set, elems2);
        LHashByteSetFactoryGO.addAll(set, elems3);
        LHashByteSetFactoryGO.addAll(set, elems4);
        LHashByteSetFactoryGO.addAll(set, elems5);
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableLHashByteSetGO newUpdatableSet(Iterator<Byte> elements) {
        return this.newUpdatableSet((Iterator)elements, this.getDefaultExpectedSize());
    }

    @Nonnull
    public UpdatableLHashByteSetGO newUpdatableSet(Iterator<Byte> elements, int expectedSize) {
        UpdatableLHashByteSetGO set = this.newUpdatableSet(expectedSize);
        while (elements.hasNext()) {
            set.add(elements.next());
        }
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableLHashByteSetGO newUpdatableSet(Consumer<ByteConsumer> elementsSupplier) {
        return this.newUpdatableSet((Consumer)elementsSupplier, this.getDefaultExpectedSize());
    }

    @Nonnull
    public UpdatableLHashByteSetGO newUpdatableSet(Consumer<ByteConsumer> elementsSupplier, int expectedSize) {
        final UpdatableLHashByteSetGO set = this.newUpdatableSet(expectedSize);
        elementsSupplier.accept(new ByteConsumer(){

            public void accept(byte e) {
                set.add(e);
            }
        });
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableLHashByteSetGO newUpdatableSet(byte[] elements) {
        return this.newUpdatableSet(elements, elements.length);
    }

    @Nonnull
    public UpdatableLHashByteSetGO newUpdatableSet(byte[] elements, int expectedSize) {
        UpdatableLHashByteSetGO set = this.newUpdatableSet(expectedSize);
        for (byte e : elements) {
            set.add(e);
        }
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableLHashByteSetGO newUpdatableSet(Byte[] elements) {
        return this.newUpdatableSet(elements, elements.length);
    }

    @Nonnull
    public UpdatableLHashByteSetGO newUpdatableSet(Byte[] elements, int expectedSize) {
        UpdatableLHashByteSetGO set = this.newUpdatableSet(expectedSize);
        Byte[] byteArray = elements;
        int n = byteArray.length;
        for (int i = 0; i < n; ++i) {
            byte e = byteArray[i];
            set.add(e);
        }
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableLHashByteSetGO newUpdatableSetOf(byte e1) {
        UpdatableLHashByteSetGO set = this.newUpdatableSet(1);
        set.add(e1);
        return set;
    }

    @Nonnull
    public UpdatableLHashByteSetGO newUpdatableSetOf(byte e1, byte e2) {
        UpdatableLHashByteSetGO set = this.newUpdatableSet(2);
        set.add(e1);
        set.add(e2);
        return set;
    }

    @Nonnull
    public UpdatableLHashByteSetGO newUpdatableSetOf(byte e1, byte e2, byte e3) {
        UpdatableLHashByteSetGO set = this.newUpdatableSet(3);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        return set;
    }

    @Nonnull
    public UpdatableLHashByteSetGO newUpdatableSetOf(byte e1, byte e2, byte e3, byte e4) {
        UpdatableLHashByteSetGO set = this.newUpdatableSet(4);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        return set;
    }

    @Nonnull
    public UpdatableLHashByteSetGO newUpdatableSetOf(byte e1, byte e2, byte e3, byte e4, byte e5, byte ... restElements) {
        UpdatableLHashByteSetGO set = this.newUpdatableSet(5 + restElements.length);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        set.add(e5);
        for (byte e : restElements) {
            set.add(e);
        }
        return this.shrunk(set);
    }

    @Nonnull
    public HashByteSet newMutableSet(Iterable<Byte> elements, int expectedSize) {
        MutableLHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Iterable)elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, int expectedSize) {
        MutableLHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, int expectedSize) {
        MutableLHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, Iterable<Byte> elems4, int expectedSize) {
        MutableLHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, Iterable<Byte> elems4, Iterable<Byte> elems5, int expectedSize) {
        MutableLHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Iterable<Byte> elements) {
        MutableLHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Iterable)elements));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2) {
        MutableLHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3) {
        MutableLHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, Iterable<Byte> elems4) {
        MutableLHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, Iterable<Byte> elems4, Iterable<Byte> elems5) {
        MutableLHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Iterator<Byte> elements) {
        MutableLHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Iterator)elements));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Iterator<Byte> elements, int expectedSize) {
        MutableLHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Iterator)elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Consumer<ByteConsumer> elementsSupplier) {
        MutableLHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Consumer)elementsSupplier));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Consumer<ByteConsumer> elementsSupplier, int expectedSize) {
        MutableLHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Consumer)elementsSupplier, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(byte[] elements) {
        MutableLHashByteSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(byte[] elements, int expectedSize) {
        MutableLHashByteSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Byte[] elements) {
        MutableLHashByteSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Byte[] elements, int expectedSize) {
        MutableLHashByteSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSetOf(byte e1) {
        MutableLHashByteSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSetOf(byte e1, byte e2) {
        MutableLHashByteSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSetOf(byte e1, byte e2, byte e3) {
        MutableLHashByteSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSetOf(byte e1, byte e2, byte e3, byte e4) {
        MutableLHashByteSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSetOf(byte e1, byte e2, byte e3, byte e4, byte e5, byte ... restElements) {
        MutableLHashByteSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4, e5, restElements));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Iterable<Byte> elements, int expectedSize) {
        ImmutableLHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Iterable)elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, int expectedSize) {
        ImmutableLHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, int expectedSize) {
        ImmutableLHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, Iterable<Byte> elems4, int expectedSize) {
        ImmutableLHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, Iterable<Byte> elems4, Iterable<Byte> elems5, int expectedSize) {
        ImmutableLHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Iterable<Byte> elements) {
        ImmutableLHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Iterable)elements));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2) {
        ImmutableLHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3) {
        ImmutableLHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, Iterable<Byte> elems4) {
        ImmutableLHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, Iterable<Byte> elems4, Iterable<Byte> elems5) {
        ImmutableLHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Iterator<Byte> elements) {
        ImmutableLHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Iterator)elements));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Iterator<Byte> elements, int expectedSize) {
        ImmutableLHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Iterator)elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Consumer<ByteConsumer> elementsSupplier) {
        ImmutableLHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Consumer)elementsSupplier));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Consumer<ByteConsumer> elementsSupplier, int expectedSize) {
        ImmutableLHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteLHash)this.newUpdatableSet((Consumer)elementsSupplier, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(byte[] elements) {
        ImmutableLHashByteSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(byte[] elements, int expectedSize) {
        ImmutableLHashByteSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Byte[] elements) {
        ImmutableLHashByteSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Byte[] elements, int expectedSize) {
        ImmutableLHashByteSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSetOf(byte e1) {
        ImmutableLHashByteSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSetOf(byte e1, byte e2) {
        ImmutableLHashByteSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSetOf(byte e1, byte e2, byte e3) {
        ImmutableLHashByteSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSetOf(byte e1, byte e2, byte e3, byte e4) {
        ImmutableLHashByteSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSetOf(byte e1, byte e2, byte e3, byte e4, byte e5, byte ... restElements) {
        ImmutableLHashByteSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4, e5, restElements));
        return set;
    }
}

