/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.Equivalence;
import com.koloboke.collect.LongCollection;
import com.koloboke.collect.LongCursor;
import com.koloboke.collect.LongIterator;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractLongValueView;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.CommonObjLongMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.InternalObjLongMapOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.ImmutableQHashSeparateKVObjLongMapSO;
import com.koloboke.collect.impl.hash.ObjHash;
import com.koloboke.collect.impl.hash.SeparateKVObjLongQHash;
import com.koloboke.collect.map.ObjLongCursor;
import com.koloboke.collect.set.LongSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.ObjLongPredicate;
import com.koloboke.function.ObjLongToLongFunction;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.function.ObjLongConsumer;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import javax.annotation.Nonnull;

public class ImmutableQHashSeparateKVObjLongMapGO<K>
extends ImmutableQHashSeparateKVObjLongMapSO<K> {
    @Override
    final void copy(SeparateKVObjLongQHash hash) {
        int hashMC = hash.modCount();
        super.copy(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVObjLongQHash hash) {
        int hashMC = hash.modCount();
        super.move(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public long defaultValue() {
        return 0L;
    }

    public boolean containsEntry(Object key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public Long get(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public long getLong(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    public Long getOrDefault(Object key, Long defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public long getOrDefault(Object key, long defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super K, ? super Long> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            action.accept(key, vals[i]);
        }
    }

    @Override
    public void forEach(ObjLongConsumer<? super K> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            action.accept(key, vals[i]);
        }
    }

    @Override
    public boolean forEachWhile(ObjLongPredicate<? super K> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE || predicate.test(key, vals[i])) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public ObjLongCursor<K> cursor() {
        return new NoRemovedMapCursor();
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonObjLongMapOps.containsAllEntries((InternalObjLongMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalObjLongMapOps<?> m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalObjLongMapOps<? super K> m) {
        if (this.isEmpty()) {
            return;
        }
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            m.justPut(key, vals[i]);
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<K, Long>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public LongCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            long val = vals[i];
            hashCode += this.nullableKeyHashCode(key) ^ (int)(val ^ val >>> 32);
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            sb.append(' ');
            sb.append(key != this ? key : "(this Map)");
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    public Long put(K key, Long value) {
        throw new UnsupportedOperationException();
    }

    public long put(K key, long value) {
        throw new UnsupportedOperationException();
    }

    public Long putIfAbsent(K key, Long value) {
        throw new UnsupportedOperationException();
    }

    public long putIfAbsent(K key, long value) {
        throw new UnsupportedOperationException();
    }

    public void justPut(K key, long value) {
        throw new UnsupportedOperationException();
    }

    public Long compute(K key, BiFunction<? super K, ? super Long, ? extends Long> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    Long computeNullKey(BiFunction<? super K, ? super Long, ? extends Long> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public long compute(K key, ObjLongToLongFunction<? super K> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    long computeNullKey(ObjLongToLongFunction<? super K> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Long computeIfAbsent(K key, Function<? super K, ? extends Long> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    Long computeIfAbsentNullKey(Function<? super K, ? extends Long> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public long computeIfAbsent(K key, ToLongFunction<? super K> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    long computeIfAbsentNullKey(ToLongFunction<? super K> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Long computeIfPresent(K key, BiFunction<? super K, ? super Long, ? extends Long> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public long computeIfPresent(K key, ObjLongToLongFunction<? super K> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Long merge(K key, Long value, BiFunction<? super Long, ? super Long, ? extends Long> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    Long mergeNullKey(Long value, BiFunction<? super Long, ? super Long, ? extends Long> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public long merge(K key, long value, LongBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    long mergeNullKey(long value, LongBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public long addValue(K key, long value) {
        throw new UnsupportedOperationException();
    }

    long addValueNullKey(long value) {
        throw new UnsupportedOperationException();
    }

    public long addValue(K key, long addition, long initialValue) {
        throw new UnsupportedOperationException();
    }

    long addValueWithInitialNullKey(long addition, long initialValue) {
        throw new UnsupportedOperationException();
    }

    public void putAll(@Nonnull Map<? extends K, ? extends Long> m) {
        CommonObjLongMapOps.putAll((InternalObjLongMapOps)this, m);
    }

    public Long replace(K key, Long value) {
        throw new UnsupportedOperationException();
    }

    public long replace(K key, long value) {
        throw new UnsupportedOperationException();
    }

    public boolean replace(K key, Long oldValue, Long newValue) {
        return this.replace(key, (long)oldValue, (long)newValue);
    }

    public boolean replace(K key, long oldValue, long newValue) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(BiFunction<? super K, ? super Long, ? extends Long> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(ObjLongToLongFunction<? super K> function) {
        throw new UnsupportedOperationException();
    }

    public Long remove(Object key) {
        throw new UnsupportedOperationException();
    }

    Long removeNullKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(Object key) {
        throw new UnsupportedOperationException();
    }

    boolean justRemoveNullKey() {
        throw new UnsupportedOperationException();
    }

    public long removeAsLong(Object key) {
        throw new UnsupportedOperationException();
    }

    long removeAsLongNullKey() {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        return this.remove(key, (Long)value);
    }

    public boolean remove(Object key, long value) {
        throw new UnsupportedOperationException();
    }

    boolean removeEntryNullKey(long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(ObjLongPredicate<? super K> filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements ObjLongCursor<K> {
        final Object[] keys;
        final long[] vals;
        int index;
        Object curKey;
        long curValue;

        NoRemovedMapCursor() {
            this.keys = ImmutableQHashSeparateKVObjLongMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVObjLongMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(ObjLongConsumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.keys;
            long[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public K key() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public long value() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(long value) {
            if (this.curKey == ObjHash.FREE) {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            Object[] keys = this.keys;
            for (int i = this.index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = ObjHash.FREE;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements LongCursor {
        final Object[] keys;
        final long[] vals;
        int index;
        Object curKey;
        long curValue;

        NoRemovedValueCursor() {
            this.keys = ImmutableQHashSeparateKVObjLongMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVObjLongMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.keys;
            long[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public long elem() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            Object[] keys = this.keys;
            for (int i = this.index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = ObjHash.FREE;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements LongIterator {
        final Object[] keys;
        final long[] vals;
        int nextIndex;
        long next;

        NoRemovedValueIterator() {
            this.keys = ImmutableQHashSeparateKVObjLongMapGO.this.set;
            Object[] keys = ImmutableQHashSeparateKVObjLongMapGO.this.set;
            this.vals = ImmutableQHashSeparateKVObjLongMapGO.this.values;
            long[] vals = ImmutableQHashSeparateKVObjLongMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == ObjHash.FREE) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public long nextLong() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                Object[] keys = this.keys;
                long prev = this.next;
                while (--nextI >= 0) {
                    if (keys[nextI] == ObjHash.FREE) continue;
                    this.next = this.vals[nextI];
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Long> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.keys;
            long[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept((Long)vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(LongConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.keys;
            long[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Long next() {
            return this.nextLong();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<K, Long>> {
        final Object[] keys;
        final long[] vals;
        int index;
        Object curKey;
        long curValue;

        NoRemovedEntryCursor() {
            this.keys = ImmutableQHashSeparateKVObjLongMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVObjLongMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super Map.Entry<K, Long>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.keys;
            long[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept((Map.Entry)((Object)new ImmutableEntry(key, vals[i])));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public Map.Entry<K, Long> elem() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            Object[] keys = this.keys;
            for (int i = this.index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = ObjHash.FREE;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<K, Long>> {
        final Object[] keys;
        final long[] vals;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.keys = ImmutableQHashSeparateKVObjLongMapGO.this.set;
            Object[] keys = ImmutableQHashSeparateKVObjLongMapGO.this.set;
            this.vals = ImmutableQHashSeparateKVObjLongMapGO.this.values;
            long[] vals = ImmutableQHashSeparateKVObjLongMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                Object key = keys[nextI];
                if (key == ObjHash.FREE) continue;
                this.next = new ImmutableEntry(key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<K, Long>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.keys;
            long[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept((Map.Entry)((Object)new ImmutableEntry(key, vals[i])));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<K, Long> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                Object[] keys = this.keys;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    Object key = keys[nextI];
                    if (key == ObjHash.FREE) continue;
                    this.next = new ImmutableEntry(key, this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractLongValueView {
        ValueView() {
        }

        public int size() {
            return ImmutableQHashSeparateKVObjLongMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableQHashSeparateKVObjLongMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return ImmutableQHashSeparateKVObjLongMapGO.this.containsValue(o);
        }

        public boolean contains(long v) {
            return ImmutableQHashSeparateKVObjLongMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Long> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            Object[] keys = ImmutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVObjLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept((Long)vals[i]);
            }
        }

        public void forEach(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            Object[] keys = ImmutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVObjLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(vals[i]);
            }
        }

        public boolean forEachWhile(LongPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            Object[] keys = ImmutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVObjLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        public boolean allContainingIn(LongCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            Object[] keys = ImmutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVObjLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(LongCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            Object[] keys = ImmutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVObjLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= c.add(vals[i]);
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(LongSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            Object[] keys = ImmutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVObjLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= s.removeLong(vals[i]);
            }
            return changed;
        }

        @Nonnull
        public LongIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public LongCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            Object[] keys = ImmutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVObjLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            Object[] keys = ImmutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVObjLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public long[] toLongArray() {
            int size = this.size();
            long[] result = new long[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            Object[] keys = ImmutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVObjLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        public long[] toArray(long[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new long[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0L;
                }
                return a;
            }
            int resultIndex = 0;
            Object[] keys = ImmutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVObjLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0L;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            Object[] keys = ImmutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVObjLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeLong((Long)o);
        }

        public boolean removeLong(long v) {
            return ImmutableQHashSeparateKVObjLongMapGO.this.removeValue(v);
        }

        public void clear() {
            ImmutableQHashSeparateKVObjLongMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Long> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(LongPredicate filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends ObjLongEntry {
        private K key;
        private long value;

        ReusableEntry() {
        }

        ReusableEntry with(K key, long value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends ObjLongEntry {
        private final K key;
        private final long value;

        ImmutableEntry(K key, long value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    abstract class ObjLongEntry
    extends AbstractEntry<K, Long> {
        ObjLongEntry() {
        }

        abstract K key();

        public final K getKey() {
            return this.key();
        }

        abstract long value();

        public final Long getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                Object k2 = e2.getKey();
                long v2 = (Long)e2.getValue();
                return ImmutableQHashSeparateKVObjLongMapGO.this.nullableKeyEquals(k2, this.key()) && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return ImmutableQHashSeparateKVObjLongMapGO.this.nullableKeyHashCode(this.key()) ^ Primitives.hashCode((long)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<K, Long>>
    implements HashObjSet<Map.Entry<K, Long>>,
    InternalObjCollectionOps<Map.Entry<K, Long>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<K, Long>> equivalence() {
            return Equivalence.entryEquivalence(ImmutableQHashSeparateKVObjLongMapGO.this.keyEquivalence(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableQHashSeparateKVObjLongMapGO.this.hashConfig();
        }

        public int size() {
            return ImmutableQHashSeparateKVObjLongMapGO.this.size;
        }

        public double currentLoad() {
            return ImmutableQHashSeparateKVObjLongMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableQHashSeparateKVObjLongMapGO.this.containsEntry(e.getKey(), (Long)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            Object[] keys = ImmutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVObjLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                result[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            Object[] keys = ImmutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVObjLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                a[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<K, Long>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            Object[] keys = ImmutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVObjLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept((Map.Entry)((Object)new ImmutableEntry(key, vals[i])));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<K, Long>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            Object[] keys = ImmutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVObjLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || predicate.test((Map.Entry)((Object)new ImmutableEntry(key, vals[i])))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<K, Long>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<K, Long>> cursor() {
            return new NoRemovedEntryCursor();
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            Object[] keys = ImmutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVObjLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            Object[] keys = ImmutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVObjLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<K, Long>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            Object[] keys = ImmutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVObjLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                changed |= c.add((Object)new ImmutableEntry(key, vals[i]));
            }
            return changed;
        }

        public int hashCode() {
            return ImmutableQHashSeparateKVObjLongMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            Object[] keys = ImmutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVObjLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                sb.append(' ');
                sb.append(key != this ? key : "(this Collection)");
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableQHashSeparateKVObjLongMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                long value = (Long)e.getValue();
                return ImmutableQHashSeparateKVObjLongMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<K, Long>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

