/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.CharCollection;
import com.koloboke.collect.CharCursor;
import com.koloboke.collect.CharIterator;
import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractCharValueView;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.CommonShortCharMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.InternalShortCharMapOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.ImmutableQHashParallelKVShortCharMapSO;
import com.koloboke.collect.impl.hash.ParallelKVShortCharQHash;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.map.ShortCharCursor;
import com.koloboke.collect.set.CharSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.CharBinaryOperator;
import com.koloboke.function.CharConsumer;
import com.koloboke.function.CharPredicate;
import com.koloboke.function.ShortCharConsumer;
import com.koloboke.function.ShortCharPredicate;
import com.koloboke.function.ShortCharToCharFunction;
import com.koloboke.function.ShortToCharFunction;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class ImmutableQHashParallelKVShortCharMapGO
extends ImmutableQHashParallelKVShortCharMapSO {
    final void copy(ParallelKVShortCharQHash hash) {
        int hashMC = hash.modCount();
        super.copy(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVShortCharQHash hash) {
        int hashMC = hash.modCount();
        super.move(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public char defaultValue() {
        return '\u0000';
    }

    public boolean containsEntry(short key, char value) {
        short free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix((short)key) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == key) {
                return (char)(entry >>> 16) == value;
            }
            if (cur == free) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (short)(entry = tab[bIndex])) == key) {
                    return (char)(entry >>> 16) == value;
                }
                if (cur == free) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (short)(entry = tab[fIndex])) == key) {
                    return (char)(entry >>> 16) == value;
                }
                if (cur == free) {
                    return false;
                }
                step += 2;
            }
        }
        return false;
    }

    public Character get(Object key) {
        short free;
        short k = (Short)key;
        if (k != (free = this.freeValue)) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix((short)k) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == k) {
                return Character.valueOf((char)(entry >>> 16));
            }
            if (cur == free) {
                return null;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (short)(entry = tab[bIndex])) == k) {
                    return Character.valueOf((char)(entry >>> 16));
                }
                if (cur == free) {
                    return null;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (short)(entry = tab[fIndex])) == k) {
                    return Character.valueOf((char)(entry >>> 16));
                }
                if (cur == free) {
                    return null;
                }
                step += 2;
            }
        }
        return null;
    }

    public char get(short key) {
        short free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix((short)key) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == key) {
                return (char)(entry >>> 16);
            }
            if (cur == free) {
                return this.defaultValue();
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (short)(entry = tab[bIndex])) == key) {
                    return (char)(entry >>> 16);
                }
                if (cur == free) {
                    return this.defaultValue();
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (short)(entry = tab[fIndex])) == key) {
                    return (char)(entry >>> 16);
                }
                if (cur == free) {
                    return this.defaultValue();
                }
                step += 2;
            }
        }
        return this.defaultValue();
    }

    public Character getOrDefault(Object key, Character defaultValue) {
        short free;
        short k = (Short)key;
        if (k != (free = this.freeValue)) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix((short)k) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == k) {
                return Character.valueOf((char)(entry >>> 16));
            }
            if (cur == free) {
                return defaultValue;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (short)(entry = tab[bIndex])) == k) {
                    return Character.valueOf((char)(entry >>> 16));
                }
                if (cur == free) {
                    return defaultValue;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (short)(entry = tab[fIndex])) == k) {
                    return Character.valueOf((char)(entry >>> 16));
                }
                if (cur == free) {
                    return defaultValue;
                }
                step += 2;
            }
        }
        return defaultValue;
    }

    public char getOrDefault(short key, char defaultValue) {
        short free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix((short)key) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == key) {
                return (char)(entry >>> 16);
            }
            if (cur == free) {
                return defaultValue;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (short)(entry = tab[bIndex])) == key) {
                    return (char)(entry >>> 16);
                }
                if (cur == free) {
                    return defaultValue;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (short)(entry = tab[fIndex])) == key) {
                    return (char)(entry >>> 16);
                }
                if (cur == free) {
                    return defaultValue;
                }
                step += 2;
            }
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Short, ? super Character> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            action.accept((Short)key, Character.valueOf((char)(entry >>> 16)));
        }
    }

    public void forEach(ShortCharConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            action.accept(key, (char)(entry >>> 16));
        }
    }

    public boolean forEachWhile(ShortCharPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free || predicate.test(key, (char)(entry >>> 16))) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public ShortCharCursor cursor() {
        return new NoRemovedMapCursor();
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonShortCharMapOps.containsAllEntries((InternalShortCharMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalShortCharMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free || m.containsEntry(key, (char)(entry >>> 16))) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalShortCharMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            m.justPut(key, (char)(entry >>> 16));
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Short, Character>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public CharCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            hashCode += key ^ (char)(entry >>> 16);
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append((char)(entry >>> 16));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    public Character put(Short key, Character value) {
        throw new UnsupportedOperationException();
    }

    public char put(short key, char value) {
        throw new UnsupportedOperationException();
    }

    public Character putIfAbsent(Short key, Character value) {
        throw new UnsupportedOperationException();
    }

    public char putIfAbsent(short key, char value) {
        throw new UnsupportedOperationException();
    }

    public void justPut(short key, char value) {
        throw new UnsupportedOperationException();
    }

    public Character compute(Short key, BiFunction<? super Short, ? super Character, ? extends Character> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public char compute(short key, ShortCharToCharFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Character computeIfAbsent(Short key, Function<? super Short, ? extends Character> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public char computeIfAbsent(short key, ShortToCharFunction mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Character computeIfPresent(Short key, BiFunction<? super Short, ? super Character, ? extends Character> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public char computeIfPresent(short key, ShortCharToCharFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Character merge(Short key, Character value, BiFunction<? super Character, ? super Character, ? extends Character> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public char merge(short key, char value, CharBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public char addValue(short key, char value) {
        throw new UnsupportedOperationException();
    }

    public char addValue(short key, char addition, char initialValue) {
        throw new UnsupportedOperationException();
    }

    public void putAll(@Nonnull Map<? extends Short, ? extends Character> m) {
        CommonShortCharMapOps.putAll((InternalShortCharMapOps)this, m);
    }

    public Character replace(Short key, Character value) {
        throw new UnsupportedOperationException();
    }

    public char replace(short key, char value) {
        throw new UnsupportedOperationException();
    }

    public boolean replace(Short key, Character oldValue, Character newValue) {
        return this.replace((short)key, oldValue.charValue(), newValue.charValue());
    }

    public boolean replace(short key, char oldValue, char newValue) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(BiFunction<? super Short, ? super Character, ? extends Character> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(ShortCharToCharFunction function) {
        throw new UnsupportedOperationException();
    }

    public Character remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(short key) {
        throw new UnsupportedOperationException();
    }

    public char remove(short key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Short)key, ((Character)value).charValue());
    }

    public boolean remove(short key, char value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(ShortCharPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements ShortCharCursor {
        final int[] tab;
        final short free;
        int index;
        short curKey;
        char curValue;

        NoRemovedMapCursor() {
            short free;
            this.tab = ImmutableQHashParallelKVShortCharMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = ImmutableQHashParallelKVShortCharMapGO.this.freeValue);
        }

        public void forEachForward(ShortCharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int[] tab = this.tab;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                action.accept(key, (char)(entry >>> 16));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short key() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public char value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(char value) {
            if (this.curKey == this.free) {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_VALUE_OFFSET + ((long)this.index << 2), value);
        }

        public boolean moveNext() {
            int[] tab = this.tab;
            short free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (char)(entry >>> 16);
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements CharCursor {
        final int[] tab;
        final short free;
        int index;
        short curKey;
        char curValue;

        NoRemovedValueCursor() {
            short free;
            this.tab = ImmutableQHashParallelKVShortCharMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = ImmutableQHashParallelKVShortCharMapGO.this.freeValue);
        }

        public void forEachForward(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int[] tab = this.tab;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                action.accept((char)(entry >>> 16));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            int[] tab = this.tab;
            short free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (char)(entry >>> 16);
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements CharIterator {
        final int[] tab;
        final short free;
        int nextIndex;
        char next;

        NoRemovedValueIterator() {
            this.tab = ImmutableQHashParallelKVShortCharMapGO.this.table;
            int[] tab = ImmutableQHashParallelKVShortCharMapGO.this.table;
            short free = this.free = ImmutableQHashParallelKVShortCharMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                if ((short)entry == free) continue;
                this.next = (char)(entry >>> 16);
                break;
            }
            this.nextIndex = nextI;
        }

        public char nextChar() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int[] tab = this.tab;
                short free = this.free;
                char prev = this.next;
                while (--nextI >= 0) {
                    int entry = tab[nextI];
                    if ((short)entry == free) continue;
                    this.next = (char)(entry >>> 16);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Character> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int[] tab = this.tab;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                action.accept(Character.valueOf((char)(entry >>> 16)));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(CharConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int[] tab = this.tab;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                action.accept((char)(entry >>> 16));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Character next() {
            return Character.valueOf(this.nextChar());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Short, Character>> {
        final int[] tab;
        final short free;
        int index;
        short curKey;
        char curValue;

        NoRemovedEntryCursor() {
            short free;
            this.tab = ImmutableQHashParallelKVShortCharMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = ImmutableQHashParallelKVShortCharMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Short, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int[] tab = this.tab;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Short, Character>)((Object)new ImmutableEntry(key, (char)(entry >>> 16))));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Short, Character> elem() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            int[] tab = this.tab;
            short free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (char)(entry >>> 16);
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Short, Character>> {
        final int[] tab;
        final short free;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.tab = ImmutableQHashParallelKVShortCharMapGO.this.table;
            int[] tab = ImmutableQHashParallelKVShortCharMapGO.this.table;
            short free = this.free = ImmutableQHashParallelKVShortCharMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                short key = (short)entry;
                if (key == free) continue;
                this.next = new ImmutableEntry(key, (char)(entry >>> 16));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Short, Character>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int[] tab = this.tab;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Short, Character>)((Object)new ImmutableEntry(key, (char)(entry >>> 16))));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Short, Character> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int[] tab = this.tab;
                short free = this.free;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    int entry = tab[nextI];
                    short key = (short)entry;
                    if (key == free) continue;
                    this.next = new ImmutableEntry(key, (char)(entry >>> 16));
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractCharValueView {
        ValueView() {
        }

        public int size() {
            return ImmutableQHashParallelKVShortCharMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableQHashParallelKVShortCharMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return ImmutableQHashParallelKVShortCharMapGO.this.containsValue(o);
        }

        public boolean contains(char v) {
            return ImmutableQHashParallelKVShortCharMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Character> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            short free = ImmutableQHashParallelKVShortCharMapGO.this.freeValue;
            int[] tab = ImmutableQHashParallelKVShortCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                action.accept(Character.valueOf((char)(entry >>> 16)));
            }
        }

        public void forEach(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            short free = ImmutableQHashParallelKVShortCharMapGO.this.freeValue;
            int[] tab = ImmutableQHashParallelKVShortCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                action.accept((char)(entry >>> 16));
            }
        }

        public boolean forEachWhile(CharPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            short free = ImmutableQHashParallelKVShortCharMapGO.this.freeValue;
            int[] tab = ImmutableQHashParallelKVShortCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free || predicate.test((char)(entry >>> 16))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        public boolean allContainingIn(CharCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            short free = ImmutableQHashParallelKVShortCharMapGO.this.freeValue;
            int[] tab = ImmutableQHashParallelKVShortCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free || c.contains((char)(entry >>> 16))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(CharCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            short free = ImmutableQHashParallelKVShortCharMapGO.this.freeValue;
            int[] tab = ImmutableQHashParallelKVShortCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                changed |= c.add((char)(entry >>> 16));
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(CharSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            short free = ImmutableQHashParallelKVShortCharMapGO.this.freeValue;
            int[] tab = ImmutableQHashParallelKVShortCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                changed |= s.removeChar((char)(entry >>> 16));
            }
            return changed;
        }

        @Nonnull
        public CharIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public CharCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            short free = ImmutableQHashParallelKVShortCharMapGO.this.freeValue;
            int[] tab = ImmutableQHashParallelKVShortCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                result[resultIndex++] = Character.valueOf((char)(entry >>> 16));
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            short free = ImmutableQHashParallelKVShortCharMapGO.this.freeValue;
            int[] tab = ImmutableQHashParallelKVShortCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                a[resultIndex++] = Character.valueOf((char)(entry >>> 16));
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public char[] toCharArray() {
            int size = this.size();
            char[] result = new char[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            short free = ImmutableQHashParallelKVShortCharMapGO.this.freeValue;
            int[] tab = ImmutableQHashParallelKVShortCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                result[resultIndex++] = (char)(entry >>> 16);
            }
            return result;
        }

        public char[] toArray(char[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new char[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = '\u0000';
                }
                return a;
            }
            int resultIndex = 0;
            short free = ImmutableQHashParallelKVShortCharMapGO.this.freeValue;
            int[] tab = ImmutableQHashParallelKVShortCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                a[resultIndex++] = (char)(entry >>> 16);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = '\u0000';
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            short free = ImmutableQHashParallelKVShortCharMapGO.this.freeValue;
            int[] tab = ImmutableQHashParallelKVShortCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                sb.append(' ').append((char)(entry >>> 16)).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeChar(((Character)o).charValue());
        }

        public boolean removeChar(char v) {
            return ImmutableQHashParallelKVShortCharMapGO.this.removeValue(v);
        }

        public void clear() {
            ImmutableQHashParallelKVShortCharMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Character> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(CharPredicate filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends ShortCharEntry {
        private short key;
        private char value;

        ReusableEntry() {
        }

        ReusableEntry with(short key, char value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public short key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends ShortCharEntry {
        private final short key;
        private final char value;

        ImmutableEntry(short key, char value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public short key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }
    }

    abstract class ShortCharEntry
    extends AbstractEntry<Short, Character> {
        ShortCharEntry() {
        }

        abstract short key();

        public final Short getKey() {
            return this.key();
        }

        abstract char value();

        public final Character getValue() {
            return Character.valueOf(this.value());
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                short k2 = (Short)e2.getKey();
                char v2 = ((Character)e2.getValue()).charValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((short)this.key()) ^ Primitives.hashCode((char)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Short, Character>>
    implements HashObjSet<Map.Entry<Short, Character>>,
    InternalObjCollectionOps<Map.Entry<Short, Character>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Short, Character>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableQHashParallelKVShortCharMapGO.this.hashConfig();
        }

        public int size() {
            return ImmutableQHashParallelKVShortCharMapGO.this.size;
        }

        public double currentLoad() {
            return ImmutableQHashParallelKVShortCharMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableQHashParallelKVShortCharMapGO.this.containsEntry((Short)e.getKey(), ((Character)e.getValue()).charValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            short free = ImmutableQHashParallelKVShortCharMapGO.this.freeValue;
            int[] tab = ImmutableQHashParallelKVShortCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                result[resultIndex++] = new ImmutableEntry(key, (char)(entry >>> 16));
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            short free = ImmutableQHashParallelKVShortCharMapGO.this.freeValue;
            int[] tab = ImmutableQHashParallelKVShortCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                a[resultIndex++] = new ImmutableEntry(key, (char)(entry >>> 16));
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Short, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            short free = ImmutableQHashParallelKVShortCharMapGO.this.freeValue;
            int[] tab = ImmutableQHashParallelKVShortCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Short, Character>)((Object)new ImmutableEntry(key, (char)(entry >>> 16))));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Short, Character>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            short free = ImmutableQHashParallelKVShortCharMapGO.this.freeValue;
            int[] tab = ImmutableQHashParallelKVShortCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || predicate.test((Map.Entry<Short, Character>)((Object)new ImmutableEntry(key, (char)(entry >>> 16))))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Short, Character>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Short, Character>> cursor() {
            return new NoRemovedEntryCursor();
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            short free = ImmutableQHashParallelKVShortCharMapGO.this.freeValue;
            int[] tab = ImmutableQHashParallelKVShortCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || c.contains((Object)e.with(key, (char)(entry >>> 16)))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            short free = ImmutableQHashParallelKVShortCharMapGO.this.freeValue;
            int[] tab = ImmutableQHashParallelKVShortCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, (char)(entry >>> 16)));
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Short, Character>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            short free = ImmutableQHashParallelKVShortCharMapGO.this.freeValue;
            int[] tab = ImmutableQHashParallelKVShortCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                changed |= c.add((Object)new ImmutableEntry(key, (char)(entry >>> 16)));
            }
            return changed;
        }

        public int hashCode() {
            return ImmutableQHashParallelKVShortCharMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            short free = ImmutableQHashParallelKVShortCharMapGO.this.freeValue;
            int[] tab = ImmutableQHashParallelKVShortCharMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append((char)(entry >>> 16));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableQHashParallelKVShortCharMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                short key = (Short)e.getKey();
                char value = ((Character)e.getValue()).charValue();
                return ImmutableQHashParallelKVShortCharMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Short, Character>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

