/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.Equivalence;
import com.koloboke.collect.IntCollection;
import com.koloboke.collect.IntCursor;
import com.koloboke.collect.IntIterator;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractIntValueView;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonFloatIntMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalFloatIntMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.ImmutableQHashParallelKVFloatIntMapSO;
import com.koloboke.collect.impl.hash.ParallelKVFloatIntQHash;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.map.FloatIntCursor;
import com.koloboke.collect.set.IntSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.FloatIntConsumer;
import com.koloboke.function.FloatIntPredicate;
import com.koloboke.function.FloatIntToIntFunction;
import com.koloboke.function.FloatToIntFunction;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class ImmutableQHashParallelKVFloatIntMapGO
extends ImmutableQHashParallelKVFloatIntMapSO {
    final void copy(ParallelKVFloatIntQHash hash) {
        int hashMC = hash.modCount();
        super.copy(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVFloatIntQHash hash) {
        int hashMC = hash.modCount();
        super.move(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public int defaultValue() {
        return 0;
    }

    public boolean containsEntry(float key, int value) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32) == value;
        }
        if (cur == 0x7FFFFFFE) {
            return false;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == k) {
                return (int)(entry >>> 32) == value;
            }
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == k) {
                return (int)(entry >>> 32) == value;
            }
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            step += 2;
        }
    }

    public boolean containsEntry(int key, int value) {
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix((int)key) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == key) {
            return (int)(entry >>> 32) == value;
        }
        if (cur == 0x7FFFFFFE) {
            return false;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == key) {
                return (int)(entry >>> 32) == value;
            }
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == key) {
                return (int)(entry >>> 32) == value;
            }
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            step += 2;
        }
    }

    public Integer get(Object key) {
        int k = Float.floatToIntBits(((Float)key).floatValue());
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        if (cur == 0x7FFFFFFE) {
            return null;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == k) {
                return (int)(entry >>> 32);
            }
            if (cur == 0x7FFFFFFE) {
                return null;
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == k) {
                return (int)(entry >>> 32);
            }
            if (cur == 0x7FFFFFFE) {
                return null;
            }
            step += 2;
        }
    }

    public int get(float key) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        if (cur == 0x7FFFFFFE) {
            return this.defaultValue();
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == k) {
                return (int)(entry >>> 32);
            }
            if (cur == 0x7FFFFFFE) {
                return this.defaultValue();
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == k) {
                return (int)(entry >>> 32);
            }
            if (cur == 0x7FFFFFFE) {
                return this.defaultValue();
            }
            step += 2;
        }
    }

    public Integer getOrDefault(Object key, Integer defaultValue) {
        int k = Float.floatToIntBits(((Float)key).floatValue());
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        if (cur == 0x7FFFFFFE) {
            return defaultValue;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == k) {
                return (int)(entry >>> 32);
            }
            if (cur == 0x7FFFFFFE) {
                return defaultValue;
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == k) {
                return (int)(entry >>> 32);
            }
            if (cur == 0x7FFFFFFE) {
                return defaultValue;
            }
            step += 2;
        }
    }

    public int getOrDefault(float key, int defaultValue) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix((int)k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        if (cur == 0x7FFFFFFE) {
            return defaultValue;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == k) {
                return (int)(entry >>> 32);
            }
            if (cur == 0x7FFFFFFE) {
                return defaultValue;
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == k) {
                return (int)(entry >>> 32);
            }
            if (cur == 0x7FFFFFFE) {
                return defaultValue;
            }
            step += 2;
        }
    }

    public void forEach(BiConsumer<? super Float, ? super Integer> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            action.accept(Float.valueOf(Float.intBitsToFloat(key)), (Integer)((int)(entry >>> 32)));
        }
    }

    public void forEach(FloatIntConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            action.accept(Float.intBitsToFloat(key), (int)(entry >>> 32));
        }
    }

    public boolean forEachWhile(FloatIntPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE || predicate.test(Float.intBitsToFloat(key), (int)(entry >>> 32))) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public FloatIntCursor cursor() {
        return new NoRemovedMapCursor();
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonFloatIntMapOps.containsAllEntries((InternalFloatIntMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalFloatIntMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE || m.containsEntry(key, (int)(entry >>> 32))) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalFloatIntMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            m.justPut(key, (int)(entry >>> 32));
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Float, Integer>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public IntCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            hashCode += key ^ (int)(entry >>> 32);
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            sb.append(' ');
            sb.append(Float.intBitsToFloat(key));
            sb.append('=');
            sb.append((int)(entry >>> 32));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    public Integer put(Float key, Integer value) {
        throw new UnsupportedOperationException();
    }

    public int put(float key, int value) {
        throw new UnsupportedOperationException();
    }

    public Integer putIfAbsent(Float key, Integer value) {
        throw new UnsupportedOperationException();
    }

    public int putIfAbsent(float key, int value) {
        throw new UnsupportedOperationException();
    }

    public void justPut(float key, int value) {
        throw new UnsupportedOperationException();
    }

    public void justPut(int key, int value) {
        throw new UnsupportedOperationException();
    }

    public Integer compute(Float key, BiFunction<? super Float, ? super Integer, ? extends Integer> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int compute(float key, FloatIntToIntFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Integer computeIfAbsent(Float key, Function<? super Float, ? extends Integer> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int computeIfAbsent(float key, FloatToIntFunction mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Integer computeIfPresent(Float key, BiFunction<? super Float, ? super Integer, ? extends Integer> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int computeIfPresent(float key, FloatIntToIntFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Integer merge(Float key, Integer value, BiFunction<? super Integer, ? super Integer, ? extends Integer> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int merge(float key, int value, IntBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int addValue(float key, int value) {
        throw new UnsupportedOperationException();
    }

    public int addValue(float key, int addition, int initialValue) {
        throw new UnsupportedOperationException();
    }

    public void putAll(@Nonnull Map<? extends Float, ? extends Integer> m) {
        CommonFloatIntMapOps.putAll((InternalFloatIntMapOps)this, m);
    }

    public Integer replace(Float key, Integer value) {
        throw new UnsupportedOperationException();
    }

    public int replace(float key, int value) {
        throw new UnsupportedOperationException();
    }

    public boolean replace(Float key, Integer oldValue, Integer newValue) {
        return this.replace(key.floatValue(), (int)oldValue, (int)newValue);
    }

    public boolean replace(float key, int oldValue, int newValue) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(BiFunction<? super Float, ? super Integer, ? extends Integer> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(FloatIntToIntFunction function) {
        throw new UnsupportedOperationException();
    }

    public Integer remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(float key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(int key) {
        throw new UnsupportedOperationException();
    }

    public int remove(float key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        return this.remove(((Float)key).floatValue(), (Integer)value);
    }

    public boolean remove(float key, int value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(FloatIntPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements FloatIntCursor {
        final long[] tab;
        int index;
        int curKey;
        int curValue;

        NoRemovedMapCursor() {
            this.tab = ImmutableQHashParallelKVFloatIntMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(FloatIntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat(key), (int)(entry >>> 32));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public float key() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return Float.intBitsToFloat(curKey);
            }
            throw new IllegalStateException();
        }

        public int value() {
            if (this.curKey != 0x7FFFFFFE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(int value) {
            if (this.curKey == 0x7FFFFFFE) {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_VALUE_OFFSET + ((long)this.index << 3), value);
        }

        public boolean moveNext() {
            long[] tab = this.tab;
            for (int i = this.index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (int)(entry >>> 32);
                return true;
            }
            this.curKey = 0x7FFFFFFE;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements IntCursor {
        final long[] tab;
        int index;
        int curKey;
        int curValue;

        NoRemovedValueCursor() {
            this.tab = ImmutableQHashParallelKVFloatIntMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept((int)(entry >>> 32));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public int elem() {
            if (this.curKey != 0x7FFFFFFE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            long[] tab = this.tab;
            for (int i = this.index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (int)(entry >>> 32);
                return true;
            }
            this.curKey = 0x7FFFFFFE;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements IntIterator {
        final long[] tab;
        int nextIndex;
        int next;

        NoRemovedValueIterator() {
            this.tab = ImmutableQHashParallelKVFloatIntMapGO.this.table;
            long[] tab = ImmutableQHashParallelKVFloatIntMapGO.this.table;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                if ((int)entry >= 0x7FFFFFFE) continue;
                this.next = (int)(entry >>> 32);
                break;
            }
            this.nextIndex = nextI;
        }

        public int nextInt() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                long[] tab = this.tab;
                int prev = this.next;
                while (--nextI >= 0) {
                    long entry = tab[nextI];
                    if ((int)entry >= 0x7FFFFFFE) continue;
                    this.next = (int)(entry >>> 32);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Integer> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept((Integer)((int)(entry >>> 32)));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(IntConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept((int)(entry >>> 32));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Integer next() {
            return this.nextInt();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Float, Integer>> {
        final long[] tab;
        int index;
        int curKey;
        int curValue;

        NoRemovedEntryCursor() {
            this.tab = ImmutableQHashParallelKVFloatIntMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(Consumer<? super Map.Entry<Float, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept((Map.Entry<Float, Integer>)((Object)new ImmutableEntry(key, (int)(entry >>> 32))));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public Map.Entry<Float, Integer> elem() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            long[] tab = this.tab;
            for (int i = this.index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (int)(entry >>> 32);
                return true;
            }
            this.curKey = 0x7FFFFFFE;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Float, Integer>> {
        final long[] tab;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.tab = ImmutableQHashParallelKVFloatIntMapGO.this.table;
            long[] tab = ImmutableQHashParallelKVFloatIntMapGO.this.table;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                this.next = new ImmutableEntry(key, (int)(entry >>> 32));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Float, Integer>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept((Map.Entry<Float, Integer>)((Object)new ImmutableEntry(key, (int)(entry >>> 32))));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Float, Integer> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                long[] tab = this.tab;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    long entry = tab[nextI];
                    int key = (int)entry;
                    if (key >= 0x7FFFFFFE) continue;
                    this.next = new ImmutableEntry(key, (int)(entry >>> 32));
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractIntValueView {
        ValueView() {
        }

        public int size() {
            return ImmutableQHashParallelKVFloatIntMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableQHashParallelKVFloatIntMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return ImmutableQHashParallelKVFloatIntMapGO.this.containsValue(o);
        }

        public boolean contains(int v) {
            return ImmutableQHashParallelKVFloatIntMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Integer> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long[] tab = ImmutableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept((Integer)((int)(entry >>> 32)));
            }
        }

        public void forEach(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long[] tab = ImmutableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept((int)(entry >>> 32));
            }
        }

        public boolean forEachWhile(IntPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            long[] tab = ImmutableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE || predicate.test((int)(entry >>> 32))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        public boolean allContainingIn(IntCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            long[] tab = ImmutableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE || c.contains((int)(entry >>> 32))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(IntCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long[] tab = ImmutableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                changed |= c.add((int)(entry >>> 32));
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(IntSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long[] tab = ImmutableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                changed |= s.removeInt((int)(entry >>> 32));
            }
            return changed;
        }

        @Nonnull
        public IntIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public IntCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long[] tab = ImmutableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                result[resultIndex++] = (int)(entry >>> 32);
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            long[] tab = ImmutableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                a[resultIndex++] = (int)(entry >>> 32);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public int[] toIntArray() {
            int size = this.size();
            int[] result = new int[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long[] tab = ImmutableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                result[resultIndex++] = (int)(entry >>> 32);
            }
            return result;
        }

        public int[] toArray(int[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new int[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            long[] tab = ImmutableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                a[resultIndex++] = (int)(entry >>> 32);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            long[] tab = ImmutableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                sb.append(' ').append((int)(entry >>> 32)).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeInt((Integer)o);
        }

        public boolean removeInt(int v) {
            return ImmutableQHashParallelKVFloatIntMapGO.this.removeValue(v);
        }

        public void clear() {
            ImmutableQHashParallelKVFloatIntMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Integer> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(IntPredicate filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends FloatIntEntry {
        private int key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(int key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends FloatIntEntry {
        private final int key;
        private final int value;

        ImmutableEntry(int key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    abstract class FloatIntEntry
    extends AbstractEntry<Float, Integer> {
        FloatIntEntry() {
        }

        abstract int key();

        public final Float getKey() {
            return Float.valueOf(Float.intBitsToFloat(this.key()));
        }

        abstract int value();

        public final Integer getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                int k2 = Float.floatToIntBits(((Float)e2.getKey()).floatValue());
                int v2 = (Integer)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((int)this.key()) ^ Primitives.hashCode((int)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Float, Integer>>
    implements HashObjSet<Map.Entry<Float, Integer>>,
    InternalObjCollectionOps<Map.Entry<Float, Integer>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Float, Integer>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableQHashParallelKVFloatIntMapGO.this.hashConfig();
        }

        public int size() {
            return ImmutableQHashParallelKVFloatIntMapGO.this.size;
        }

        public double currentLoad() {
            return ImmutableQHashParallelKVFloatIntMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableQHashParallelKVFloatIntMapGO.this.containsEntry(((Float)e.getKey()).floatValue(), (int)((Integer)e.getValue()));
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long[] tab = ImmutableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                result[resultIndex++] = new ImmutableEntry(key, (int)(entry >>> 32));
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            long[] tab = ImmutableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                a[resultIndex++] = new ImmutableEntry(key, (int)(entry >>> 32));
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Float, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long[] tab = ImmutableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept((Map.Entry<Float, Integer>)((Object)new ImmutableEntry(key, (int)(entry >>> 32))));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Float, Integer>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            long[] tab = ImmutableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE || predicate.test((Map.Entry<Float, Integer>)((Object)new ImmutableEntry(key, (int)(entry >>> 32))))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Float, Integer>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Float, Integer>> cursor() {
            return new NoRemovedEntryCursor();
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            long[] tab = ImmutableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE || c.contains((Object)e.with(key, (int)(entry >>> 32)))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            long[] tab = ImmutableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                changed |= s.remove((Object)e.with(key, (int)(entry >>> 32)));
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Float, Integer>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long[] tab = ImmutableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                changed |= c.add((Object)new ImmutableEntry(key, (int)(entry >>> 32)));
            }
            return changed;
        }

        public int hashCode() {
            return ImmutableQHashParallelKVFloatIntMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            long[] tab = ImmutableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                sb.append(' ');
                sb.append(Float.intBitsToFloat(key));
                sb.append('=');
                sb.append((int)(entry >>> 32));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableQHashParallelKVFloatIntMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                float key = ((Float)e.getKey()).floatValue();
                int value = (Integer)e.getValue();
                return ImmutableQHashParallelKVFloatIntMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Float, Integer>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

