/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.DoubleCollection;
import com.koloboke.collect.DoubleCursor;
import com.koloboke.collect.DoubleIterator;
import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractDoubleValueView;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonDoubleDoubleMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalDoubleCollectionOps;
import com.koloboke.collect.impl.InternalDoubleDoubleMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.ImmutableQHashParallelKVDoubleDoubleMapSO;
import com.koloboke.collect.impl.hash.ParallelKVDoubleDoubleQHash;
import com.koloboke.collect.map.DoubleDoubleCursor;
import com.koloboke.collect.set.DoubleSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.DoubleDoubleConsumer;
import com.koloboke.function.DoubleDoublePredicate;
import com.koloboke.function.DoubleDoubleToDoubleFunction;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class ImmutableQHashParallelKVDoubleDoubleMapGO
extends ImmutableQHashParallelKVDoubleDoubleMapSO {
    final void copy(ParallelKVDoubleDoubleQHash hash) {
        int hashMC = hash.modCount();
        super.copy(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVDoubleDoubleQHash hash) {
        int hashMC = hash.modCount();
        super.move(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public double defaultValue() {
        return 0.0;
    }

    public boolean containsEntry(double key, double value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.table[index + 1] == Double.doubleToLongBits(value);
        }
        return false;
    }

    public boolean containsEntry(long key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.table[index + 1] == value;
        }
        return false;
    }

    public Double get(Object key) {
        long k = Double.doubleToLongBits((Double)key);
        int index = this.index(k);
        if (index >= 0) {
            return Double.longBitsToDouble(this.table[index + 1]);
        }
        return null;
    }

    public double get(double key) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return Double.longBitsToDouble(this.table[index + 1]);
        }
        return this.defaultValue();
    }

    public Double getOrDefault(Object key, Double defaultValue) {
        long k = Double.doubleToLongBits((Double)key);
        int index = this.index(k);
        if (index >= 0) {
            return Double.longBitsToDouble(this.table[index + 1]);
        }
        return defaultValue;
    }

    public double getOrDefault(double key, double defaultValue) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return Double.longBitsToDouble(this.table[index + 1]);
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Double, ? super Double> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept((Double)Double.longBitsToDouble(key), (Double)Double.longBitsToDouble(tab[i + 1]));
        }
    }

    public void forEach(DoubleDoubleConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept(Double.longBitsToDouble(key), Double.longBitsToDouble(tab[i + 1]));
        }
    }

    public boolean forEachWhile(DoubleDoublePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || predicate.test(Double.longBitsToDouble(key), Double.longBitsToDouble(tab[i + 1]))) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public DoubleDoubleCursor cursor() {
        return new NoRemovedMapCursor();
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonDoubleDoubleMapOps.containsAllEntries((InternalDoubleDoubleMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalDoubleDoubleMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || m.containsEntry(key, tab[i + 1])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalDoubleDoubleMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            m.justPut(key, tab[i + 1]);
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Double, Double>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public DoubleCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            long val = tab[i + 1];
            hashCode += (int)(key ^ key >>> 32) ^ (int)(val ^ val >>> 32);
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            sb.append(' ');
            sb.append(Double.longBitsToDouble(key));
            sb.append('=');
            sb.append(Double.longBitsToDouble(tab[i + 1]));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    public Double put(Double key, Double value) {
        throw new UnsupportedOperationException();
    }

    public double put(double key, double value) {
        throw new UnsupportedOperationException();
    }

    public Double putIfAbsent(Double key, Double value) {
        throw new UnsupportedOperationException();
    }

    public double putIfAbsent(double key, double value) {
        throw new UnsupportedOperationException();
    }

    public void justPut(double key, double value) {
        throw new UnsupportedOperationException();
    }

    public void justPut(long key, long value) {
        throw new UnsupportedOperationException();
    }

    public Double compute(Double key, BiFunction<? super Double, ? super Double, ? extends Double> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public double compute(double key, DoubleDoubleToDoubleFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Double computeIfAbsent(Double key, Function<? super Double, ? extends Double> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public double computeIfAbsent(double key, DoubleUnaryOperator mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Double computeIfPresent(Double key, BiFunction<? super Double, ? super Double, ? extends Double> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public double computeIfPresent(double key, DoubleDoubleToDoubleFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Double merge(Double key, Double value, BiFunction<? super Double, ? super Double, ? extends Double> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public double merge(double key, double value, DoubleBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public double addValue(double key, double value) {
        throw new UnsupportedOperationException();
    }

    public double addValue(double key, double addition, double initialValue) {
        throw new UnsupportedOperationException();
    }

    public void putAll(@Nonnull Map<? extends Double, ? extends Double> m) {
        CommonDoubleDoubleMapOps.putAll((InternalDoubleDoubleMapOps)this, m);
    }

    public Double replace(Double key, Double value) {
        throw new UnsupportedOperationException();
    }

    public double replace(double key, double value) {
        throw new UnsupportedOperationException();
    }

    public boolean replace(Double key, Double oldValue, Double newValue) {
        return this.replace((double)key, (double)oldValue, (double)newValue);
    }

    public boolean replace(double key, double oldValue, double newValue) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(BiFunction<? super Double, ? super Double, ? extends Double> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(DoubleDoubleToDoubleFunction function) {
        throw new UnsupportedOperationException();
    }

    public Double remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(double key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(long key) {
        throw new UnsupportedOperationException();
    }

    public double remove(double key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Double)key, (Double)value);
    }

    public boolean remove(double key, double value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(DoubleDoublePredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements DoubleDoubleCursor {
        final long[] tab;
        int index;
        long curKey;
        long curValue;

        NoRemovedMapCursor() {
            this.tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(DoubleDoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Double.longBitsToDouble(key), Double.longBitsToDouble(tab[i + 1]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public double key() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return Double.longBitsToDouble(curKey);
            }
            throw new IllegalStateException();
        }

        public double value() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(double value) {
            if (this.curKey == 0x7FFFFFFFFFFFFFFEL) {
                throw new IllegalStateException();
            }
            this.tab[this.index + 1] = Double.doubleToLongBits(value);
        }

        public boolean moveNext() {
            long[] tab = this.tab;
            for (int i = this.index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = tab[i + 1];
                return true;
            }
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements DoubleCursor {
        final long[] tab;
        int index;
        long curKey;
        long curValue;

        NoRemovedValueCursor() {
            this.tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Double.longBitsToDouble(tab[i + 1]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public double elem() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            long[] tab = this.tab;
            for (int i = this.index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = tab[i + 1];
                return true;
            }
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements DoubleIterator {
        final long[] tab;
        int nextIndex;
        double next;

        NoRemovedValueIterator() {
            this.tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            long[] tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                if (tab[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = Double.longBitsToDouble(tab[nextI + 1]);
                break;
            }
            this.nextIndex = nextI;
        }

        public double nextDouble() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                long[] tab = this.tab;
                double prev = this.next;
                while ((nextI -= 2) >= 0) {
                    if (tab[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.next = Double.longBitsToDouble(tab[nextI + 1]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Double> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Double)Double.longBitsToDouble(tab[i + 1]));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(DoubleConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Double.longBitsToDouble(tab[i + 1]));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Double next() {
            return this.nextDouble();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Double, Double>> {
        final long[] tab;
        int index;
        long curKey;
        long curValue;

        NoRemovedEntryCursor() {
            this.tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(Consumer<? super Map.Entry<Double, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Map.Entry<Double, Double>)((Object)new ImmutableEntry(key, tab[i + 1])));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public Map.Entry<Double, Double> elem() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            long[] tab = this.tab;
            for (int i = this.index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = tab[i + 1];
                return true;
            }
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Double, Double>> {
        final long[] tab;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            long[] tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                long key = tab[nextI];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = new ImmutableEntry(key, tab[nextI + 1]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Double, Double>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Map.Entry<Double, Double>)((Object)new ImmutableEntry(key, tab[i + 1])));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Double, Double> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                long[] tab = this.tab;
                ImmutableEntry prev = this.next;
                while ((nextI -= 2) >= 0) {
                    long key = tab[nextI];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.next = new ImmutableEntry(key, tab[nextI + 1]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractDoubleValueView {
        ValueView() {
        }

        public int size() {
            return ImmutableQHashParallelKVDoubleDoubleMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableQHashParallelKVDoubleDoubleMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return ImmutableQHashParallelKVDoubleDoubleMapGO.this.containsValue(o);
        }

        public boolean contains(double v) {
            return ImmutableQHashParallelKVDoubleDoubleMapGO.this.containsValue(v);
        }

        public boolean contains(long bits) {
            return ImmutableQHashParallelKVDoubleDoubleMapGO.this.containsValue(bits);
        }

        public void forEach(Consumer<? super Double> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long[] tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Double)Double.longBitsToDouble(tab[i + 1]));
            }
        }

        public void forEach(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long[] tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Double.longBitsToDouble(tab[i + 1]));
            }
        }

        public boolean forEachWhile(DoublePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            long[] tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL || predicate.test(Double.longBitsToDouble(tab[i + 1]))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        public boolean allContainingIn(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.allContainingIn((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            long[] tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL || c.contains(Double.longBitsToDouble(tab[i + 1]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            long[] tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL || c.contains(tab[i + 1])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.reverseAddAllTo((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long[] tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add(Double.longBitsToDouble(tab[i + 1]));
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long[] tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add(tab[i + 1]);
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(DoubleSet s) {
            if (s instanceof InternalDoubleCollectionOps) {
                return this.reverseRemoveAllFrom((InternalDoubleCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long[] tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.removeDouble(Double.longBitsToDouble(tab[i + 1]));
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalDoubleCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long[] tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.removeDouble(tab[i + 1]);
            }
            return changed;
        }

        @Nonnull
        public DoubleIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public DoubleCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long[] tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = Double.longBitsToDouble(tab[i + 1]);
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            long[] tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = Double.longBitsToDouble(tab[i + 1]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public double[] toDoubleArray() {
            int size = this.size();
            double[] result = new double[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long[] tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = Double.longBitsToDouble(tab[i + 1]);
            }
            return result;
        }

        public double[] toArray(double[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new double[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0;
                }
                return a;
            }
            int resultIndex = 0;
            long[] tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = Double.longBitsToDouble(tab[i + 1]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            long[] tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                sb.append(' ').append(Double.longBitsToDouble(tab[i + 1])).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeDouble((Double)o);
        }

        public boolean removeDouble(double v) {
            return ImmutableQHashParallelKVDoubleDoubleMapGO.this.removeValue(v);
        }

        public boolean removeDouble(long bits) {
            return ImmutableQHashParallelKVDoubleDoubleMapGO.this.removeValue(bits);
        }

        public void clear() {
            ImmutableQHashParallelKVDoubleDoubleMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Double> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(DoublePredicate filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends DoubleDoubleEntry {
        private long key;
        private long value;

        ReusableEntry() {
        }

        ReusableEntry with(long key, long value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends DoubleDoubleEntry {
        private final long key;
        private final long value;

        ImmutableEntry(long key, long value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    abstract class DoubleDoubleEntry
    extends AbstractEntry<Double, Double> {
        DoubleDoubleEntry() {
        }

        abstract long key();

        public final Double getKey() {
            return Double.longBitsToDouble(this.key());
        }

        abstract long value();

        public final Double getValue() {
            return Double.longBitsToDouble(this.value());
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                long k2 = Double.doubleToLongBits((Double)e2.getKey());
                long v2 = Double.doubleToLongBits((Double)e2.getValue());
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((long)this.key()) ^ Primitives.hashCode((long)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Double, Double>>
    implements HashObjSet<Map.Entry<Double, Double>>,
    InternalObjCollectionOps<Map.Entry<Double, Double>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Double, Double>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableQHashParallelKVDoubleDoubleMapGO.this.hashConfig();
        }

        public int size() {
            return ImmutableQHashParallelKVDoubleDoubleMapGO.this.size;
        }

        public double currentLoad() {
            return ImmutableQHashParallelKVDoubleDoubleMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableQHashParallelKVDoubleDoubleMapGO.this.containsEntry((Double)e.getKey(), (Double)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long[] tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = new ImmutableEntry(key, tab[i + 1]);
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            long[] tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = new ImmutableEntry(key, tab[i + 1]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Double, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long[] tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Map.Entry<Double, Double>)((Object)new ImmutableEntry(key, tab[i + 1])));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Double, Double>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            long[] tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || predicate.test((Map.Entry<Double, Double>)((Object)new ImmutableEntry(key, tab[i + 1])))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Double, Double>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Double, Double>> cursor() {
            return new NoRemovedEntryCursor();
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            long[] tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || c.contains((Object)e.with(key, tab[i + 1]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            long[] tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.remove((Object)e.with(key, tab[i + 1]));
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Double, Double>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long[] tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add((Object)new ImmutableEntry(key, tab[i + 1]));
            }
            return changed;
        }

        public int hashCode() {
            return ImmutableQHashParallelKVDoubleDoubleMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            long[] tab = ImmutableQHashParallelKVDoubleDoubleMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                sb.append(' ');
                sb.append(Double.longBitsToDouble(key));
                sb.append('=');
                sb.append(Double.longBitsToDouble(tab[i + 1]));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableQHashParallelKVDoubleDoubleMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                double key = (Double)e.getKey();
                double value = (Double)e.getValue();
                return ImmutableQHashParallelKVDoubleDoubleMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Double, Double>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

