/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.impl.PrimitiveConstants;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.HashConfigWrapper;
import com.koloboke.collect.impl.hash.ImmutableLHash;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.ParallelKVShortLHash;

public abstract class ImmutableParallelKVShortLHashSO
extends ImmutableLHash
implements ParallelKVShortLHash,
PrimitiveConstants,
UnsafeConstants {
    short freeValue;
    int[] table;

    void copy(ParallelKVShortLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.table = (int[])hash.table().clone();
    }

    void move(ParallelKVShortLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.table = hash.table();
    }

    final void init(HashConfigWrapper configWrapper, int size, short freeValue) {
        this.freeValue = freeValue;
        super.init(configWrapper, size);
    }

    @Override
    public short freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return false;
    }

    @Override
    public short removedValue() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object key) {
        return this.contains((Short)key);
    }

    public boolean contains(short key) {
        return this.index(key) >= 0;
    }

    int index(short key) {
        short free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVShortKeyMixing.mix((short)key) & capacityMask;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            do {
                if ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return index;
            } while (cur != free);
            return -1;
        }
        return -1;
    }
}

