/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.ByteCollection;
import com.koloboke.collect.ByteCursor;
import com.koloboke.collect.ByteIterator;
import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractByteValueView;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonIntByteMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalIntByteMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.ImmutableLHashSeparateKVIntByteMapSO;
import com.koloboke.collect.impl.hash.SeparateKVIntByteLHash;
import com.koloboke.collect.map.IntByteCursor;
import com.koloboke.collect.set.ByteSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.ByteBinaryOperator;
import com.koloboke.function.ByteConsumer;
import com.koloboke.function.BytePredicate;
import com.koloboke.function.IntByteConsumer;
import com.koloboke.function.IntBytePredicate;
import com.koloboke.function.IntByteToByteFunction;
import com.koloboke.function.IntToByteFunction;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class ImmutableLHashSeparateKVIntByteMapGO
extends ImmutableLHashSeparateKVIntByteMapSO {
    @Override
    final void copy(SeparateKVIntByteLHash hash) {
        int hashMC = hash.modCount();
        super.copy(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVIntByteLHash hash) {
        int hashMC = hash.modCount();
        super.move(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public byte defaultValue() {
        return 0;
    }

    public boolean containsEntry(int key, byte value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public Byte get(Object key) {
        int index = this.index((Integer)key);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public byte get(int key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    public Byte getOrDefault(Object key, Byte defaultValue) {
        int index = this.index((Integer)key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public byte getOrDefault(int key, byte defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Integer, ? super Byte> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int free = this.freeValue;
        int[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            action.accept((Integer)key, (Byte)vals[i]);
        }
    }

    public void forEach(IntByteConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int free = this.freeValue;
        int[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            action.accept(key, vals[i]);
        }
    }

    public boolean forEachWhile(IntBytePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int free = this.freeValue;
        int[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free || predicate.test(key, vals[i])) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public IntByteCursor cursor() {
        return new NoRemovedMapCursor();
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonIntByteMapOps.containsAllEntries((InternalIntByteMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalIntByteMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int free = this.freeValue;
        int[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalIntByteMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int free = this.freeValue;
        int[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Integer, Byte>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ByteCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int free = this.freeValue;
        int[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            hashCode += key ^ vals[i];
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int free = this.freeValue;
        int[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    public Byte put(Integer key, Byte value) {
        throw new UnsupportedOperationException();
    }

    public byte put(int key, byte value) {
        throw new UnsupportedOperationException();
    }

    public Byte putIfAbsent(Integer key, Byte value) {
        throw new UnsupportedOperationException();
    }

    public byte putIfAbsent(int key, byte value) {
        throw new UnsupportedOperationException();
    }

    public void justPut(int key, byte value) {
        throw new UnsupportedOperationException();
    }

    public Byte compute(Integer key, BiFunction<? super Integer, ? super Byte, ? extends Byte> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte compute(int key, IntByteToByteFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Byte computeIfAbsent(Integer key, Function<? super Integer, ? extends Byte> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte computeIfAbsent(int key, IntToByteFunction mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Byte computeIfPresent(Integer key, BiFunction<? super Integer, ? super Byte, ? extends Byte> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte computeIfPresent(int key, IntByteToByteFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Byte merge(Integer key, Byte value, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte merge(int key, byte value, ByteBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte addValue(int key, byte value) {
        throw new UnsupportedOperationException();
    }

    public byte addValue(int key, byte addition, byte initialValue) {
        throw new UnsupportedOperationException();
    }

    public void putAll(@Nonnull Map<? extends Integer, ? extends Byte> m) {
        CommonIntByteMapOps.putAll((InternalIntByteMapOps)this, m);
    }

    public Byte replace(Integer key, Byte value) {
        throw new UnsupportedOperationException();
    }

    public byte replace(int key, byte value) {
        throw new UnsupportedOperationException();
    }

    public boolean replace(Integer key, Byte oldValue, Byte newValue) {
        return this.replace((int)key, (byte)oldValue, (byte)newValue);
    }

    public boolean replace(int key, byte oldValue, byte newValue) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(BiFunction<? super Integer, ? super Byte, ? extends Byte> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(IntByteToByteFunction function) {
        throw new UnsupportedOperationException();
    }

    public Byte remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(int key) {
        throw new UnsupportedOperationException();
    }

    public byte remove(int key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Integer)key, (Byte)value);
    }

    public boolean remove(int key, byte value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(IntBytePredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements IntByteCursor {
        final int[] keys;
        final byte[] vals;
        final int free;
        int index;
        int curKey;
        byte curValue;

        NoRemovedMapCursor() {
            int free;
            this.keys = ImmutableLHashSeparateKVIntByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVIntByteMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVIntByteMapGO.this.freeValue);
        }

        public void forEachForward(IntByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int[] keys = this.keys;
            byte[] vals = this.vals;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int key() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public byte value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(byte value) {
            if (this.curKey == this.free) {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            int[] keys = this.keys;
            int free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements ByteCursor {
        final int[] keys;
        final byte[] vals;
        final int free;
        int index;
        int curKey;
        byte curValue;

        NoRemovedValueCursor() {
            int free;
            this.keys = ImmutableLHashSeparateKVIntByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVIntByteMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVIntByteMapGO.this.freeValue);
        }

        public void forEachForward(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int[] keys = this.keys;
            byte[] vals = this.vals;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            int[] keys = this.keys;
            int free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements ByteIterator {
        final int[] keys;
        final byte[] vals;
        final int free;
        int nextIndex;
        byte next;

        NoRemovedValueIterator() {
            this.keys = ImmutableLHashSeparateKVIntByteMapGO.this.set;
            int[] keys = ImmutableLHashSeparateKVIntByteMapGO.this.set;
            this.vals = ImmutableLHashSeparateKVIntByteMapGO.this.values;
            byte[] vals = ImmutableLHashSeparateKVIntByteMapGO.this.values;
            int free = this.free = ImmutableLHashSeparateKVIntByteMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public byte nextByte() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int[] keys = this.keys;
                int free = this.free;
                byte prev = this.next;
                while (--nextI >= 0) {
                    if (keys[nextI] == free) continue;
                    this.next = this.vals[nextI];
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Byte> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int[] keys = this.keys;
            byte[] vals = this.vals;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Byte)vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(ByteConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int[] keys = this.keys;
            byte[] vals = this.vals;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Byte next() {
            return this.nextByte();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Integer, Byte>> {
        final int[] keys;
        final byte[] vals;
        final int free;
        int index;
        int curKey;
        byte curValue;

        NoRemovedEntryCursor() {
            int free;
            this.keys = ImmutableLHashSeparateKVIntByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVIntByteMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVIntByteMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Integer, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int[] keys = this.keys;
            byte[] vals = this.vals;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Integer, Byte>)((Object)new ImmutableEntry(key, vals[i])));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Integer, Byte> elem() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            int[] keys = this.keys;
            int free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Integer, Byte>> {
        final int[] keys;
        final byte[] vals;
        final int free;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.keys = ImmutableLHashSeparateKVIntByteMapGO.this.set;
            int[] keys = ImmutableLHashSeparateKVIntByteMapGO.this.set;
            this.vals = ImmutableLHashSeparateKVIntByteMapGO.this.values;
            byte[] vals = ImmutableLHashSeparateKVIntByteMapGO.this.values;
            int free = this.free = ImmutableLHashSeparateKVIntByteMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                int key = keys[nextI];
                if (key == free) continue;
                this.next = new ImmutableEntry(key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Integer, Byte>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int[] keys = this.keys;
            byte[] vals = this.vals;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Integer, Byte>)((Object)new ImmutableEntry(key, vals[i])));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Integer, Byte> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int[] keys = this.keys;
                int free = this.free;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    int key = keys[nextI];
                    if (key == free) continue;
                    this.next = new ImmutableEntry(key, this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractByteValueView {
        ValueView() {
        }

        public int size() {
            return ImmutableLHashSeparateKVIntByteMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableLHashSeparateKVIntByteMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return ImmutableLHashSeparateKVIntByteMapGO.this.containsValue(o);
        }

        public boolean contains(byte v) {
            return ImmutableLHashSeparateKVIntByteMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Byte> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int free = ImmutableLHashSeparateKVIntByteMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVIntByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Byte)vals[i]);
            }
        }

        public void forEach(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int free = ImmutableLHashSeparateKVIntByteMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVIntByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
        }

        public boolean forEachWhile(BytePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int free = ImmutableLHashSeparateKVIntByteMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVIntByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        public boolean allContainingIn(ByteCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int free = ImmutableLHashSeparateKVIntByteMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVIntByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(ByteCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int free = ImmutableLHashSeparateKVIntByteMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVIntByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(ByteSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int free = ImmutableLHashSeparateKVIntByteMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVIntByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeByte(vals[i]);
            }
            return changed;
        }

        @Nonnull
        public ByteIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public ByteCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int free = ImmutableLHashSeparateKVIntByteMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVIntByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int free = ImmutableLHashSeparateKVIntByteMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVIntByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public byte[] toByteArray() {
            int size = this.size();
            byte[] result = new byte[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int free = ImmutableLHashSeparateKVIntByteMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVIntByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        public byte[] toArray(byte[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new byte[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int free = ImmutableLHashSeparateKVIntByteMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVIntByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int free = ImmutableLHashSeparateKVIntByteMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVIntByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeByte((Byte)o);
        }

        public boolean removeByte(byte v) {
            return ImmutableLHashSeparateKVIntByteMapGO.this.removeValue(v);
        }

        public void clear() {
            ImmutableLHashSeparateKVIntByteMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Byte> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(BytePredicate filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends IntByteEntry {
        private int key;
        private byte value;

        ReusableEntry() {
        }

        ReusableEntry with(int key, byte value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends IntByteEntry {
        private final int key;
        private final byte value;

        ImmutableEntry(int key, byte value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }
    }

    abstract class IntByteEntry
    extends AbstractEntry<Integer, Byte> {
        IntByteEntry() {
        }

        abstract int key();

        public final Integer getKey() {
            return this.key();
        }

        abstract byte value();

        public final Byte getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                int k2 = (Integer)e2.getKey();
                byte v2 = (Byte)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((int)this.key()) ^ Primitives.hashCode((byte)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Integer, Byte>>
    implements HashObjSet<Map.Entry<Integer, Byte>>,
    InternalObjCollectionOps<Map.Entry<Integer, Byte>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Integer, Byte>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableLHashSeparateKVIntByteMapGO.this.hashConfig();
        }

        public int size() {
            return ImmutableLHashSeparateKVIntByteMapGO.this.size;
        }

        public double currentLoad() {
            return ImmutableLHashSeparateKVIntByteMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableLHashSeparateKVIntByteMapGO.this.containsEntry((Integer)e.getKey(), (Byte)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int free = ImmutableLHashSeparateKVIntByteMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVIntByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int free = ImmutableLHashSeparateKVIntByteMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVIntByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Integer, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int free = ImmutableLHashSeparateKVIntByteMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVIntByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Integer, Byte>)((Object)new ImmutableEntry(key, vals[i])));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Integer, Byte>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int free = ImmutableLHashSeparateKVIntByteMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVIntByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || predicate.test((Map.Entry<Integer, Byte>)((Object)new ImmutableEntry(key, vals[i])))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Integer, Byte>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Integer, Byte>> cursor() {
            return new NoRemovedEntryCursor();
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int free = ImmutableLHashSeparateKVIntByteMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVIntByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int free = ImmutableLHashSeparateKVIntByteMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVIntByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Integer, Byte>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int free = ImmutableLHashSeparateKVIntByteMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVIntByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new ImmutableEntry(key, vals[i]));
            }
            return changed;
        }

        public int hashCode() {
            return ImmutableLHashSeparateKVIntByteMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int free = ImmutableLHashSeparateKVIntByteMapGO.this.freeValue;
            int[] keys = ImmutableLHashSeparateKVIntByteMapGO.this.set;
            byte[] vals = ImmutableLHashSeparateKVIntByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableLHashSeparateKVIntByteMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                int key = (Integer)e.getKey();
                byte value = (Byte)e.getValue();
                return ImmutableLHashSeparateKVIntByteMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Integer, Byte>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

