/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.Equivalence;
import com.koloboke.collect.FloatCollection;
import com.koloboke.collect.FloatCursor;
import com.koloboke.collect.FloatIterator;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractFloatValueView;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonCharFloatMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalCharFloatMapOps;
import com.koloboke.collect.impl.InternalFloatCollectionOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.ImmutableLHashSeparateKVCharFloatMapSO;
import com.koloboke.collect.impl.hash.SeparateKVCharFloatLHash;
import com.koloboke.collect.map.CharFloatCursor;
import com.koloboke.collect.set.FloatSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.CharFloatConsumer;
import com.koloboke.function.CharFloatPredicate;
import com.koloboke.function.CharFloatToFloatFunction;
import com.koloboke.function.CharToFloatFunction;
import com.koloboke.function.FloatBinaryOperator;
import com.koloboke.function.FloatConsumer;
import com.koloboke.function.FloatPredicate;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class ImmutableLHashSeparateKVCharFloatMapGO
extends ImmutableLHashSeparateKVCharFloatMapSO {
    @Override
    final void copy(SeparateKVCharFloatLHash hash) {
        int hashMC = hash.modCount();
        super.copy(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVCharFloatLHash hash) {
        int hashMC = hash.modCount();
        super.move(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public float defaultValue() {
        return 0.0f;
    }

    public boolean containsEntry(char key, float value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == Float.floatToIntBits(value);
        }
        return false;
    }

    public boolean containsEntry(char key, int value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public Float get(Object key) {
        int index = this.index(((Character)key).charValue());
        if (index >= 0) {
            return Float.valueOf(Float.intBitsToFloat(this.values[index]));
        }
        return null;
    }

    public float get(char key) {
        int index = this.index(key);
        if (index >= 0) {
            return Float.intBitsToFloat(this.values[index]);
        }
        return this.defaultValue();
    }

    public Float getOrDefault(Object key, Float defaultValue) {
        int index = this.index(((Character)key).charValue());
        if (index >= 0) {
            return Float.valueOf(Float.intBitsToFloat(this.values[index]));
        }
        return defaultValue;
    }

    public float getOrDefault(char key, float defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return Float.intBitsToFloat(this.values[index]);
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Character, ? super Float> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        char free = this.freeValue;
        char[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            action.accept(Character.valueOf(key), Float.valueOf(Float.intBitsToFloat(vals[i])));
        }
    }

    public void forEach(CharFloatConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        char free = this.freeValue;
        char[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            action.accept(key, Float.intBitsToFloat(vals[i]));
        }
    }

    public boolean forEachWhile(CharFloatPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        char free = this.freeValue;
        char[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free || predicate.test(key, Float.intBitsToFloat(vals[i]))) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public CharFloatCursor cursor() {
        return new NoRemovedMapCursor();
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonCharFloatMapOps.containsAllEntries((InternalCharFloatMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalCharFloatMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        char free = this.freeValue;
        char[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalCharFloatMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        char free = this.freeValue;
        char[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Character, Float>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public FloatCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        char free = this.freeValue;
        char[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            hashCode += key ^ vals[i];
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        char free = this.freeValue;
        char[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(Float.intBitsToFloat(vals[i]));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    public Float put(Character key, Float value) {
        throw new UnsupportedOperationException();
    }

    public float put(char key, float value) {
        throw new UnsupportedOperationException();
    }

    public Float putIfAbsent(Character key, Float value) {
        throw new UnsupportedOperationException();
    }

    public float putIfAbsent(char key, float value) {
        throw new UnsupportedOperationException();
    }

    public void justPut(char key, float value) {
        throw new UnsupportedOperationException();
    }

    public void justPut(char key, int value) {
        throw new UnsupportedOperationException();
    }

    public Float compute(Character key, BiFunction<? super Character, ? super Float, ? extends Float> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public float compute(char key, CharFloatToFloatFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Float computeIfAbsent(Character key, Function<? super Character, ? extends Float> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public float computeIfAbsent(char key, CharToFloatFunction mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Float computeIfPresent(Character key, BiFunction<? super Character, ? super Float, ? extends Float> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public float computeIfPresent(char key, CharFloatToFloatFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Float merge(Character key, Float value, BiFunction<? super Float, ? super Float, ? extends Float> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public float merge(char key, float value, FloatBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public float addValue(char key, float value) {
        throw new UnsupportedOperationException();
    }

    public float addValue(char key, float addition, float initialValue) {
        throw new UnsupportedOperationException();
    }

    public void putAll(@Nonnull Map<? extends Character, ? extends Float> m) {
        CommonCharFloatMapOps.putAll((InternalCharFloatMapOps)this, m);
    }

    public Float replace(Character key, Float value) {
        throw new UnsupportedOperationException();
    }

    public float replace(char key, float value) {
        throw new UnsupportedOperationException();
    }

    public boolean replace(Character key, Float oldValue, Float newValue) {
        return this.replace(key.charValue(), oldValue.floatValue(), newValue.floatValue());
    }

    public boolean replace(char key, float oldValue, float newValue) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(BiFunction<? super Character, ? super Float, ? extends Float> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(CharFloatToFloatFunction function) {
        throw new UnsupportedOperationException();
    }

    public Float remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(char key) {
        throw new UnsupportedOperationException();
    }

    public float remove(char key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        return this.remove(((Character)key).charValue(), ((Float)value).floatValue());
    }

    public boolean remove(char key, float value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(CharFloatPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements CharFloatCursor {
        final char[] keys;
        final int[] vals;
        final char free;
        int index;
        char curKey;
        int curValue;

        NoRemovedMapCursor() {
            char free;
            this.keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue);
        }

        public void forEachForward(CharFloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept(key, Float.intBitsToFloat(vals[i]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char key() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public float value() {
            if (this.curKey != this.free) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(float value) {
            if (this.curKey == this.free) {
                throw new IllegalStateException();
            }
            this.vals[this.index] = Float.floatToIntBits(value);
        }

        public boolean moveNext() {
            char[] keys = this.keys;
            char free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements FloatCursor {
        final char[] keys;
        final int[] vals;
        final char free;
        int index;
        char curKey;
        int curValue;

        NoRemovedValueCursor() {
            char free;
            this.keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue);
        }

        public void forEachForward(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Float.intBitsToFloat(vals[i]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public float elem() {
            if (this.curKey != this.free) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            char[] keys = this.keys;
            char free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements FloatIterator {
        final char[] keys;
        final int[] vals;
        final char free;
        int nextIndex;
        float next;

        NoRemovedValueIterator() {
            this.keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            char[] keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            this.vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            int[] vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            char free = this.free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = Float.intBitsToFloat(vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public float nextFloat() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                char[] keys = this.keys;
                char free = this.free;
                float prev = this.next;
                while (--nextI >= 0) {
                    if (keys[nextI] == free) continue;
                    this.next = Float.intBitsToFloat(this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Float> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Float.valueOf(Float.intBitsToFloat(vals[i])));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(FloatConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Float.intBitsToFloat(vals[i]));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Float next() {
            return Float.valueOf(this.nextFloat());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Character, Float>> {
        final char[] keys;
        final int[] vals;
        final char free;
        int index;
        char curKey;
        int curValue;

        NoRemovedEntryCursor() {
            char free;
            this.keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            this.curKey = free = (this.free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Character, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Character, Float>)((Object)new ImmutableEntry(key, vals[i])));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Character, Float> elem() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            char[] keys = this.keys;
            char free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Character, Float>> {
        final char[] keys;
        final int[] vals;
        final char free;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            char[] keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            this.vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            int[] vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            char free = this.free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                char key = keys[nextI];
                if (key == free) continue;
                this.next = new ImmutableEntry(key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Character, Float>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Character, Float>)((Object)new ImmutableEntry(key, vals[i])));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Character, Float> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                char[] keys = this.keys;
                char free = this.free;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    char key = keys[nextI];
                    if (key == free) continue;
                    this.next = new ImmutableEntry(key, this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractFloatValueView {
        ValueView() {
        }

        public int size() {
            return ImmutableLHashSeparateKVCharFloatMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableLHashSeparateKVCharFloatMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return ImmutableLHashSeparateKVCharFloatMapGO.this.containsValue(o);
        }

        public boolean contains(float v) {
            return ImmutableLHashSeparateKVCharFloatMapGO.this.containsValue(v);
        }

        public boolean contains(int bits) {
            return ImmutableLHashSeparateKVCharFloatMapGO.this.containsValue(bits);
        }

        public void forEach(Consumer<? super Float> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            char free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Float.valueOf(Float.intBitsToFloat(vals[i])));
            }
        }

        public void forEach(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            char free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Float.intBitsToFloat(vals[i]));
            }
        }

        public boolean forEachWhile(FloatPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            char free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(Float.intBitsToFloat(vals[i]))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        public boolean allContainingIn(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.allContainingIn((InternalFloatCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            char free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(Float.intBitsToFloat(vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalFloatCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            char free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.reverseAddAllTo((InternalFloatCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            char free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(Float.intBitsToFloat(vals[i]));
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalFloatCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            char free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(FloatSet s) {
            if (s instanceof InternalFloatCollectionOps) {
                return this.reverseRemoveAllFrom((InternalFloatCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            char free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeFloat(Float.intBitsToFloat(vals[i]));
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalFloatCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            char free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeFloat(vals[i]);
            }
            return changed;
        }

        @Nonnull
        public FloatIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public FloatCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            char free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = Float.valueOf(Float.intBitsToFloat(vals[i]));
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            char free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = Float.valueOf(Float.intBitsToFloat(vals[i]));
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public float[] toFloatArray() {
            int size = this.size();
            float[] result = new float[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            char free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = Float.intBitsToFloat(vals[i]);
            }
            return result;
        }

        public float[] toArray(float[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new float[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0f;
                }
                return a;
            }
            int resultIndex = 0;
            char free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = Float.intBitsToFloat(vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0f;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            char free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                sb.append(' ').append(Float.intBitsToFloat(vals[i])).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeFloat(((Float)o).floatValue());
        }

        public boolean removeFloat(float v) {
            return ImmutableLHashSeparateKVCharFloatMapGO.this.removeValue(v);
        }

        public boolean removeFloat(int bits) {
            return ImmutableLHashSeparateKVCharFloatMapGO.this.removeValue(bits);
        }

        public void clear() {
            ImmutableLHashSeparateKVCharFloatMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Float> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(FloatPredicate filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends CharFloatEntry {
        private char key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(char key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends CharFloatEntry {
        private final char key;
        private final int value;

        ImmutableEntry(char key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    abstract class CharFloatEntry
    extends AbstractEntry<Character, Float> {
        CharFloatEntry() {
        }

        abstract char key();

        public final Character getKey() {
            return Character.valueOf(this.key());
        }

        abstract int value();

        public final Float getValue() {
            return Float.valueOf(Float.intBitsToFloat(this.value()));
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                char k2 = ((Character)e2.getKey()).charValue();
                int v2 = Float.floatToIntBits(((Float)e2.getValue()).floatValue());
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((char)this.key()) ^ Primitives.hashCode((int)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Character, Float>>
    implements HashObjSet<Map.Entry<Character, Float>>,
    InternalObjCollectionOps<Map.Entry<Character, Float>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Character, Float>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableLHashSeparateKVCharFloatMapGO.this.hashConfig();
        }

        public int size() {
            return ImmutableLHashSeparateKVCharFloatMapGO.this.size;
        }

        public double currentLoad() {
            return ImmutableLHashSeparateKVCharFloatMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableLHashSeparateKVCharFloatMapGO.this.containsEntry(((Character)e.getKey()).charValue(), ((Float)e.getValue()).floatValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            char free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            char free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Character, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            char free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Character, Float>)((Object)new ImmutableEntry(key, vals[i])));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Character, Float>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            char free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || predicate.test((Map.Entry<Character, Float>)((Object)new ImmutableEntry(key, vals[i])))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Character, Float>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Character, Float>> cursor() {
            return new NoRemovedEntryCursor();
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            char free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            char free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Character, Float>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            char free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new ImmutableEntry(key, vals[i]));
            }
            return changed;
        }

        public int hashCode() {
            return ImmutableLHashSeparateKVCharFloatMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            char free = ImmutableLHashSeparateKVCharFloatMapGO.this.freeValue;
            char[] keys = ImmutableLHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = ImmutableLHashSeparateKVCharFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(Float.intBitsToFloat(vals[i]));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableLHashSeparateKVCharFloatMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                char key = ((Character)e.getKey()).charValue();
                float value = ((Float)e.getValue()).floatValue();
                return ImmutableLHashSeparateKVCharFloatMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Character, Float>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

