/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.Equivalence;
import com.koloboke.collect.FloatCollection;
import com.koloboke.collect.FloatCursor;
import com.koloboke.collect.FloatIterator;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractFloatValueView;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonIntFloatMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalFloatCollectionOps;
import com.koloboke.collect.impl.InternalIntFloatMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.ImmutableLHashParallelKVIntFloatMapSO;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.ParallelKVIntFloatLHash;
import com.koloboke.collect.map.IntFloatCursor;
import com.koloboke.collect.set.FloatSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.FloatBinaryOperator;
import com.koloboke.function.FloatConsumer;
import com.koloboke.function.FloatPredicate;
import com.koloboke.function.IntFloatConsumer;
import com.koloboke.function.IntFloatPredicate;
import com.koloboke.function.IntFloatToFloatFunction;
import com.koloboke.function.IntToFloatFunction;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class ImmutableLHashParallelKVIntFloatMapGO
extends ImmutableLHashParallelKVIntFloatMapSO {
    final void copy(ParallelKVIntFloatLHash hash) {
        int hashMC = hash.modCount();
        super.copy(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVIntFloatLHash hash) {
        int hashMC = hash.modCount();
        super.move(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public float defaultValue() {
        return 0.0f;
    }

    public boolean containsEntry(int key, float value) {
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix((int)key) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == key) {
                return (int)(entry >>> 32) == Float.floatToIntBits(value);
            }
            if (cur == free) {
                return false;
            }
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (int)(entry >>> 32) == Float.floatToIntBits(value);
            } while (cur != free);
            return false;
        }
        return false;
    }

    public boolean containsEntry(int key, int value) {
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix((int)key) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == key) {
                return (int)(entry >>> 32) == value;
            }
            if (cur == free) {
                return false;
            }
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (int)(entry >>> 32) == value;
            } while (cur != free);
            return false;
        }
        return false;
    }

    public Float get(Object key) {
        int free;
        int k = (Integer)key;
        if (k != (free = this.freeValue)) {
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix((int)k) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == k) {
                return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (cur == free) {
                return null;
            }
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            } while (cur != free);
            return null;
        }
        return null;
    }

    public float get(int key) {
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix((int)key) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == key) {
                return Float.intBitsToFloat((int)(entry >>> 32));
            }
            if (cur == free) {
                return this.defaultValue();
            }
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return Float.intBitsToFloat((int)(entry >>> 32));
            } while (cur != free);
            return this.defaultValue();
        }
        return this.defaultValue();
    }

    public Float getOrDefault(Object key, Float defaultValue) {
        int free;
        int k = (Integer)key;
        if (k != (free = this.freeValue)) {
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix((int)k) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == k) {
                return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (cur == free) {
                return defaultValue;
            }
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            } while (cur != free);
            return defaultValue;
        }
        return defaultValue;
    }

    public float getOrDefault(int key, float defaultValue) {
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix((int)key) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == key) {
                return Float.intBitsToFloat((int)(entry >>> 32));
            }
            if (cur == free) {
                return defaultValue;
            }
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return Float.intBitsToFloat((int)(entry >>> 32));
            } while (cur != free);
            return defaultValue;
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Integer, ? super Float> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            action.accept((Integer)key, Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))));
        }
    }

    public void forEach(IntFloatConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            action.accept(key, Float.intBitsToFloat((int)(entry >>> 32)));
        }
    }

    public boolean forEachWhile(IntFloatPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free || predicate.test(key, Float.intBitsToFloat((int)(entry >>> 32)))) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public IntFloatCursor cursor() {
        return new NoRemovedMapCursor();
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonIntFloatMapOps.containsAllEntries((InternalIntFloatMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalIntFloatMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free || m.containsEntry(key, (int)(entry >>> 32))) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalIntFloatMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            m.justPut(key, (int)(entry >>> 32));
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Integer, Float>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public FloatCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            hashCode += key ^ (int)(entry >>> 32);
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(Float.intBitsToFloat((int)(entry >>> 32)));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    public Float put(Integer key, Float value) {
        throw new UnsupportedOperationException();
    }

    public float put(int key, float value) {
        throw new UnsupportedOperationException();
    }

    public Float putIfAbsent(Integer key, Float value) {
        throw new UnsupportedOperationException();
    }

    public float putIfAbsent(int key, float value) {
        throw new UnsupportedOperationException();
    }

    public void justPut(int key, float value) {
        throw new UnsupportedOperationException();
    }

    public void justPut(int key, int value) {
        throw new UnsupportedOperationException();
    }

    public Float compute(Integer key, BiFunction<? super Integer, ? super Float, ? extends Float> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public float compute(int key, IntFloatToFloatFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Float computeIfAbsent(Integer key, Function<? super Integer, ? extends Float> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public float computeIfAbsent(int key, IntToFloatFunction mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Float computeIfPresent(Integer key, BiFunction<? super Integer, ? super Float, ? extends Float> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public float computeIfPresent(int key, IntFloatToFloatFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Float merge(Integer key, Float value, BiFunction<? super Float, ? super Float, ? extends Float> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public float merge(int key, float value, FloatBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public float addValue(int key, float value) {
        throw new UnsupportedOperationException();
    }

    public float addValue(int key, float addition, float initialValue) {
        throw new UnsupportedOperationException();
    }

    public void putAll(@Nonnull Map<? extends Integer, ? extends Float> m) {
        CommonIntFloatMapOps.putAll((InternalIntFloatMapOps)this, m);
    }

    public Float replace(Integer key, Float value) {
        throw new UnsupportedOperationException();
    }

    public float replace(int key, float value) {
        throw new UnsupportedOperationException();
    }

    public boolean replace(Integer key, Float oldValue, Float newValue) {
        return this.replace((int)key, oldValue.floatValue(), newValue.floatValue());
    }

    public boolean replace(int key, float oldValue, float newValue) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(BiFunction<? super Integer, ? super Float, ? extends Float> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(IntFloatToFloatFunction function) {
        throw new UnsupportedOperationException();
    }

    public Float remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(int key) {
        throw new UnsupportedOperationException();
    }

    public float remove(int key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Integer)key, ((Float)value).floatValue());
    }

    public boolean remove(int key, float value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(IntFloatPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements IntFloatCursor {
        final long[] tab;
        final int free;
        int index;
        int curKey;
        int curValue;

        NoRemovedMapCursor() {
            int free;
            this.tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue);
        }

        public void forEachForward(IntFloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept(key, Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int key() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public float value() {
            if (this.curKey != this.free) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(float value) {
            if (this.curKey == this.free) {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_VALUE_OFFSET + ((long)this.index << 3), Float.floatToIntBits(value));
        }

        public boolean moveNext() {
            long[] tab = this.tab;
            int free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (int)(entry >>> 32);
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements FloatCursor {
        final long[] tab;
        final int free;
        int index;
        int curKey;
        int curValue;

        NoRemovedValueCursor() {
            int free;
            this.tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue);
        }

        public void forEachForward(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public float elem() {
            if (this.curKey != this.free) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            long[] tab = this.tab;
            int free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (int)(entry >>> 32);
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements FloatIterator {
        final long[] tab;
        final int free;
        int nextIndex;
        float next;

        NoRemovedValueIterator() {
            this.tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            long[] tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            int free = this.free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                if ((int)entry == free) continue;
                this.next = Float.intBitsToFloat((int)(entry >>> 32));
                break;
            }
            this.nextIndex = nextI;
        }

        public float nextFloat() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                long[] tab = this.tab;
                int free = this.free;
                float prev = this.next;
                while (--nextI >= 0) {
                    long entry = tab[nextI];
                    if ((int)entry == free) continue;
                    this.next = Float.intBitsToFloat((int)(entry >>> 32));
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Float> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept(Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(FloatConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Float next() {
            return Float.valueOf(this.nextFloat());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Integer, Float>> {
        final long[] tab;
        final int free;
        int index;
        int curKey;
        int curValue;

        NoRemovedEntryCursor() {
            int free;
            this.tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Integer, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Integer, Float>)((Object)new ImmutableEntry(key, (int)(entry >>> 32))));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Integer, Float> elem() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            long[] tab = this.tab;
            int free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (int)(entry >>> 32);
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Integer, Float>> {
        final long[] tab;
        final int free;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            long[] tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            int free = this.free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                int key = (int)entry;
                if (key == free) continue;
                this.next = new ImmutableEntry(key, (int)(entry >>> 32));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Integer, Float>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Integer, Float>)((Object)new ImmutableEntry(key, (int)(entry >>> 32))));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Integer, Float> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                long[] tab = this.tab;
                int free = this.free;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    long entry = tab[nextI];
                    int key = (int)entry;
                    if (key == free) continue;
                    this.next = new ImmutableEntry(key, (int)(entry >>> 32));
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractFloatValueView {
        ValueView() {
        }

        public int size() {
            return ImmutableLHashParallelKVIntFloatMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableLHashParallelKVIntFloatMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return ImmutableLHashParallelKVIntFloatMapGO.this.containsValue(o);
        }

        public boolean contains(float v) {
            return ImmutableLHashParallelKVIntFloatMapGO.this.containsValue(v);
        }

        public boolean contains(int bits) {
            return ImmutableLHashParallelKVIntFloatMapGO.this.containsValue(bits);
        }

        public void forEach(Consumer<? super Float> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept(Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))));
            }
        }

        public void forEach(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept(Float.intBitsToFloat((int)(entry >>> 32)));
            }
        }

        public boolean forEachWhile(FloatPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free || predicate.test(Float.intBitsToFloat((int)(entry >>> 32)))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        public boolean allContainingIn(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.allContainingIn((InternalFloatCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free || c.contains(Float.intBitsToFloat((int)(entry >>> 32)))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalFloatCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free || c.contains((int)(entry >>> 32))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.reverseAddAllTo((InternalFloatCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                changed |= c.add(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalFloatCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                changed |= c.add((int)(entry >>> 32));
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(FloatSet s) {
            if (s instanceof InternalFloatCollectionOps) {
                return this.reverseRemoveAllFrom((InternalFloatCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                changed |= s.removeFloat(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalFloatCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                changed |= s.removeFloat((int)(entry >>> 32));
            }
            return changed;
        }

        @Nonnull
        public FloatIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public FloatCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                result[resultIndex++] = Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                a[resultIndex++] = Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public float[] toFloatArray() {
            int size = this.size();
            float[] result = new float[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                result[resultIndex++] = Float.intBitsToFloat((int)(entry >>> 32));
            }
            return result;
        }

        public float[] toArray(float[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new float[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0f;
                }
                return a;
            }
            int resultIndex = 0;
            int free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                a[resultIndex++] = Float.intBitsToFloat((int)(entry >>> 32));
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0f;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                sb.append(' ').append(Float.intBitsToFloat((int)(entry >>> 32))).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeFloat(((Float)o).floatValue());
        }

        public boolean removeFloat(float v) {
            return ImmutableLHashParallelKVIntFloatMapGO.this.removeValue(v);
        }

        public boolean removeFloat(int bits) {
            return ImmutableLHashParallelKVIntFloatMapGO.this.removeValue(bits);
        }

        public void clear() {
            ImmutableLHashParallelKVIntFloatMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Float> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(FloatPredicate filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends IntFloatEntry {
        private int key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(int key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends IntFloatEntry {
        private final int key;
        private final int value;

        ImmutableEntry(int key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    abstract class IntFloatEntry
    extends AbstractEntry<Integer, Float> {
        IntFloatEntry() {
        }

        abstract int key();

        public final Integer getKey() {
            return this.key();
        }

        abstract int value();

        public final Float getValue() {
            return Float.valueOf(Float.intBitsToFloat(this.value()));
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                int k2 = (Integer)e2.getKey();
                int v2 = Float.floatToIntBits(((Float)e2.getValue()).floatValue());
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((int)this.key()) ^ Primitives.hashCode((int)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Integer, Float>>
    implements HashObjSet<Map.Entry<Integer, Float>>,
    InternalObjCollectionOps<Map.Entry<Integer, Float>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Integer, Float>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableLHashParallelKVIntFloatMapGO.this.hashConfig();
        }

        public int size() {
            return ImmutableLHashParallelKVIntFloatMapGO.this.size;
        }

        public double currentLoad() {
            return ImmutableLHashParallelKVIntFloatMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableLHashParallelKVIntFloatMapGO.this.containsEntry((int)((Integer)e.getKey()), ((Float)e.getValue()).floatValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                result[resultIndex++] = new ImmutableEntry(key, (int)(entry >>> 32));
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                a[resultIndex++] = new ImmutableEntry(key, (int)(entry >>> 32));
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Integer, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Integer, Float>)((Object)new ImmutableEntry(key, (int)(entry >>> 32))));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Integer, Float>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || predicate.test((Map.Entry<Integer, Float>)((Object)new ImmutableEntry(key, (int)(entry >>> 32))))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Integer, Float>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Integer, Float>> cursor() {
            return new NoRemovedEntryCursor();
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || c.contains((Object)e.with(key, (int)(entry >>> 32)))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, (int)(entry >>> 32)));
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Integer, Float>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                changed |= c.add((Object)new ImmutableEntry(key, (int)(entry >>> 32)));
            }
            return changed;
        }

        public int hashCode() {
            return ImmutableLHashParallelKVIntFloatMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int free = ImmutableLHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = ImmutableLHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(Float.intBitsToFloat((int)(entry >>> 32)));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableLHashParallelKVIntFloatMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                int key = (Integer)e.getKey();
                float value = ((Float)e.getValue()).floatValue();
                return ImmutableLHashParallelKVIntFloatMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Integer, Float>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

