/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.vsock;

import java.io.File;
import java.io.IOException;
import org.newsclub.net.unix.AFServerSocket;
import org.newsclub.net.unix.AFServerSocketConnector;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFVSOCKSocketAddress;
import org.newsclub.net.unix.AddressUnavailableSocketException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AFVSOCKProxyServerSocketConnector
implements AFServerSocketConnector<AFVSOCKSocketAddress, AFSocketAddress> {
    private static final AFServerSocketConnector<AFVSOCKSocketAddress, AFSocketAddress> DIRECT_CONNECTOR = new AFServerSocketConnector<AFVSOCKSocketAddress, AFSocketAddress>(){

        public AFServerSocket<? extends AFSocketAddress> bind(AFVSOCKSocketAddress addr) throws IOException {
            return addr.newForceBoundServerSocket();
        }
    };
    private final String listenAddressPrefix;
    private final int allowedCID;

    private AFVSOCKProxyServerSocketConnector(String listenAddressPrefix, int allowedCID) {
        this.listenAddressPrefix = listenAddressPrefix;
        this.allowedCID = allowedCID;
    }

    public static AFServerSocketConnector<AFVSOCKSocketAddress, AFSocketAddress> openFirecrackerStyleConnector(File listenAddressPrefix, int allowedCID) {
        return new AFVSOCKProxyServerSocketConnector(listenAddressPrefix.getAbsolutePath(), allowedCID);
    }

    public static AFServerSocketConnector<AFVSOCKSocketAddress, AFSocketAddress> openDirectConnector() {
        return DIRECT_CONNECTOR;
    }

    public AFServerSocket<?> bind(AFVSOCKSocketAddress addr) throws IOException {
        int cid = addr.getVSOCKCID();
        if (cid != this.allowedCID && cid != -1 && this.allowedCID != -1) {
            throw new AddressUnavailableSocketException("Factory does not cover CID " + cid);
        }
        return AFUNIXSocketAddress.of((File)new File(this.listenAddressPrefix + "_" + addr.getVSOCKPort())).newForceBoundServerSocket();
    }
}

