/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.tipc;

import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.atomic.AtomicBoolean;
import org.newsclub.net.unix.AFSocketType;
import org.newsclub.net.unix.AFTIPCSocketAddress;
import org.newsclub.net.unix.tipc.AFTIPCDatagramChannel;
import org.newsclub.net.unix.tipc.AFTIPCDatagramSocket;
import org.newsclub.net.unix.tipc.AFTIPCTopologyEvent;
import org.newsclub.net.unix.tipc.AFTIPCTopologySubscription;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AFTIPCTopologyWatcher
implements Closeable {
    private final int defaultTimeout;
    private final AFTIPCDatagramChannel channel;
    private final Selector selector;
    private final AtomicBoolean doLoop = new AtomicBoolean(false);
    private final AtomicBoolean running = new AtomicBoolean(false);

    public AFTIPCTopologyWatcher() throws IOException {
        this(-1);
    }

    public AFTIPCTopologyWatcher(int defaultTimeoutSeconds) throws IOException {
        this.defaultTimeout = defaultTimeoutSeconds;
        this.channel = AFTIPCDatagramSocket.newInstance(AFSocketType.SOCK_SEQPACKET).getChannel();
        this.selector = this.channel.provider().openSelector();
        this.channel.connect((SocketAddress)AFTIPCSocketAddress.ofTopologyService());
        this.channel.configureBlocking(false);
    }

    public final AFTIPCTopologySubscription addPortSubscription() throws IOException {
        return this.addPortSubscription(0, -1);
    }

    public final AFTIPCTopologySubscription addPortSubscription(int port) throws IOException {
        return this.addPortSubscription(port, port);
    }

    public final AFTIPCTopologySubscription addPortSubscription(int lower, int upper) throws IOException {
        return this.sendMessage(new AFTIPCTopologySubscription(0, lower, upper, AFTIPCTopologySubscription.Flags.TIPC_SUB_PORTS, this.defaultTimeout, AFTIPCTopologySubscription.USR_EMPTY));
    }

    public final AFTIPCTopologySubscription addLinkStateSubscription() throws IOException {
        return this.sendMessage(new AFTIPCTopologySubscription(2, 0, -1, AFTIPCTopologySubscription.Flags.NONE, this.defaultTimeout, AFTIPCTopologySubscription.USR_EMPTY));
    }

    public final AFTIPCTopologySubscription addServiceSubscription(int type) throws IOException {
        return this.addServiceSubscription(type, 0, -1);
    }

    public final AFTIPCTopologySubscription addServiceSubscription(int type, int instance) throws IOException {
        return this.addServiceSubscription(type, instance, instance);
    }

    public final AFTIPCTopologySubscription addServiceSubscription(int type, int lower, int upper) throws IOException {
        return this.sendMessage(new AFTIPCTopologySubscription(type, lower, upper, AFTIPCTopologySubscription.Flags.TIPC_SUB_SERVICE, this.defaultTimeout, AFTIPCTopologySubscription.USR_EMPTY));
    }

    public final void cancelSubscription(AFTIPCTopologySubscription sub) throws IOException {
        this.sendMessage(sub.toCancellation());
    }

    public final AFTIPCTopologySubscription sendMessage(AFTIPCTopologySubscription sub) throws IOException {
        this.channel.write(sub.toBuffer());
        return sub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runLoop() throws IOException {
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException("Already running");
        }
        ByteBuffer buf = ByteBuffer.allocate(64);
        SelectionKey key = this.channel.register(this.selector, 1);
        try {
            this.doLoop.set(true);
            while (!Thread.interrupted() && this.doLoop.get()) {
                int n = this.selector.select();
                if (!key.isValid()) break;
                if (!this.doLoop.get()) {
                    break;
                }
                if (n <= 0) continue;
                this.channel.receive(buf);
                AFTIPCTopologyEvent event = AFTIPCTopologyEvent.readFromBuffer(buf.flip());
                this.onEvent(event);
                buf.clear();
            }
        }
        finally {
            key.cancel();
            this.running.set(false);
        }
    }

    protected void onEvent(AFTIPCTopologyEvent event) throws IOException {
    }

    protected void onClose() throws IOException {
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public final void stopLoop() {
        this.doLoop.set(false);
        this.selector.wakeup();
    }

    @Override
    public final void close() throws IOException {
        this.channel.close();
        this.stopLoop();
        this.onClose();
    }
}

