/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.tipc;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.WeakHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.newsclub.net.unix.AFTIPCSocketAddress;
import org.newsclub.net.unix.NamedIntegerBitmask;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NonNullByDefault
public final class AFTIPCTopologySubscription {
    static final byte[] USR_EMPTY = new byte[8];
    private static final WeakHashMap<ByteBuffer, @Nullable AFTIPCTopologySubscription> SUBSCRIPTIONS = new WeakHashMap();
    public static final int TIPC_WAIT_FOREVER = -1;
    public static final int TIPC_NODE_STATE = 0;
    public static final int TIPC_LINK_STATE = 2;
    private static final int MESSAGE_LENGTH = 28;
    private final int type;
    private final int lower;
    private final int upper;
    private final Flags flags;
    private final int timeout;
    private final byte[] usrHandle;

    public AFTIPCTopologySubscription(int type, int lower, int upper, Flags flags) {
        this(type, lower, upper, flags, -1, USR_EMPTY);
    }

    public AFTIPCTopologySubscription(int type, int lower, int upper, Flags flags, int timeoutSeconds) {
        this(type, lower, upper, flags, timeoutSeconds, USR_EMPTY);
    }

    public AFTIPCTopologySubscription(int type, int lower, int upper, Flags flags, int timeoutSeconds, byte[] usrHandle) {
        this.type = type;
        this.lower = lower;
        this.upper = upper;
        this.flags = flags == null ? Flags.NONE : flags;
        this.timeout = timeoutSeconds;
        this.usrHandle = new byte[8];
        if (usrHandle != null) {
            if (usrHandle.length > 8) {
                throw new IllegalArgumentException("User handle too long");
            }
            System.arraycopy(usrHandle, 0, this.usrHandle, 0, usrHandle.length);
        }
    }

    static AFTIPCTopologySubscription readFromBuffer(ByteBuffer buf) {
        AFTIPCTopologySubscription sub = SUBSCRIPTIONS.get(buf = buf.slice().limit(28));
        if (sub != null) {
            return sub;
        }
        int type = buf.getInt();
        int lower = buf.getInt();
        int upper = buf.getInt();
        int timeout = buf.getInt();
        Flags flags = Flags.ofValue(buf.getInt());
        byte[] usrHandle = new byte[8];
        buf.get(usrHandle, 0, 8);
        buf.flip();
        sub = new AFTIPCTopologySubscription(type, lower, upper, flags, timeout, usrHandle);
        SUBSCRIPTIONS.put(buf, sub);
        return sub;
    }

    ByteBuffer writeToBuffer(ByteBuffer buf) {
        buf = buf.order(ByteOrder.BIG_ENDIAN);
        buf.putInt(this.type);
        buf.putInt(this.lower);
        buf.putInt(this.upper);
        buf.putInt(this.timeout);
        buf.putInt(this.flags.value());
        buf.put(this.usrHandle);
        return buf;
    }

    public ByteBuffer toBuffer() {
        return this.writeToBuffer(ByteBuffer.allocate(28)).flip();
    }

    public String toString() {
        return super.toString() + "[" + this.type + "@" + AFTIPCSocketAddress.AddressType.formatTIPCInt((int)this.lower) + "-" + AFTIPCSocketAddress.AddressType.formatTIPCInt((int)this.upper) + ";flags=" + String.valueOf((Object)this.flags) + ";timeout=" + this.timeout + ";usrHandle=" + String.format(Locale.ENGLISH, "%16s", new BigInteger(1, this.usrHandle).toString(16)).replace(' ', '0') + "]";
    }

    public AFTIPCTopologySubscription toCancellation() {
        return new AFTIPCTopologySubscription(this.type, this.lower, this.upper, Flags.TIPC_SUB_CANCEL, this.timeout, this.usrHandle);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.usrHandle);
        result = 31 * result + Objects.hash(new Object[]{this.flags, this.lower, this.timeout, this.type, this.upper});
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AFTIPCTopologySubscription)) {
            return false;
        }
        AFTIPCTopologySubscription other = (AFTIPCTopologySubscription)obj;
        return Objects.equals((Object)this.flags, (Object)other.flags) && this.lower == other.lower && this.timeout == other.timeout && this.type == other.type && this.upper == other.upper && Arrays.equals(this.usrHandle, other.usrHandle);
    }

    public int getType() {
        return this.type;
    }

    public int getLower() {
        return this.lower;
    }

    public int getUpper() {
        return this.upper;
    }

    public Flags getFlags() {
        return this.flags;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public byte[] getUsrHandle() {
        return (byte[])this.usrHandle.clone();
    }

    public boolean isPort() {
        return this.flags.hasFlag(Flags.TIPC_SUB_PORTS);
    }

    public boolean isService() {
        return this.flags.hasFlag(Flags.TIPC_SUB_SERVICE);
    }

    public boolean isCancellation() {
        return this.flags.hasFlag(Flags.TIPC_SUB_CANCEL);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class Flags
    extends NamedIntegerBitmask<Flags> {
        private static final long serialVersionUID = 1L;
        public static final Flags NONE = new Flags("NONE", 0);
        public static final Flags TIPC_SUB_PORTS = new Flags("TIPC_SUB_PORTS", 1);
        public static final Flags TIPC_SUB_SERVICE = new Flags("TIPC_SUB_SERVICE", 2);
        public static final Flags TIPC_SUB_CANCEL = new Flags("TIPC_SUB_CANCEL", 4);
        private static final @NonNull Flags[] VALUES = new Flags[]{TIPC_SUB_PORTS, TIPC_SUB_SERVICE, TIPC_SUB_CANCEL};

        private Flags(@Nullable String name, int flags) {
            super(name, flags);
        }

        public static Flags ofValue(int v) {
            return (Flags)Flags.resolve((NamedIntegerBitmask[])VALUES, (NamedIntegerBitmask)NONE, Flags::new, (int)v);
        }

        public static Flags withFlags(Flags ... flags) {
            return (Flags)Flags.resolve((NamedIntegerBitmask[])VALUES, (NamedIntegerBitmask)NONE, Flags::new, (NamedIntegerBitmask[])flags);
        }

        public Flags combineWith(Flags other) {
            return (Flags)this.combineWith(VALUES, NONE, Flags::new, other);
        }
    }
}

