/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.tipc;

import java.io.Serializable;
import java.net.SocketException;
import org.newsclub.net.unix.AFTIPCSocketAddress;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AFTIPCDestName
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int type;
    private final int lower;
    private final int upper;

    public AFTIPCDestName(int type, int lower, int upper) {
        this.type = type;
        this.lower = lower;
        this.upper = upper;
    }

    public int getType() {
        return this.type;
    }

    public int getLower() {
        return this.lower;
    }

    public int getUpper() {
        return this.upper;
    }

    public boolean isServiceRange() {
        return this.lower != this.upper;
    }

    public AFTIPCSocketAddress toSocketAddress(AFTIPCSocketAddress.Scope scope, boolean alwaysRange) {
        try {
            if (alwaysRange || this.isServiceRange()) {
                return AFTIPCSocketAddress.ofServiceRange((AFTIPCSocketAddress.Scope)scope, (int)this.type, (int)this.lower, (int)this.upper);
            }
            return AFTIPCSocketAddress.ofService((AFTIPCSocketAddress.Scope)scope, (int)this.type, (int)this.lower);
        }
        catch (SocketException e) {
            throw new IllegalStateException(e);
        }
    }

    static AFTIPCDestName of(int[] tipcDestName) {
        if (tipcDestName == null) {
            return null;
        }
        if (tipcDestName.length != 3) {
            throw new IllegalArgumentException();
        }
        return new AFTIPCDestName(tipcDestName[0], tipcDestName[1], tipcDestName[2]);
    }
}

