/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.tipc;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.TestAbortedWithImportantMessageException;
import java.io.IOException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketCapabilityRequirement;
import org.newsclub.net.unix.AFTIPCSocketAddress;
import org.newsclub.net.unix.tipc.AFTIPCAddressSpecifics;
import org.newsclub.net.unix.tipc.AFTIPCDatagramChannel;
import org.newsclub.net.unix.tipc.AFTIPCDatagramSocket;
import org.newsclub.net.unix.tipc.AFTIPCGroupRequest;
import org.newsclub.net.unix.tipc.AFTIPCSocketOptions;
import org.opentest4j.AssertionFailedError;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_TIPC})
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION", "NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"})
public final class SocketOptionsTest
extends org.newsclub.net.unix.SocketOptionsTest<AFTIPCSocketAddress> {
    public SocketOptionsTest() throws IOException {
        super(AFTIPCAddressSpecifics.INSTANCE);
    }

    @Test
    public void testTIPCConnTimeout() throws Exception {
        Socket socket = this.newSocket();
        int timeout = (Integer)socket.getOption(AFTIPCSocketOptions.TIPC_CONN_TIMEOUT);
        int newTimeout = this.getRandom().nextInt(8000) + 1;
        if (newTimeout == timeout) {
            ++newTimeout;
        }
        socket.setOption(AFTIPCSocketOptions.TIPC_CONN_TIMEOUT, newTimeout);
        Assertions.assertEquals((int)newTimeout, (Integer)((Integer)socket.getOption(AFTIPCSocketOptions.TIPC_CONN_TIMEOUT)));
        socket.setOption(AFTIPCSocketOptions.TIPC_CONN_TIMEOUT, timeout);
        Assertions.assertEquals((int)timeout, (Integer)((Integer)socket.getOption(AFTIPCSocketOptions.TIPC_CONN_TIMEOUT)));
    }

    @Test
    public void testTIPCImportance() throws Exception {
        Socket socket = this.newSocket();
        AFTIPCSocketOptions.MessageImportance imp = (AFTIPCSocketOptions.MessageImportance)socket.getOption(AFTIPCSocketOptions.TIPC_IMPORTANCE);
        socket.setOption(AFTIPCSocketOptions.TIPC_IMPORTANCE, AFTIPCSocketOptions.MessageImportance.HIGH);
        Assertions.assertEquals((Object)AFTIPCSocketOptions.MessageImportance.HIGH, socket.getOption(AFTIPCSocketOptions.TIPC_IMPORTANCE));
        socket.setOption(AFTIPCSocketOptions.TIPC_IMPORTANCE, imp);
        Assertions.assertThrows(SocketException.class, () -> socket.setOption(AFTIPCSocketOptions.TIPC_IMPORTANCE, AFTIPCSocketOptions.MessageImportance.ofValue((int)129)));
        Assertions.assertEquals((Object)imp, socket.getOption(AFTIPCSocketOptions.TIPC_IMPORTANCE));
    }

    @Test
    public void testTIPCSourceDroppable() throws Exception {
        AFTIPCDatagramSocket socket = (AFTIPCDatagramSocket)this.newDatagramSocket();
        boolean droppable = (Boolean)socket.getOption(AFTIPCSocketOptions.TIPC_SRC_DROPPABLE);
        Assertions.assertTrue((boolean)droppable, (String)"Datagram messages should be droppable by default");
        socket.setOption(AFTIPCSocketOptions.TIPC_SRC_DROPPABLE, (Object)(!droppable ? 1 : 0));
        Assertions.assertEquals((Object)(!droppable ? 1 : 0), (Object)socket.getOption(AFTIPCSocketOptions.TIPC_SRC_DROPPABLE));
    }

    @Test
    public void testTIPCDestDroppable() throws Exception {
        AFTIPCDatagramSocket socket = (AFTIPCDatagramSocket)this.newDatagramSocket();
        boolean droppable = (Boolean)socket.getOption(AFTIPCSocketOptions.TIPC_DEST_DROPPABLE);
        Assertions.assertTrue((boolean)droppable, (String)"Datagram messages should be droppable by default");
        socket.setOption(AFTIPCSocketOptions.TIPC_DEST_DROPPABLE, (Object)(!droppable ? 1 : 0));
        Assertions.assertEquals((Object)(!droppable ? 1 : 0), (Object)socket.getOption(AFTIPCSocketOptions.TIPC_DEST_DROPPABLE));
    }

    @Test
    public void testTIPCNodelay() throws Exception {
        Socket socket = this.newSocket();
        try {
            socket.getOption(AFTIPCSocketOptions.TIPC_NODELAY);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Test
    public void testGroupJoinLeave() throws Exception {
        DatagramChannel socket = this.newDatagramChannel();
        try {
            try {
                Assertions.assertEquals((Object)AFTIPCGroupRequest.NONE, socket.getOption(AFTIPCSocketOptions.TIPC_GROUP_JOIN));
            }
            catch (SocketException e) {
                Assumptions.assumeTrue((boolean)false, (String)"Not supported by kernel");
                if (socket != null) {
                    socket.close();
                }
                return;
            }
            socket.setOption((SocketOption)AFTIPCSocketOptions.TIPC_GROUP_JOIN, AFTIPCGroupRequest.with((int)4711, (int)0, (AFTIPCSocketAddress.Scope)AFTIPCSocketAddress.Scope.SCOPE_NODE, (AFTIPCGroupRequest.GroupRequestFlags)AFTIPCGroupRequest.GroupRequestFlags.NONE));
            Assertions.assertEquals((int)4711, (int)((AFTIPCGroupRequest)socket.getOption(AFTIPCSocketOptions.TIPC_GROUP_JOIN)).getType());
            try {
                socket.write(ByteBuffer.allocate(64));
            }
            catch (NoRouteToHostException noRouteToHostException) {
                // empty catch block
            }
            socket.setOption((SocketOption)AFTIPCSocketOptions.TIPC_GROUP_LEAVE, AFTIPCSocketOptions.VOID);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    @Test
    public void testGroupLoopback() throws Exception {
        AFTIPCDatagramChannel socket = (AFTIPCDatagramChannel)this.newDatagramChannel();
        try {
            try {
                Assertions.assertEquals((Object)AFTIPCGroupRequest.NONE, (Object)socket.getOption((SocketOption)AFTIPCSocketOptions.TIPC_GROUP_JOIN));
            }
            catch (SocketException e) {
                Assumptions.assumeTrue((boolean)false, (String)"Not supported by kernel");
                if (socket != null) {
                    socket.close();
                }
                return;
            }
            socket.setOption((SocketOption)AFTIPCSocketOptions.TIPC_GROUP_JOIN, (Object)AFTIPCGroupRequest.with((int)4712, (int)0, (AFTIPCSocketAddress.Scope)AFTIPCSocketAddress.Scope.SCOPE_NODE, (AFTIPCGroupRequest.GroupRequestFlags)AFTIPCGroupRequest.GroupRequestFlags.GROUP_LOOPBACK));
            Assertions.assertEquals((int)4712, (int)((AFTIPCGroupRequest)socket.getOption((SocketOption)AFTIPCSocketOptions.TIPC_GROUP_JOIN)).getType());
            ByteBuffer sendBuffer = ByteBuffer.allocate(8192);
            try {
                socket.write(sendBuffer);
            }
            catch (NoRouteToHostException e) {
                throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, "Kernel may be too old for full TIPC support", (Throwable)e);
            }
            ByteBuffer recvBuffer = ByteBuffer.allocate(16384);
            int len = socket.read(recvBuffer);
            if (len > 0) {
                Assertions.assertEquals((int)sendBuffer.position(), (int)len);
                Assertions.assertEquals((int)recvBuffer.position(), (int)len);
            }
            sendBuffer.clear();
            recvBuffer.clear();
            socket.send(sendBuffer, null);
            AFTIPCSocketAddress sa = (AFTIPCSocketAddress)socket.receive(recvBuffer);
            Assertions.assertEquals((Object)socket.getLocalAddress(), (Object)sa);
            if (len > 0) {
                Assertions.assertEquals((int)sendBuffer.position(), (int)len);
                Assertions.assertEquals((int)recvBuffer.position(), (int)len);
            }
            socket.setOption((SocketOption)AFTIPCSocketOptions.TIPC_GROUP_LEAVE, (Object)AFTIPCSocketOptions.VOID);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    @Test
    public void testCommunication() throws Exception {
        try (DatagramChannel socket1 = this.newDatagramChannel();
             DatagramChannel socket2 = this.newDatagramChannel();){
            socket1.setOption((SocketOption)AFTIPCSocketOptions.TIPC_DEST_DROPPABLE, (Object)false);
            socket2.setOption((SocketOption)AFTIPCSocketOptions.TIPC_DEST_DROPPABLE, (Object)false);
            ByteBuffer sendBuffer = ByteBuffer.allocate(8192);
            ByteBuffer recvBuffer = ByteBuffer.allocate(16384);
            socket1.send(sendBuffer, socket2.getLocalAddress());
            Assertions.assertEquals((Object)socket1.getLocalAddress(), (Object)socket2.receive(recvBuffer));
        }
    }

    @Test
    public void testGroupCommunication() throws Exception {
        try (DatagramChannel socket1 = this.newDatagramChannel();
             DatagramChannel socket2 = this.newDatagramChannel();){
            socket1.setOption((SocketOption)AFTIPCSocketOptions.TIPC_DEST_DROPPABLE, (Object)false);
            socket2.setOption((SocketOption)AFTIPCSocketOptions.TIPC_DEST_DROPPABLE, (Object)false);
            socket1.setOption((SocketOption)AFTIPCSocketOptions.TIPC_GROUP_JOIN, AFTIPCGroupRequest.with((int)4713, (int)0, (AFTIPCSocketAddress.Scope)AFTIPCSocketAddress.Scope.SCOPE_NODE, (AFTIPCGroupRequest.GroupRequestFlags)AFTIPCGroupRequest.GroupRequestFlags.NONE));
            socket2.setOption((SocketOption)AFTIPCSocketOptions.TIPC_GROUP_JOIN, AFTIPCGroupRequest.with((int)4713, (int)0, (AFTIPCSocketAddress.Scope)AFTIPCSocketAddress.Scope.SCOPE_NODE, (AFTIPCGroupRequest.GroupRequestFlags)AFTIPCGroupRequest.GroupRequestFlags.NONE));
            ByteBuffer sendBuffer = ByteBuffer.allocate(8192);
            ByteBuffer recvBuffer = ByteBuffer.allocate(16384);
            int sent = socket1.write(sendBuffer);
            CompletableFuture receiveAddrFuture = new CompletableFuture();
            try {
                Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> receiveAddrFuture.complete(socket2.receive(recvBuffer)));
            }
            catch (AssertionFailedError e) {
                throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, "Kernel may be too old for full TIPC support", (Throwable)e);
            }
            Assertions.assertEquals((Object)socket1.getLocalAddress(), receiveAddrFuture.get());
            Assertions.assertEquals((int)sent, (int)sendBuffer.position());
            Assertions.assertEquals((int)sent, (int)recvBuffer.position());
        }
    }
}

