/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import java.io.IOException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.newsclub.net.unix.rmi.AFNaming;
import org.newsclub.net.unix.rmi.AFRMISocketFactory;
import org.newsclub.net.unix.rmi.AFRegistry;
import org.newsclub.net.unix.rmi.AFUNIXNaming;
import org.newsclub.net.unix.rmi.AFUNIXRMISocketFactory;
import org.newsclub.net.unix.rmi.ShutdownHookTestBase;
import org.newsclub.net.unix.rmi.TestService;
import org.newsclub.net.unix.rmi.TestServiceImpl;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TestBase
extends ShutdownHookTestBase {
    private static final String TEST_SERVICE_NAME = TestService.class.getName();
    private AFNaming naming;
    private TestServiceImpl testService;

    protected TestBase() {
    }

    protected AFNaming newNamingTestInstance() throws IOException {
        return AFUNIXNaming.newPrivateInstance();
    }

    @Deprecated
    protected final void finalize() {
    }

    @BeforeEach
    public void setUp() throws IOException, AlreadyBoundException {
        this.naming = this.newNamingTestInstance();
        AFRegistry registry = this.naming.createRegistry();
        AFRMISocketFactory sf = this.naming.getSocketFactory();
        this.testService = sf instanceof AFUNIXRMISocketFactory ? new TestServiceImpl((AFUNIXRMISocketFactory)sf) : null;
        registry.bind(TEST_SERVICE_NAME, RemoteObject.toStub(this.testService));
    }

    @AfterEach
    public void tearDown() throws IOException {
        if (this.testService != null) {
            this.testService.close();
        }
        if (this.naming != null) {
            this.naming.shutdownRegistry();
        }
    }

    protected TestService lookupTestService() throws AccessException, RemoteException, NotBoundException {
        return (TestService)this.naming.getRegistry().lookup(TEST_SERVICE_NAME);
    }

    protected AFRMISocketFactory namingSocketFactory() {
        return this.naming.getSocketFactory();
    }
}

